/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.block.door;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.block.door.InternalDoorBlock;
import whocraft.tardis_refined.common.blockentity.door.GlobalDoorBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.tardis.manager.AestheticHandler;

public class GlobalDoorBlock
extends InternalDoorBlock {
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)0.25);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.75, (double)16.0, (double)32.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)15.75, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.25, (double)32.0, (double)16.0);

    public GlobalDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OFFSET, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        this.setBlockEntity(new GlobalDoorBlockEntity(blockPos, blockState));
        return super.m_142194_(blockPos, blockState);
    }

    @Override
    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        super.m_6807_(blockState, level, blockPos, blockState2, bl);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TardisLevelOperator.get(serverLevel).ifPresent(tardisLevelOperator -> {
                BlockEntity block = level.m_7702_(blockPos);
                AestheticHandler aesthetics = tardisLevelOperator.getAestheticHandler();
                if (block instanceof GlobalDoorBlockEntity) {
                    GlobalDoorBlockEntity globalDoorBlockEntity = (GlobalDoorBlockEntity)block;
                    globalDoorBlockEntity.setShellTheme(aesthetics.getShellTheme());
                    globalDoorBlockEntity.setPattern(aesthetics.shellPattern());
                    globalDoorBlockEntity.sendUpdates();
                }
            });
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
    }

    @Override
    public BlockState m_5573_(@NotNull BlockPlaceContext blockPlaceContext) {
        return super.m_5573_(blockPlaceContext);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockEntity blockEntity;
        ServerLevel serverLevel;
        if (interactionHand == InteractionHand.MAIN_HAND && !player.m_9236_().m_5776_() && level instanceof ServerLevel && TardisLevelOperator.get(serverLevel = (ServerLevel)level).isPresent() && (blockEntity = serverLevel.m_7702_(blockPos)) instanceof GlobalDoorBlockEntity) {
            GlobalDoorBlockEntity entity = (GlobalDoorBlockEntity)blockEntity;
            entity.onRightClick(blockState, entity, player);
            return InteractionResult.m_19078_((boolean)false);
        }
        return InteractionResult.m_19078_((boolean)true);
    }

    @Override
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return switch ((Direction)blockState.m_61143_((Property)FACING)) {
            case Direction.EAST -> {
                if (((Boolean)blockState.m_61143_((Property)OFFSET)).booleanValue()) {
                    yield EAST_AABB.m_83216_(0.0, 0.0, -0.5);
                }
                yield EAST_AABB;
            }
            case Direction.SOUTH -> {
                if (((Boolean)blockState.m_61143_((Property)OFFSET)).booleanValue()) {
                    yield SOUTH_AABB.m_83216_(0.5, 0.0, 0.0);
                }
                yield SOUTH_AABB;
            }
            case Direction.WEST -> {
                if (((Boolean)blockState.m_61143_((Property)OFFSET)).booleanValue()) {
                    yield WEST_AABB.m_83216_(0.0, 0.0, 0.5);
                }
                yield WEST_AABB;
            }
            case Direction.NORTH -> {
                if (((Boolean)blockState.m_61143_((Property)OFFSET)).booleanValue()) {
                    yield NORTH_AABB.m_83216_(-0.5, 0.0, 0.0);
                }
                yield NORTH_AABB;
            }
            default -> SOUTH_AABB;
        };
    }

    @Override
    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.m_5940_(blockState, blockGetter, blockPos, collisionContext);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return (level1, blockPos, stage, t) -> {
            if (t instanceof GlobalDoorBlockEntity) {
                GlobalDoorBlockEntity globalDoorBlockEntity = (GlobalDoorBlockEntity)t;
                globalDoorBlockEntity.tick(level1, blockPos, stage, globalDoorBlockEntity);
            }
        };
    }
}

