/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.block.device;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.items.ScrewdriverItem;
import whocraft.tardis_refined.common.tardis.TardisDesktops;
import whocraft.tardis_refined.common.tardis.manager.TardisInteriorManager;
import whocraft.tardis_refined.registry.TRDimensionTypes;
import whocraft.tardis_refined.registry.TRSoundRegistry;

public class TerraformerBlock
extends Block {
    public static BooleanProperty ACTIVE = BlockStateProperties.f_61448_;
    public static VoxelShape SHAPE = Stream.of(Stream.of(Block.m_49796_((double)0.5, (double)5.0, (double)13.5, (double)2.5, (double)10.0, (double)15.5), Block.m_49796_((double)1.5, (double)10.0, (double)13.5, (double)1.5, (double)18.0, (double)15.5), Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)5.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get(), Stream.of(Block.m_49796_((double)0.5, (double)5.0, (double)0.5, (double)2.5, (double)10.0, (double)2.5), Block.m_49796_((double)1.5, (double)10.0, (double)0.5, (double)1.5, (double)18.0, (double)2.5), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)5.0, (double)3.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get(), Stream.of(Block.m_49796_((double)13.5, (double)5.0, (double)0.5, (double)15.5, (double)10.0, (double)2.5), Block.m_49796_((double)14.5, (double)10.0, (double)0.5, (double)14.5, (double)18.0, (double)2.5), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)3.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get(), Stream.of(Block.m_49796_((double)13.5, (double)5.0, (double)13.5, (double)15.5, (double)10.0, (double)15.5), Block.m_49796_((double)14.5, (double)10.0, (double)13.5, (double)14.5, (double)18.0, (double)15.5), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)5.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get(), Stream.of(Block.m_49796_((double)12.5, (double)17.5, (double)12.5, (double)16.5, (double)21.5, (double)16.5), Block.m_49796_((double)0.0, (double)19.0, (double)0.0, (double)16.0, (double)19.0, (double)16.0), Block.m_49796_((double)12.5, (double)17.5, (double)-0.5, (double)16.5, (double)21.5, (double)3.5), Block.m_49796_((double)-0.5, (double)17.5, (double)-0.5, (double)3.5, (double)21.5, (double)3.5), Block.m_49796_((double)-0.5, (double)17.5, (double)12.5, (double)3.5, (double)21.5, (double)16.5), Block.m_49796_((double)2.0, (double)17.0, (double)2.0, (double)14.0, (double)20.0, (double)14.0), Block.m_49796_((double)5.0, (double)15.5, (double)5.0, (double)11.0, (double)17.5, (double)11.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get(), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public TerraformerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE});
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        super.m_6807_(blockState, level, blockPos, blockState2, bl);
        if (((Boolean)blockState.m_61143_((Property)ACTIVE)).booleanValue()) {
            return;
        }
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.m_61143_((Property)ACTIVE)).booleanValue()) {
            for (int particleCount = 0; particleCount < 3; ++particleCount) {
                double particleX = (double)blockPos.m_123341_() + randomSource.m_188500_();
                double particleY = (double)blockPos.m_123342_() + randomSource.m_188500_() * 0.5 + 0.5;
                double particleZ = (double)blockPos.m_123343_() + randomSource.m_188500_();
                level.m_7106_((ParticleOptions)ParticleTypes.f_123747_, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        super.m_6810_(blockState, level, blockPos, blockState2, bl);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (((Boolean)blockState.m_61143_((Property)ACTIVE)).booleanValue()) {
                TardisLevelOperator.get(serverLevel).ifPresent(cap -> {
                    TardisInteriorManager interiorManager = cap.getInteriorManager();
                    if (interiorManager.isWaitingToGenerate()) {
                        interiorManager.cancelDesktopChange();
                    }
                });
            }
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level instanceof ServerLevel) {
            Item item;
            ServerLevel serverLevel = (ServerLevel)level;
            if (interactionHand == InteractionHand.MAIN_HAND && (item = player.m_21205_().m_41720_()) instanceof ScrewdriverItem) {
                ScrewdriverItem screwdriverItem = (ScrewdriverItem)item;
                screwdriverItem.playScrewdriverSound(serverLevel, blockPos, TRSoundRegistry.SCREWDRIVER_SHORT.get());
                if (this.checkIfStructure((Level)serverLevel, blockPos)) {
                    TardisLevelOperator.get(serverLevel).ifPresent(cap -> {
                        TardisInteriorManager interiorManager = cap.getInteriorManager();
                        if (interiorManager.isWaitingToGenerate()) {
                            level.m_46961_(blockPos, true);
                        } else if (cap.getTardisState() == 0) {
                            interiorManager.prepareDesktop(TardisDesktops.TERRAFORMED);
                            this.destroyStructure((Level)serverLevel, blockPos);
                            serverLevel.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                        }
                    });
                } else {
                    blockState.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
                }
            }
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    private boolean checkIfStructure(Level level, BlockPos blockPos) {
        if (level.m_220362_() != TRDimensionTypes.TARDIS) {
            return false;
        }
        BlockPos startingCorner = new BlockPos(blockPos.m_123341_() - 1, blockPos.m_123342_() - 1, blockPos.m_123343_() - 1);
        for (int x = startingCorner.m_123341_(); x < startingCorner.m_123341_() + 3; ++x) {
            for (int z = startingCorner.m_123343_(); z < startingCorner.m_123343_() + 3; ++z) {
                BlockState state = level.m_8055_(new BlockPos(x, startingCorner.m_123342_(), z));
                if (!(x == startingCorner.m_123341_() + 1 && z == startingCorner.m_123343_() + 1 ? state.m_60734_() != Blocks.f_50330_ : state.m_60734_() != Blocks.f_152504_)) continue;
                return false;
            }
        }
        return true;
    }

    private void destroyStructure(Level level, BlockPos blockPos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos startingCorner = new BlockPos(blockPos.m_123341_() - 1, blockPos.m_123342_() - 1, blockPos.m_123343_() - 1);
            for (int x = startingCorner.m_123341_(); x < startingCorner.m_123341_() + 3; ++x) {
                for (int z = startingCorner.m_123343_(); z < startingCorner.m_123343_() + 3; ++z) {
                    serverLevel.m_46961_(new BlockPos(x, startingCorner.m_123342_(), z), false);
                }
            }
            serverLevel.m_46597_(blockPos.m_7495_(), Blocks.f_50069_.m_49966_());
            serverLevel.m_5594_(null, blockPos, SoundEvents.f_12090_, SoundSource.BLOCKS, 10.0f, 1.75f);
        }
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }
}

