/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.block.device;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.common.items.KeyItem;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.util.DimensionUtil;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.registry.TRUpgrades;

public class LandingPadBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public LandingPadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!player.m_9236_().m_5776_() && level instanceof ServerLevel) {
            ArrayList<ResourceKey<Level>> keyChain;
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack itemStack = player.m_21120_(interactionHand);
            if (itemStack.m_41720_() instanceof KeyItem && !(keyChain = KeyItem.getKeychain(itemStack)).isEmpty()) {
                ResourceKey<Level> dimension = KeyItem.getKeychain(itemStack).get(0);
                ServerLevel tardisLevel = DimensionUtil.getLevel(dimension);
                Optional<TardisLevelOperator> operatorOptional = TardisLevelOperator.get(tardisLevel);
                if (operatorOptional.isEmpty()) {
                    return InteractionResult.PASS;
                }
                TardisLevelOperator operator = operatorOptional.get();
                if (serverLevel.m_46859_(blockPos.m_7494_()) && operator.getProgressionManager().isLevelDiscovered((ResourceKey<Level>)level.m_46472_())) {
                    TardisPilotingManager pilotManager = operator.getPilotingManager();
                    UpgradeHandler upgradeHandler = operator.getUpgradeHandler();
                    if (TRUpgrades.LANDING_PAD.get().isUnlocked(upgradeHandler) && pilotManager.beginFlight(true) && !pilotManager.isInRecovery()) {
                        pilotManager.setTargetLocation(new TardisNavLocation(blockPos.m_7494_(), player.m_6350_().m_122424_(), serverLevel));
                        serverLevel.m_5594_(null, blockPos, SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)ModMessages.TARDIS_IS_ON_THE_WAY), true);
                        return InteractionResult.PASS;
                    }
                    if (TRUpgrades.LANDING_PAD.get().isUnlocked(upgradeHandler)) {
                        PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)ModMessages.LANDING_PAD_TRANSIENT), true);
                        serverLevel.m_5594_(null, blockPos, (SoundEvent)SoundEvents.f_12170_.m_203334_(), SoundSource.BLOCKS, 100.0f, (float)(0.1 + (double)serverLevel.m_213780_().m_188501_() * 0.25));
                    } else {
                        serverLevel.m_5594_(null, blockPos, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)ModMessages.LANDING_PAD_NOT_UNLOCKED), true);
                    }
                    return InteractionResult.m_19078_((boolean)false);
                }
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)ModMessages.LANDING_PAD_BANNED_DIM), true);
                serverLevel.m_5594_(null, blockPos, (SoundEvent)SoundEvents.f_12170_.m_203334_(), SoundSource.BLOCKS, 100.0f, (float)(0.1 + (double)serverLevel.m_213780_().m_188501_() * 0.25));
            }
        }
        return InteractionResult.PASS;
    }
}

