/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.block.device;

import com.mojang.brigadier.StringReader;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;
import whocraft.tardis_refined.common.blockentity.device.ConsoleConfigurationBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.tardis.themes.ConsoleTheme;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.constants.ResourceConstants;
import whocraft.tardis_refined.patterns.ConsolePattern;
import whocraft.tardis_refined.patterns.ConsolePatterns;
import whocraft.tardis_refined.registry.TRBlockRegistry;
import whocraft.tardis_refined.registry.TRDimensionTypes;
import whocraft.tardis_refined.registry.TRItemRegistry;
import whocraft.tardis_refined.registry.TRSoundRegistry;

public class ConsoleConfigurationBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static VoxelShape SHAPE = Stream.of(Shapes.m_83113_((VoxelShape)Block.m_49796_((double)2.0, (double)6.0, (double)8.0, (double)14.0, (double)11.0, (double)8.0), (VoxelShape)Block.m_49796_((double)2.0, (double)6.0, (double)8.0, (double)14.0, (double)11.0, (double)8.0), (BooleanOp)BooleanOp.f_82695_), Block.m_49796_((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public ConsoleConfigurationBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (interactionHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (!player.m_9236_().m_5776_()) {
            Vec3i offset = ((Direction)blockState.m_61143_((Property)FACING)).m_122436_();
            BlockPos consolePos = blockPos.m_121955_(offset);
            if (player.m_21205_().m_41720_() == TRItemRegistry.PATTERN_MANIPULATOR.get()) {
                this.changePattern(level, blockPos, consolePos, player);
                return InteractionResult.m_19078_((boolean)false);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (serverLevel.m_220362_() == TRDimensionTypes.TARDIS) {
                    TardisLevelOperator.get(serverLevel).ifPresent(operator -> {
                        if (!operator.getPilotingManager().isInFlight()) {
                            if (player.m_6144_()) {
                                this.removeGlobalConsoleBlock(consolePos, level);
                            } else {
                                this.changeConsoleTheme(level, blockPos, consolePos);
                            }
                        } else {
                            PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)ModMessages.CONSOLE_CONFIGURATION_NOT_IN_FLIGHT), true);
                        }
                    });
                } else if (player.m_6144_()) {
                    this.removeGlobalConsoleBlock(consolePos, level);
                } else {
                    this.changeConsoleTheme(level, blockPos, consolePos);
                }
            }
            return InteractionResult.m_19078_((boolean)false);
        }
        return InteractionResult.m_19078_((boolean)true);
    }

    private boolean placeNewGlobalConsoleBlock(Level level, BlockPos configuratorPos, BlockPos consolePos) {
        BlockEntity expectedConfiguratorBlockEntity = level.m_7702_(configuratorPos);
        if (expectedConfiguratorBlockEntity instanceof ConsoleConfigurationBlockEntity) {
            ConsoleConfigurationBlockEntity consoleConfigurationBlockEntity = (ConsoleConfigurationBlockEntity)expectedConfiguratorBlockEntity;
            ResourceLocation consoleThemeId = consoleConfigurationBlockEntity.theme();
            level.m_46597_(consolePos, TRBlockRegistry.GLOBAL_CONSOLE_BLOCK.get().m_49966_());
            BlockEntity expectedConsoleBlockEntity = level.m_7702_(consolePos);
            if (expectedConsoleBlockEntity instanceof GlobalConsoleBlockEntity) {
                GlobalConsoleBlockEntity globalConsoleBlockEntity = (GlobalConsoleBlockEntity)expectedConsoleBlockEntity;
                globalConsoleBlockEntity.setConsoleTheme(consoleThemeId);
                level.m_5594_(null, consolePos, SoundEvents.f_11887_, SoundSource.BLOCKS, 3.0f, 0.45f);
                if (level.m_5776_()) {
                    this.playParticles(configuratorPos, level);
                }
                return true;
            }
        }
        return false;
    }

    private boolean removeGlobalConsoleBlock(BlockPos consolePos, Level level) {
        BlockEntity blockEntity = level.m_7702_(consolePos);
        if (blockEntity instanceof GlobalConsoleBlockEntity) {
            GlobalConsoleBlockEntity consoleBlockEntity = (GlobalConsoleBlockEntity)blockEntity;
            consoleBlockEntity.killControls();
            level.m_46961_(consolePos, true);
            return true;
        }
        return false;
    }

    private boolean changePattern(Level level, BlockPos configuratorPos, BlockPos consolePos, Player player) {
        BlockEntity expectedConfiguratorBlockEntity = level.m_7702_(configuratorPos);
        BlockEntity expectedConsoleBlockEntity = level.m_7702_(consolePos);
        if (expectedConfiguratorBlockEntity instanceof ConsoleConfigurationBlockEntity) {
            ConsoleConfigurationBlockEntity consoleConfigurationBlockEntity = (ConsoleConfigurationBlockEntity)expectedConfiguratorBlockEntity;
            if (expectedConsoleBlockEntity instanceof GlobalConsoleBlockEntity) {
                GlobalConsoleBlockEntity globalConsoleBlockEntity = (GlobalConsoleBlockEntity)expectedConsoleBlockEntity;
                ResourceLocation currentConsoleThemeId = globalConsoleBlockEntity.theme();
                if (ConsolePatterns.getPatternsForTheme(currentConsoleThemeId).size() == 1) {
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_12170_.m_203334_(), SoundSource.PLAYERS, 100.0f, (float)(0.1 + (double)level.m_213780_().m_188501_() * 0.5));
                    return false;
                }
                globalConsoleBlockEntity.setPattern(ConsolePatterns.next(currentConsoleThemeId, globalConsoleBlockEntity.pattern()));
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.Serializer.m_130699_((StringReader)new StringReader(globalConsoleBlockEntity.pattern().name())), true);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), TRSoundRegistry.PATTERN_MANIPULATOR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_36335_().m_41524_(TRItemRegistry.PATTERN_MANIPULATOR.get(), 20);
                return true;
            }
        }
        return false;
    }

    private boolean changeConsoleTheme(Level level, BlockPos configuratorPos, BlockPos consolePos) {
        BlockEntity expectedConfiguratorBlockEntity = level.m_7702_(configuratorPos);
        BlockEntity expectedConsoleBlockEntity = level.m_7702_(consolePos);
        if (expectedConfiguratorBlockEntity instanceof ConsoleConfigurationBlockEntity) {
            ConsoleConfigurationBlockEntity configurationBlockEntity = (ConsoleConfigurationBlockEntity)expectedConfiguratorBlockEntity;
            ResourceLocation nextTheme = this.nextTheme(configurationBlockEntity);
            configurationBlockEntity.setConsoleTheme(nextTheme);
            if (expectedConsoleBlockEntity instanceof GlobalConsoleBlockEntity) {
                GlobalConsoleBlockEntity consoleBlockEntity = (GlobalConsoleBlockEntity)expectedConsoleBlockEntity;
                consoleBlockEntity.setConsoleTheme(nextTheme);
                consoleBlockEntity.spawnControlEntities();
                ConsolePattern defaultOrEquivalentPattern = ConsolePatterns.getPatternOrDefault(nextTheme, ResourceConstants.DEFAULT_PATTERN_ID);
                if (defaultOrEquivalentPattern != null) {
                    consoleBlockEntity.setPattern(defaultOrEquivalentPattern);
                    level.m_5594_(null, consolePos, SoundEvents.f_11887_, SoundSource.BLOCKS, 3.0f, 0.45f);
                    if (level.m_5776_()) {
                        this.playParticles(configuratorPos, level);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private ResourceLocation nextTheme(ConsoleConfigurationBlockEntity blockEntity) {
        ResourceLocation consoleThemeId = blockEntity.theme();
        List themesList = ConsoleTheme.CONSOLE_THEME_DEFERRED_REGISTRY.keySet().stream().toList();
        int index = themesList.indexOf(consoleThemeId);
        int nextIndex = index + 1;
        if (nextIndex >= themesList.size()) {
            nextIndex = 0;
        }
        return (ResourceLocation)themesList.get(nextIndex);
    }

    private void playParticles(BlockPos pos, Level level) {
        for (int i = 0; i < 3; ++i) {
            double xCoord = (double)pos.m_123341_() + level.m_213780_().m_188500_();
            double yCoord = (double)pos.m_123342_() + level.m_213780_().m_188500_() * 0.5 + 0.5;
            double zCoord = (double)pos.m_123343_() + level.m_213780_().m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123747_, xCoord, yCoord, zCoord, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, xCoord, yCoord, zCoord, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ConsoleConfigurationBlockEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }
}

