/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common;

import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.client.renderer.vortex.VortexGradientTint;
import whocraft.tardis_refined.common.tardis.themes.Theme;
import whocraft.tardis_refined.registry.DeferredRegistry;
import whocraft.tardis_refined.registry.RegistrySupplier;

public class VortexRegistry
implements Theme {
    public static final ResourceKey<Registry<VortexRegistry>> VORTEX_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("tardis_refined", "vortex"));
    public static final DeferredRegistry<VortexRegistry> VORTEX_DEFERRED_REGISTRY = DeferredRegistry.createCustom("tardis_refined", VORTEX_REGISTRY_KEY, true);
    public static final RegistrySupplier<VortexRegistry> CLOUDS = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "clouds"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.BlueOrngGradient, false);
    public static final RegistrySupplier<VortexRegistry> WAVES = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "waves"), new ResourceLocation("tardis_refined", "textures/vortex/waves.png"), 9, 12, 20.0f, true, true, VortexGradientTint.BlueOrngGradient, false);
    public static final RegistrySupplier<VortexRegistry> STARS = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "stars"), new ResourceLocation("tardis_refined", "textures/vortex/stars.png"), 9, 12, 5.0f, true, true, VortexGradientTint.PASTEL_GRADIENT, true);
    public static final RegistrySupplier<VortexRegistry> FLOW = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "flow"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 5.0f, true, true, VortexGradientTint.MODERN_VORTEX, true);
    public static final RegistrySupplier<VortexRegistry> SPACE = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "space"), new ResourceLocation("tardis_refined", "textures/vortex/stars_2.png"), 9, 12, 5.0f, true, true, VortexGradientTint.MODERN_VORTEX, false);
    public static final RegistrySupplier<VortexRegistry> TWILIGHT_GLOW = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "twilight_glow"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.TWILIGHT_GLOW, false);
    public static final RegistrySupplier<VortexRegistry> AURORA_DREAMS = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "aurora_dreams"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.AURORA_DREAMS, false);
    public static final RegistrySupplier<VortexRegistry> DESERT_MIRAGE = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "desert_mirage"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.DESERT_MIRAGE, false);
    public static final RegistrySupplier<VortexRegistry> NEON_PULSE = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "neon_pulse"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.NEON_PULSE, false);
    public static final RegistrySupplier<VortexRegistry> OCEAN_BREEZE = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "ocean_breeze"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.OCEAN_BREEZE, false);
    public static final RegistrySupplier<VortexRegistry> SOLAR_FLARE = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "solar_flare"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.SOLAR_FLARE, false);
    public static final RegistrySupplier<VortexRegistry> CRYSTAL_LAGOON = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "crystal_lagoon"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.CRYSTAL_LAGOON, false);
    public static final RegistrySupplier<VortexRegistry> VELVET_NIGHT = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "velvet_night"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.VELVET_NIGHT, false);
    public static final RegistrySupplier<VortexRegistry> CANDY_POP = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "candy_pop"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.CANDY_POP, false);
    public static final RegistrySupplier<VortexRegistry> EMERALD_FOREST = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "emerald_forest"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.EMERALD_FOREST, false);
    public static final RegistrySupplier<VortexRegistry> LGBT_RAINBOW = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "lgbt_rainbow"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.LGBT_RAINBOW, false);
    public static final RegistrySupplier<VortexRegistry> TRANSGENDER_FLAG = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "transgender_flag"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.TRANSGENDER_FLAG, false);
    public static final RegistrySupplier<VortexRegistry> BISEXUAL_FLAG = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "bisexual_flag"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.BISEXUAL_FLAG, false);
    public static final RegistrySupplier<VortexRegistry> LESBIAN_FLAG = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "lesbian_flag"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.LESBIAN_FLAG, false);
    public static final RegistrySupplier<VortexRegistry> NON_BINARY_FLAG = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "non_binary_flag"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.NON_BINARY_FLAG, false);
    public static final RegistrySupplier<VortexRegistry> AGENDER_FLAG = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "agender_flag"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.AGENDER_FLAG, false);
    public static final RegistrySupplier<VortexRegistry> GAY_FLAG = VortexRegistry.registerVortex(new ResourceLocation("tardis_refined", "gay_flag"), new ResourceLocation("tardis_refined", "textures/vortex/clouds.png"), 9, 12, 10.0f, true, true, VortexGradientTint.GAY_FLAG, false);
    private final ResourceLocation texture;
    private final int sides;
    private final int rows;
    private final float twist;
    private final boolean lightning;
    private final boolean decals;
    private final VortexGradientTint gradient;
    private final boolean movingGradient;
    private ResourceLocation translationKey;

    public VortexRegistry(ResourceLocation id, ResourceLocation texture, int sides, int rows, float twist, boolean lightning, boolean decals, VortexGradientTint gradient, boolean movingGradient) {
        this.texture = texture;
        this.sides = sides;
        this.rows = rows;
        this.twist = twist;
        this.lightning = lightning;
        this.decals = decals;
        this.gradient = gradient;
        this.movingGradient = movingGradient;
        this.translationKey = id;
    }

    private static RegistrySupplier<VortexRegistry> registerVortex(ResourceLocation id, ResourceLocation texturePath, int sides, int rows, float twist, boolean lightning, boolean decals, VortexGradientTint gradient, boolean movingGradient) {
        return VORTEX_DEFERRED_REGISTRY.register(id.m_135815_(), () -> new VortexRegistry(id, texturePath, sides, rows, twist, lightning, decals, gradient, movingGradient));
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public int getSides() {
        return this.sides;
    }

    public int getRows() {
        return this.rows;
    }

    public float getTwist() {
        return this.twist;
    }

    public boolean hasLightning() {
        return this.lightning;
    }

    public boolean hasDecals() {
        return this.decals;
    }

    public VortexGradientTint getGradient() {
        return this.gradient;
    }

    public boolean isMovingGradient() {
        return this.movingGradient;
    }

    @Override
    public String getTranslationKey() {
        return Util.m_137492_((String)"vortex", (ResourceLocation)this.translationKey);
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)this.getTranslationKey());
    }
}

