/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import whocraft.tardis_refined.common.block.device.AntiGravityBlock;
import whocraft.tardis_refined.registry.TRDimensionTypes;

public class GravityUtil {
    private static final int MAX_Y = 30;
    private static final double ACCELERATION = 0.2;

    public static boolean isInAntiGrav(Player player, AABB box, Level level) {
        if (level.m_220362_() != TRDimensionTypes.TARDIS) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)new BlockPos((int)box.f_82291_, (int)box.f_82292_, (int)box.f_82293_), (BlockPos)new BlockPos((int)box.f_82288_, (int)box.f_82289_, (int)box.f_82290_))) {
            AABB myGravBox;
            int space;
            BlockState blockState = level.m_8055_(pos);
            if (!(blockState.m_60734_() instanceof AntiGravityBlock) || (space = ((Integer)blockState.m_61143_((Property)AntiGravityBlock.SPACE)).intValue()) <= 0 || !level.m_8055_((BlockPos)mutablePos.m_122190_((Vec3i)pos).m_122184_(0, 1, 0)).m_60795_() || !(myGravBox = GravityUtil.createGravityBoxFromLevel(pos, space)).m_82381_(player.m_20191_()) || player.m_20183_().m_123342_() < pos.m_123342_()) continue;
            GravityUtil.spawnParticlesWithinAABB(level, myGravBox);
            return true;
        }
        return false;
    }

    private static void spawnParticlesWithinAABB(Level level, AABB box) {
        for (int i = 0; i < 2; ++i) {
            double x = box.f_82288_ + (box.f_82291_ - box.f_82288_) * level.f_46441_.m_188500_();
            double y = box.f_82289_ + (box.f_82292_ - box.f_82289_) * level.f_46441_.m_188500_();
            double z = box.f_82290_ + (box.f_82293_ - box.f_82290_) * level.f_46441_.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123783_, x, y, z, 0.0, 0.2, 0.0);
        }
    }

    public static AABB createGravityBoxFromLevel(BlockPos blockPos, int range) {
        return new AABB(blockPos).m_82377_((double)range, 30.0, (double)range);
    }

    public static boolean isInGravityShaft(Player player) {
        return GravityUtil.isInAntiGrav(player, player.m_20191_().m_82377_(8.0, 30.0, 8.0), player.m_9236_());
    }

    static double easeMovement() {
        double smoothedMovement = Math.abs(0.2);
        return smoothedMovement * smoothedMovement * smoothedMovement;
    }
}

