/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.command.sub;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.util.CommandHelper;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.common.util.TRTeleporter;
import whocraft.tardis_refined.constants.ModMessages;

public class InteriorCommand
implements Command<CommandSourceStack> {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return Commands.m_82127_((String)"interior").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"tardis", (ArgumentType)DimensionArgument.m_88805_()).suggests(CommandHelper.SUGGEST_TARDISES).executes(context -> InteriorCommand.teleportToInterior((CommandContext<CommandSourceStack>)context, List.of(Objects.requireNonNull(((CommandSourceStack)context.getSource()).m_230896_())), DimensionArgument.m_88808_((CommandContext)context, (String)"tardis")))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(context -> InteriorCommand.teleportToInterior((CommandContext<CommandSourceStack>)context, EntityArgument.m_91461_((CommandContext)context, (String)"entities"), DimensionArgument.m_88808_((CommandContext)context, (String)"tardis")))));
    }

    private static int teleportToInterior(CommandContext<CommandSourceStack> context, Collection<? extends Entity> entities, ServerLevel tardis) {
        Optional<TardisLevelOperator> tardisData = TardisLevelOperator.get(tardis);
        ServerPlayer sender = ((CommandSourceStack)context.getSource()).m_230896_();
        if (tardisData.isPresent()) {
            for (Entity entity : entities) {
                if (InteriorCommand.teleportToInterior(tardisData.get(), entity)) continue;
                MutableComponent tpCommandSuggestion = CommandHelper.createComponentSuggestCommand("Default Teleport", "/execute in " + tardis.m_46472_().m_135782_().toString() + " run tp 0 100 0");
                PlayerUtil.sendMessage((LivingEntity)sender, (Component)Component.m_237110_((String)ModMessages.CMD_NO_INTERNAL_DOOR, (Object[])new Object[]{tardis.m_46472_().m_135782_().toString(), tpCommandSuggestion}), false);
                return 0;
            }
            return 1;
        }
        PlayerUtil.sendMessage((LivingEntity)sender, (Component)Component.m_237110_((String)ModMessages.CMD_DIM_NOT_A_TARDIS, (Object[])new Object[]{tardis.m_220362_().m_135782_().toString()}), false);
        return 0;
    }

    private static boolean teleportToInterior(TardisLevelOperator tardisLevelOperator, Entity entity) {
        Level tpLevel = tardisLevelOperator.getLevel();
        if (tpLevel instanceof ServerLevel) {
            ServerLevel finalTpLevel = (ServerLevel)tpLevel;
            if (tardisLevelOperator.getInternalDoor() != null) {
                BlockPos pos = tardisLevelOperator.getInternalDoor().getDoorPosition();
                pos = pos.m_5484_(tardisLevelOperator.getInternalDoor().getTeleportRotation(), 1);
                TRTeleporter.simpleTeleport(entity, finalTpLevel, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), entity.m_6080_(), entity.m_146909_());
                return true;
            }
        }
        return false;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        return 0;
    }
}

