/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.screen.upgrades;

import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import whocraft.tardis_refined.client.screen.upgrades.UpgradesScreen;

@OnlyIn(value=Dist.CLIENT)
enum UpgradeTabType {
    ABOVE(0, 0, 28, 32, 8),
    BELOW(84, 0, 28, 32, 8),
    LEFT(0, 64, 32, 28, 5),
    RIGHT(96, 64, 32, 28, 5);

    public static final int MAX_TABS;
    private final int textureX;
    private final int textureY;
    private final int width;
    private final int height;
    private final int max;

    private UpgradeTabType(int j, int k, int l, int m, int n2) {
        this.textureX = j;
        this.textureY = k;
        this.width = l;
        this.height = m;
        this.max = n2;
    }

    public int getMax() {
        return this.max;
    }

    public void draw(GuiGraphics guiGraphics, int offsetX, int offsetY, boolean isSelected, int index) {
        int i = this.textureX;
        if (index > 0) {
            i += this.width;
        }
        if (index == this.max - 1) {
            i += this.width;
        }
        int j = isSelected ? this.textureY + this.height : this.textureY;
        guiGraphics.m_280218_(UpgradesScreen.WINDOW, offsetX + this.getX(index), offsetY + this.getY(index), i, j, this.width, this.height);
    }

    public void drawIcon(GuiGraphics guiGraphics, int offsetX, int offsetY, int index, ItemStack stack) {
        int i = offsetX + this.getX(index);
        int j = offsetY + this.getY(index);
        switch (this) {
            case ABOVE: {
                i += 6;
                j += 9;
                break;
            }
            case BELOW: {
                i += 6;
                j += 6;
                break;
            }
            case LEFT: {
                i += 10;
                j += 5;
                break;
            }
            case RIGHT: {
                i += 6;
                j += 5;
            }
        }
    }

    public int getX(int index) {
        return switch (this) {
            case ABOVE, BELOW -> (this.width + 4) * index;
            case LEFT -> -this.width + 4;
            case RIGHT -> 248;
            default -> throw new UnsupportedOperationException("Don't know what this tab type is!" + this);
        };
    }

    public int getY(int index) {
        return switch (this) {
            case ABOVE -> -this.height + 4;
            case BELOW -> 192;
            case LEFT, RIGHT -> this.height * index;
            default -> throw new UnsupportedOperationException("Don't know what this tab type is!" + this);
        };
    }

    public boolean isMouseOver(int offsetX, int offsetY, int index, double mouseX, double mouseY) {
        int i = offsetX + this.getX(index);
        int j = offsetY + this.getY(index);
        return mouseX > (double)i && mouseX < (double)(i + this.width) && mouseY > (double)j && mouseY < (double)(j + this.height);
    }

    static {
        MAX_TABS = Arrays.stream(UpgradeTabType.values()).mapToInt(e -> e.max).sum();
    }
}

