/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.screen.screens;

import com.mojang.brigadier.StringReader;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import whocraft.tardis_refined.client.screen.components.GenericMonitorSelectionList;
import whocraft.tardis_refined.client.screen.components.SelectionListEntry;
import whocraft.tardis_refined.client.screen.main.MonitorOS;
import whocraft.tardis_refined.common.network.messages.hums.C2SChangeHum;
import whocraft.tardis_refined.common.soundscape.hum.HumEntry;
import whocraft.tardis_refined.common.soundscape.hum.TardisHums;
import whocraft.tardis_refined.common.util.MiscHelper;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.constants.ModMessages;

public class HumSelectionScreen
extends MonitorOS {
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/HumSelectionScreen");
    private HumEntry currentHumEntry;

    public HumSelectionScreen() {
        super((Component)Component.m_237115_((String)ModMessages.UI_MONITOR_SELECT_HUM), new ResourceLocation("tardis_refined", "textures/gui/monitor/backdrop.png"));
    }

    public static void selectHum(HumEntry theme) {
        assert (Minecraft.m_91087_().f_91074_ != null);
        new C2SChangeHum((ResourceKey<Level>)Minecraft.m_91087_().f_91074_.m_9236_().m_46472_(), theme).send();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.setEvents(() -> HumSelectionScreen.selectHum(this.currentHumEntry), () -> {
            if (this.PREVIOUS != null) {
                this.switchScreenToLeft(this.PREVIOUS);
            }
        });
        this.currentHumEntry = this.grabHum();
        int vPos = (this.f_96544_ - 130) / 2;
        this.addSubmitButton(this.f_96543_ / 2 + 85, this.f_96544_ - vPos - 25);
        this.addCancelButton(this.f_96543_ / 2 - 105, this.f_96544_ - vPos - 25);
    }

    private HumEntry grabHum() {
        Iterator<HumEntry> iterator = TardisHums.getRegistry().values().iterator();
        if (iterator.hasNext()) {
            HumEntry humEntry = iterator.next();
            return humEntry;
        }
        return null;
    }

    @Override
    public ObjectSelectionList<SelectionListEntry> createSelectionList() {
        int vPos = (this.f_96544_ - 130) / 2;
        int leftPos = this.f_96543_ / 2 - 75;
        GenericMonitorSelectionList<SelectionListEntry> selectionList = new GenericMonitorSelectionList<SelectionListEntry>(this.f_96541_, 150, 80, leftPos, vPos + 15, vPos + 130 - 30, 12);
        selectionList.m_93488_(false);
        Collection<HumEntry> knownHums = TardisHums.getRegistry().values();
        knownHums = knownHums.stream().sorted(Comparator.comparing(HumEntry::getNameComponent)).toList();
        for (HumEntry humEntry : knownHums) {
            MutableComponent tooltip;
            MutableComponent name = Component.m_237113_((String)MiscHelper.getCleanName(humEntry.getIdentifier().m_135815_()));
            try {
                name = Component.Serializer.m_130699_((StringReader)new StringReader(humEntry.getNameComponent()));
                tooltip = Component.m_237113_((String)(ChatFormatting.BLUE + Platform.getModName(humEntry.getIdentifier().m_135827_())));
            }
            catch (Exception ex) {
                LOGGER.error("Could not process Name for hum {}", (Object)humEntry.getIdentifier());
                tooltip = Component.m_237113_((String)"Unknown");
            }
            SelectionListEntry entry = new SelectionListEntry((Component)name, selectedEntry -> {
                this.currentHumEntry = humEntry;
                for (Object child : selectionList.m_6702_()) {
                    if (!(child instanceof SelectionListEntry)) continue;
                    SelectionListEntry current = (SelectionListEntry)((Object)((Object)child));
                    current.setChecked(false);
                }
                selectedEntry.setChecked(true);
            }, leftPos);
            entry.setTooltip((Component)tooltip);
            selectionList.m_6702_().add(entry);
        }
        return selectionList;
    }
}

