/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.screen.ponder;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.client.ScreenHandler;
import whocraft.tardis_refined.client.screen.components.GenericMonitorSelectionList;
import whocraft.tardis_refined.client.screen.components.SelectionListEntry;
import whocraft.tardis_refined.client.screen.main.MonitorOS;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorBlockResult;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorCraftingIngredient;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorCraftingRecipe;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorCraftingResult;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorItemResult;

public class PonderScreen
extends MonitorOS {
    private final ManipulatorCraftingRecipe recipe;
    private final int xSize;
    private final int ySize;
    private final int zSize;
    private int age = 0;
    private float rotationX = -45.0f;
    private float rotationY = 45.0f;
    private boolean isDragging = false;

    public PonderScreen(ManipulatorCraftingRecipe recipe) {
        super(PonderScreen.getResultName(recipe), new ResourceLocation("tardis_refined", "textures/gui/monitor/backdrop.png"));
        this.setEvents(() -> {}, ScreenHandler::openCraftingScreen);
        this.recipe = recipe;
        int minX = 100;
        int maxX = -100;
        int minY = 100;
        int maxY = -100;
        int minZ = 100;
        int maxZ = -100;
        for (ManipulatorCraftingIngredient ingredient : recipe.ingredients()) {
            BlockPos pos = ingredient.relativeBlockPos();
            minX = Math.min(minX, pos.m_123341_());
            maxX = Math.max(maxX, pos.m_123341_());
            minY = Math.min(minY, pos.m_123342_());
            maxY = Math.max(maxY, pos.m_123342_());
            minZ = Math.min(minZ, pos.m_123343_());
            maxZ = Math.max(maxZ, pos.m_123343_());
        }
        this.xSize = maxX - minX;
        this.ySize = maxY - minY;
        this.zSize = maxZ - minZ;
    }

    public static Component getResultName(ManipulatorCraftingRecipe recipe) {
        ManipulatorCraftingResult blockState;
        ManipulatorCraftingResult manipulatorCraftingResult = recipe.result();
        if (manipulatorCraftingResult instanceof ManipulatorBlockResult) {
            ManipulatorBlockResult blockResult = (ManipulatorBlockResult)manipulatorCraftingResult;
            blockState = blockResult.recipeOutput();
            return blockState.m_60734_().m_49954_();
        }
        blockState = recipe.result();
        if (blockState instanceof ManipulatorItemResult) {
            ManipulatorItemResult itemResult = (ManipulatorItemResult)blockState;
            ItemStack itemStack = itemResult.recipeOutput();
            return itemStack.m_41786_();
        }
        return Component.m_237113_((String)"What on earth are you crafting?");
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int vPos = (this.f_96544_ - 130) / 2;
        this.addCancelButton(this.f_96543_ / 2 - 105, this.f_96544_ - vPos - 25);
    }

    @Override
    public ObjectSelectionList<SelectionListEntry> createSelectionList() {
        int leftPos = this.f_96543_ / 2;
        int topPos = (this.f_96544_ - 130) / 2;
        GenericMonitorSelectionList<SelectionListEntry> selectionList = new GenericMonitorSelectionList<SelectionListEntry>(this.f_96541_, 105, 80, leftPos, topPos + 15, topPos + 130 - 30, 12);
        selectionList.m_93488_(false);
        HashMap<String, Integer> itemCounts = new HashMap<String, Integer>();
        for (ManipulatorCraftingIngredient manipulatorCraftingIngredient : this.recipe.ingredients()) {
            String itemName = new ItemStack((ItemLike)manipulatorCraftingIngredient.inputBlockState().m_60734_()).m_41786_().getString();
            itemCounts.put(itemName, itemCounts.getOrDefault(itemName, 0) + 1);
        }
        for (Map.Entry entry : itemCounts.entrySet()) {
            String itemNameWithCount = entry.getValue() + "x " + (String)entry.getKey();
            SelectionListEntry selectionListEntry = new SelectionListEntry((Component)Component.m_237113_((String)itemNameWithCount), entryCallback -> {}, leftPos);
            selectionList.m_6702_().add(selectionListEntry);
        }
        return selectionList;
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        assert (this.f_96541_ != null);
        if (this.recipe.ingredients().isEmpty()) {
            return;
        }
        PoseStack pose = guiGraphics.m_280168_();
        Lighting.m_84931_();
        pose.m_85836_();
        pose.m_252880_((float)this.f_96543_ / 2.0f - 50.0f, (float)this.f_96544_ / 2.0f, 500.0f);
        pose.m_252781_(Axis.f_252529_.m_252977_(this.rotationX / 2.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(this.rotationY));
        pose.m_85841_(-20.0f, -20.0f, -20.0f);
        pose.m_252880_((float)(-this.xSize) / 2.0f, (float)(-this.ySize) / 2.0f, (float)(-this.zSize) / 2.0f);
        int i = 0;
        int e = this.age / 10;
        for (ManipulatorCraftingIngredient ingredient : this.recipe.ingredients()) {
            if (i > e % this.recipe.ingredients().size()) break;
            BlockState s = ingredient.inputBlockState();
            BlockPos pos = ingredient.relativeBlockPos();
            pose.m_85836_();
            pose.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            assert (this.f_96541_.f_91073_ != null);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.f_96541_.m_91289_().m_110912_(s, guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), 240, OverlayTexture.f_118083_);
            pose.m_85849_();
            ++i;
        }
        guiGraphics.m_280262_();
        Lighting.m_84931_();
        pose.m_85849_();
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        ++this.age;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging) {
            this.rotationY += (float)(deltaX * 0.5);
            this.rotationX -= (float)(deltaY * 0.5);
            this.rotationX = Math.max(-90.0f, Math.min(90.0f, this.rotationX));
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.isDragging = true;
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDragging = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }
}

