/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.renderer.vortex;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.model.blockentity.shell.ShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.ShellModelCollection;
import whocraft.tardis_refined.client.overlays.VortexOverlay;
import whocraft.tardis_refined.client.renderer.RenderHelper;
import whocraft.tardis_refined.client.screen.screens.ShellSelectionScreen;
import whocraft.tardis_refined.common.capability.player.TardisPlayerInfo;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.patterns.ShellPattern;
import whocraft.tardis_refined.patterns.ShellPatterns;

public class ShellRenderer {
    public static void renderShell(GuiGraphics guiGraphics, float control, float alpha, int throttle) {
        TardisPlayerInfo.get((LivingEntity)Minecraft.m_91087_().f_91074_).ifPresent(tardisPlayerInfo -> {
            TardisClientData tardisClientData = TardisClientData.getInstance(tardisPlayerInfo.getPlayerPreviousPos().getDimensionKey());
            ResourceLocation shellPattern = tardisClientData.getShellPattern();
            ResourceLocation shellTheme = tardisClientData.getShellTheme();
            ShellPattern fullPattern = ShellPatterns.getPatternOrDefault(shellTheme, shellPattern);
            ShellModel model = ShellModelCollection.getInstance().getShellEntry(shellTheme).getShellModel(fullPattern);
            model.setDoorPosition(false);
            if (!tardisClientData.isFlying()) {
                return;
            }
            Lighting.m_166384_();
            PoseStack pose = guiGraphics.m_280168_();
            pose.m_85836_();
            RenderHelper.rotateZYX(pose, 180.0f, 0.0f, 0.0f);
            long time = System.currentTimeMillis();
            float timeFactor = (float)(time % 4000L) / 4000.0f * ((float)Math.PI * 2);
            float xR = (float)Math.sin(timeFactor * 2.0f) * 15.0f;
            float yR = timeFactor * 360.0f / ((float)Math.PI * 2) % 360.0f * (1.0f + (float)throttle * 0.5f);
            float zR = (float)Math.cos(timeFactor * 3.0f) * 10.0f;
            RenderHelper.rotateZYX(pose, xR * control, 0.0f, zR * control);
            RenderHelper.rotateZYX(pose, 0.0f, yR * control, 0.0f);
            VertexConsumer vertexConsumer = guiGraphics.m_280091_().m_6299_(model.m_103119_(model.getShellTexture(ShellPatterns.getPatternOrDefault(shellTheme, shellPattern), false)));
            RenderSystem.enableBlend();
            ShellSelectionScreen.GLOBALSHELL_BLOCKENTITY.setTardisId(tardisClientData.getLevelKey());
            if (Platform.isForge()) {
                float scale = 2.5f;
                pose.m_85841_(scale, scale, scale);
            }
            model.renderShell(ShellSelectionScreen.GLOBALSHELL_BLOCKENTITY, false, false, pose, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
            if (fullPattern.shellTexture().emissive()) {
                VertexConsumer vertexConsumerLighting = guiGraphics.m_280091_().m_6299_(RenderType.m_234338_((ResourceLocation)model.getShellTexture(ShellPatterns.getPatternOrDefault(shellTheme, shellPattern), true)));
                model.renderShell(ShellSelectionScreen.GLOBALSHELL_BLOCKENTITY, false, false, pose, vertexConsumerLighting, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
            }
            VertexConsumer lightning = guiGraphics.m_280091_().m_6299_(RenderType.m_110496_());
            if ((double)VortexOverlay.VORTEX.lightning_strike > 0.4) {
                model.renderShell(ShellSelectionScreen.GLOBALSHELL_BLOCKENTITY, false, false, pose, lightning, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
            }
            guiGraphics.m_280262_();
            pose.m_85849_();
        });
    }
}

