/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.renderer.vortex;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11;
import whocraft.tardis_refined.TRConfig;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.model.blockentity.door.interior.ShellDoorModel;
import whocraft.tardis_refined.client.model.blockentity.shell.ShellModelCollection;
import whocraft.tardis_refined.client.overlays.VortexOverlay;
import whocraft.tardis_refined.client.renderer.vortex.RenderTargetStencil;
import whocraft.tardis_refined.common.VortexRegistry;
import whocraft.tardis_refined.common.block.door.GlobalDoorBlock;
import whocraft.tardis_refined.common.block.door.InternalDoorBlock;
import whocraft.tardis_refined.common.blockentity.door.GlobalDoorBlockEntity;
import whocraft.tardis_refined.compat.ModCompatChecker;
import whocraft.tardis_refined.compat.portals.ImmersivePortalsClient;

public class RenderTargetHelper {
    private static final RenderTargetHelper RENDER_TARGET_HELPER = new RenderTargetHelper();
    public static StencilBufferStorage stencilBufferStorage = new StencilBufferStorage();
    public RenderTarget renderTarget;
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefinbed/StencilRendering");
    private static ResourceLocation BLACK = new ResourceLocation("tardis_refined", "textures/black_portal.png");

    public static void renderVortex(GlobalDoorBlockEntity blockEntity, float partialTick, PoseStack stack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState blockstate = blockEntity.m_58900_();
        ResourceLocation theme = blockEntity.theme();
        float rotation = ((Direction)blockstate.m_61143_((Property)InternalDoorBlock.FACING)).m_122435_();
        boolean isOpen = (Boolean)blockstate.m_61143_((Property)InternalDoorBlock.OPEN);
        ShellDoorModel currentModel = ShellModelCollection.getInstance().getShellEntry(theme).getShellDoorModel(blockEntity.pattern());
        if (currentModel == null) {
            return;
        }
        TardisClientData tardisClientData = TardisClientData.getInstance((ResourceKey<Level>)blockEntity.m_58904_().m_46472_());
        VortexOverlay.VORTEX.vortexType = VortexRegistry.VORTEX_DEFERRED_REGISTRY.get(tardisClientData.getVortex());
        if (blockstate.m_61138_((Property)GlobalDoorBlock.OFFSET) && ((Boolean)blockstate.m_61143_((Property)GlobalDoorBlock.OFFSET)).booleanValue()) {
            Direction facing = (Direction)blockstate.m_61143_((Property)InternalDoorBlock.FACING);
            double xOffset = 0.0;
            double zOffset = 0.0;
            switch (facing) {
                case NORTH: {
                    xOffset = -0.5;
                    break;
                }
                case SOUTH: {
                    xOffset = 0.5;
                    break;
                }
                case EAST: {
                    zOffset = -0.5;
                    break;
                }
                case WEST: {
                    zOffset = 0.5;
                }
            }
            stack.m_85837_(xOffset, 0.0, zOffset);
        }
        if (tardisClientData.isFlying() && ((Boolean)TRConfig.CLIENT.RENDER_VORTEX_IN_DOOR.get()).booleanValue()) {
            RenderTargetHelper.renderDoorOpen(blockEntity, stack, bufferSource, packedLight, rotation, currentModel, isOpen, tardisClientData);
        } else {
            RenderTargetHelper.renderNoVortex(blockEntity, stack, bufferSource, packedLight, rotation, currentModel, isOpen);
        }
    }

    private static void renderDoorOpen(GlobalDoorBlockEntity blockEntity, PoseStack stack, MultiBufferSource bufferSource, int packedLight, float rotation, ShellDoorModel currentModel, boolean isOpen, TardisClientData tardisClientData) {
        if (ModCompatChecker.immersivePortals() && ImmersivePortalsClient.shouldStopRenderingInPortal()) {
            return;
        }
        if (!RenderTargetHelper.getIsStencilEnabled(Minecraft.m_91087_().m_91385_())) {
            RenderTargetHelper.setIsStencilEnabled(Minecraft.m_91087_().m_91385_(), true);
        }
        stack.m_85836_();
        stack.m_252880_(0.5f, 1.5f, 0.5f);
        stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        stack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        stack.m_85837_(0.0, 0.0, -0.01);
        RenderSystem.depthMask((boolean)true);
        MultiBufferSource.BufferSource imBuffer = stencilBufferStorage.getVertexConsumer();
        currentModel.setDoorPosition(isOpen);
        currentModel.renderFrame(blockEntity, isOpen, true, stack, imBuffer.m_6299_(RenderType.m_110452_((ResourceLocation)currentModel.getInteriorDoorTexture(blockEntity))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        imBuffer.m_109911_();
        GL11.glEnable((int)2960);
        GL11.glStencilMask((int)255);
        GL11.glClear((int)1024);
        GL11.glStencilFunc((int)519, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        RenderSystem.depthMask((boolean)true);
        stack.m_85836_();
        currentModel.renderPortalMask(blockEntity, isOpen, true, stack, imBuffer.m_6299_(RenderType.m_110470_((ResourceLocation)BLACK)), packedLight, OverlayTexture.f_118083_, 0.0f, 0.0f, 0.0f, 1.0f);
        imBuffer.m_109911_();
        stack.m_85849_();
        RenderSystem.depthMask((boolean)false);
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)1, (int)255);
        GlStateManager._depthFunc((int)519);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        stack.m_85836_();
        stack.m_85841_(10.0f, 10.0f, 10.0f);
        VortexOverlay.VORTEX.time.speed = 0.3f + (float)tardisClientData.getThrottleStage() * 0.1f;
        VortexOverlay.VORTEX.renderVortex(stack, 1.0f, false);
        stack.m_85849_();
        GlStateManager._depthFunc((int)515);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDisable((int)2960);
        GL11.glStencilMask((int)255);
        RenderSystem.depthMask((boolean)true);
        stack.m_85849_();
    }

    public static void checkGLError(String msg) {
        int error;
        while ((error = GL11.glGetError()) != 0) {
            LOGGER.debug("{}: {}", (Object)msg, (Object)error);
        }
    }

    private static void renderNoVortex(GlobalDoorBlockEntity blockEntity, PoseStack stack, MultiBufferSource bufferSource, int packedLight, float rotation, ShellDoorModel currentModel, boolean isOpen) {
        stack.m_85836_();
        stack.m_252880_(0.5f, 1.5f, 0.5f);
        stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        stack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        stack.m_85837_(0.0, 0.0, -0.01);
        currentModel.setDoorPosition(isOpen);
        currentModel.renderFrame(blockEntity, isOpen, true, stack, bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)currentModel.getInteriorDoorTexture(blockEntity))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        currentModel.renderPortalMask(blockEntity, isOpen, true, stack, bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)currentModel.getInteriorDoorTexture(blockEntity))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean getIsStencilEnabled(RenderTarget renderTarget) {
        return ((RenderTargetStencil)renderTarget).tr$getisStencilEnabled();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setIsStencilEnabled(RenderTarget renderTarget, boolean cond) {
        ((RenderTargetStencil)renderTarget).tr$setisStencilEnabledAndReload(cond);
    }

    public void start() {
        GLFW.glfwWindowHint((int)139271, (int)1);
        Window window = Minecraft.m_91087_().m_91268_();
        int width = window.m_85441_();
        int height = window.m_85442_();
        if (this.renderTarget == null || this.renderTarget.f_83915_ != width || this.renderTarget.f_83916_ != height) {
            this.renderTarget = new TextureTarget(width, height, true, Minecraft.f_91002_);
        }
        this.renderTarget.m_83947_(false);
        this.renderTarget.m_83949_();
        if (!RenderTargetHelper.getIsStencilEnabled(this.renderTarget)) {
            RenderTargetHelper.setIsStencilEnabled(this.renderTarget, true);
        }
    }

    public void end(boolean clear) {
        this.renderTarget.m_83954_(clear);
        this.renderTarget.m_83970_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class StencilBufferStorage
    extends RenderBuffers {
        private static final RenderStateShard.TextureStateShard BLOCK_SHEET_MIPPED_BUTMINE = new RenderStateShard.TextureStateShard(TextureAtlas.f_118259_, false, true);
        private final Object2ObjectLinkedOpenHashMap typeBufferBuilder = (Object2ObjectLinkedOpenHashMap)Util.m_137469_((Object)new Object2ObjectLinkedOpenHashMap(), map -> StencilBufferStorage.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)map, StencilBufferStorage.getConsumer()));
        private final MultiBufferSource.BufferSource consumer = MultiBufferSource.m_109900_((Map)this.typeBufferBuilder, (BufferBuilder)new BufferBuilder(256));

        public static RenderType getConsumer() {
            RenderType.CompositeState parameters = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED_BUTMINE).m_110685_(RenderStateShard.f_110139_).m_110669_(RenderStateShard.f_110117_).m_110691_(false);
            return RenderType.m_173215_((String)"vortex", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)parameters);
        }

        private static void put(Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder> builderStorage, RenderType layer) {
            builderStorage.put((Object)layer, (Object)new BufferBuilder(layer.m_110507_()));
        }

        public MultiBufferSource.BufferSource getVertexConsumer() {
            return this.consumer;
        }
    }
}

