/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4f;
import whocraft.tardis_refined.TRConfig;
import whocraft.tardis_refined.client.TRParticles;
import whocraft.tardis_refined.common.entity.ControlEntity;
import whocraft.tardis_refined.compat.CuriosTrinketsUtil;

public class ControlEntityRenderer
extends NoopRenderer<ControlEntity> {
    private static final ResourceLocation ICON_GOOD = new ResourceLocation("tardis_refined", "textures/gui/sprites/control/control_good.png");
    private static final ResourceLocation ICON_SLIPPING = new ResourceLocation("tardis_refined", "textures/gui/sprites/control/control_slipping.png");
    private static final ResourceLocation ICON_WARNING = new ResourceLocation("tardis_refined", "textures/gui/sprites/control/control_warning.png");
    private static final ResourceLocation ICON_ALERT = new ResourceLocation("tardis_refined", "textures/gui/sprites/control/control_alert.png");
    private static final ResourceLocation ICON_DANGER = new ResourceLocation("tardis_refined", "textures/gui/sprites/control/control_danger.png");

    public ControlEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    private static void vertex(VertexConsumer builder, PoseStack matrixStack, float x, float y, float z, float u, float v, int light) {
        ControlEntityRenderer.vertex(builder, matrixStack, x, y, z, u, v, 255, light);
    }

    private static void vertex(VertexConsumer builder, PoseStack matrixStack, float x, float y, float z, float u, float v, int alpha, int light) {
        PoseStack.Pose entry = matrixStack.m_85850_();
        builder.m_252986_(entry.m_252922_(), x, y, z).m_6122_(255, 255, 255, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(entry.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
    }

    protected boolean shouldShowName(ControlEntity entity) {
        return (Boolean)TRConfig.CLIENT.CONTROL_NAMES.get() != false && Minecraft.m_91404_() && this.isMouseOverEntity(entity);
    }

    private boolean isMouseOverEntity(ControlEntity entity) {
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult == null) {
            return false;
        }
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            return entityHitResult.m_82443_() == entity;
        }
        return false;
    }

    public void render(ControlEntity entity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        if (this.shouldShowName(entity)) {
            this.renderNameTag(entity, entity.m_5446_(), poseStack, multiBufferSource, i);
        }
        Level entityLevel = entity.m_9236_();
        if (!CuriosTrinketsUtil.getInstance().getFirstFoundGlider((LivingEntity)Minecraft.m_91087_().f_91074_).m_41619_() && entity.isTickingDown() && entityLevel.f_46441_.m_188503_(20) == 0) {
            entityLevel.m_7106_((ParticleOptions)TRParticles.GALLIFREY.get(), entity.m_20208_(0.1), (double)entity.m_20183_().m_123342_(), entity.m_20262_(0.1), 0.0, 0.0, 0.0);
        }
    }

    protected void renderNameTag(ControlEntity entity, Component component, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLightCoords) {
        double distanceSquared = this.f_114476_.m_114471_((Entity)entity);
        if (!(distanceSquared > 2050.0)) {
            boolean isSolid = !entity.m_20163_();
            float boundingBoxHeight = entity.m_278726_() - 0.3f;
            int verticalTextOffset = 10;
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, (double)boundingBoxHeight, 0.0);
            poseStack.m_252781_(this.f_114476_.m_253208_());
            float scale = 0.007f;
            poseStack.m_85841_(-scale, -scale, scale);
            Matrix4f textMatrix = poseStack.m_85850_().m_252922_();
            Font font = this.m_114481_();
            float textHorizontalPosition = -font.m_92852_((FormattedText)component) / 2;
            FormattedCharSequence sequence = component.m_7532_();
            font.m_168645_(sequence, textHorizontalPosition, (float)verticalTextOffset, 0xFFFFFF, 0, textMatrix, multiBufferSource, packedLightCoords);
            if (isSolid) {
                font.m_168645_(sequence, textHorizontalPosition, (float)verticalTextOffset, 0xFFFFFF, 0, textMatrix, multiBufferSource, packedLightCoords);
            }
            int entityHealth = entity.getControlHealth();
            poseStack.m_85837_(0.0, 5.0, 0.0);
            this.renderControlIcon(entity, component, this.getIconByState(entityHealth), poseStack, multiBufferSource, packedLightCoords);
            poseStack.m_85849_();
        }
    }

    public ResourceLocation getIconByState(int entityHealth) {
        if (entityHealth == 10) {
            return ICON_GOOD;
        }
        if (entityHealth >= 8) {
            return ICON_SLIPPING;
        }
        if (entityHealth > 5) {
            return ICON_WARNING;
        }
        if (entityHealth > 3) {
            return ICON_ALERT;
        }
        return ICON_DANGER;
    }

    private void renderControlIcon(ControlEntity entity, Component component, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource buffer, int light) {
        float offset = -(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component) / 2 + 18);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)texture));
        int alpha = 32;
        if (entity.m_20163_()) {
            ControlEntityRenderer.vertex(builder, matrixStackIn, offset, 16.0f, 0.0f, 0.0f, 1.0f, alpha, light);
            ControlEntityRenderer.vertex(builder, matrixStackIn, offset + 16.0f, 16.0f, 0.0f, 1.0f, 1.0f, alpha, light);
            ControlEntityRenderer.vertex(builder, matrixStackIn, offset + 16.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, light);
            ControlEntityRenderer.vertex(builder, matrixStackIn, offset, 0.0f, 0.0f, 0.0f, 0.0f, alpha, light);
        } else {
            ControlEntityRenderer.vertex(builder, matrixStackIn, offset, 16.0f, 0.0f, 0.0f, 1.0f, light);
            ControlEntityRenderer.vertex(builder, matrixStackIn, offset + 16.0f, 16.0f, 0.0f, 1.0f, 1.0f, light);
            ControlEntityRenderer.vertex(builder, matrixStackIn, offset + 16.0f, 0.0f, 0.0f, 1.0f, 0.0f, light);
            ControlEntityRenderer.vertex(builder, matrixStackIn, offset, 0.0f, 0.0f, 0.0f, 0.0f, light);
            VertexConsumer builderSeeThrough = buffer.m_6299_(RenderType.m_110500_((ResourceLocation)texture));
            ControlEntityRenderer.vertex(builderSeeThrough, matrixStackIn, offset, 16.0f, 0.0f, 0.0f, 1.0f, alpha, light);
            ControlEntityRenderer.vertex(builderSeeThrough, matrixStackIn, offset + 16.0f, 16.0f, 0.0f, 1.0f, 1.0f, alpha, light);
            ControlEntityRenderer.vertex(builderSeeThrough, matrixStackIn, offset + 16.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, light);
            ControlEntityRenderer.vertex(builderSeeThrough, matrixStackIn, offset, 0.0f, 0.0f, 0.0f, 0.0f, alpha, light);
        }
    }
}

