/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.renderer.blockentity.shell;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import whocraft.tardis_refined.client.ModelRegistry;
import whocraft.tardis_refined.client.model.GenericModel;
import whocraft.tardis_refined.common.block.shell.RootedShellBlock;
import whocraft.tardis_refined.common.block.shell.ShellBaseBlock;
import whocraft.tardis_refined.common.blockentity.shell.RootedShellBlockEntity;

public class RootShellRenderer
implements BlockEntityRenderer<RootedShellBlockEntity>,
BlockEntityRendererProvider<RootedShellBlockEntity> {
    private static final ResourceLocation rootShellTexture = new ResourceLocation("tardis_refined", "textures/blockentity/shell/root/root_shell.png");
    private static final ResourceLocation rootShellClosed = new ResourceLocation("tardis_refined", "textures/blockentity/shell/root/root_shell_closed.png");
    private static GenericModel rootShellModel;

    public RootShellRenderer(BlockEntityRendererProvider.Context context) {
        rootShellModel = new GenericModel(context.m_173582_(ModelRegistry.ROOT_SHELL));
    }

    public void render(RootedShellBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 1.475f, 0.5f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        BlockState blockstate = blockEntity.m_58900_();
        float rotation = ((Direction)blockstate.m_61143_((Property)RootedShellBlock.FACING)).m_122435_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        boolean isOpen = (Boolean)blockEntity.m_58900_().m_61143_((Property)ShellBaseBlock.OPEN);
        rootShellModel.m_7695_(poseStack, multiBufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)(isOpen ? rootShellTexture : rootShellClosed))), i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        float sine = 0.0f;
        if (((Boolean)blockstate.m_61143_((Property)ShellBaseBlock.REGEN)).booleanValue()) {
            sine = (float)(Math.sin(0.1 * (double)blockEntity.m_58904_().m_8044_()) * 1.0);
            if (sine < 0.0f) {
                sine = 0.0f;
            }
            rootShellModel.m_7695_(poseStack, multiBufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)rootShellClosed)), i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, sine);
        }
        poseStack.m_85849_();
    }

    public boolean shouldRender(RootedShellBlockEntity blockEntity, Vec3 vec3) {
        return true;
    }

    public boolean shouldRenderOffScreen(RootedShellBlockEntity blockEntity) {
        return true;
    }

    public BlockEntityRenderer<RootedShellBlockEntity> m_173570_(BlockEntityRendererProvider.Context context) {
        return new RootShellRenderer(context);
    }
}

