/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.model.blockentity.console;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.jeryn.frame.tardis.Frame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import whocraft.tardis_refined.TRConfig;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.model.blockentity.console.ConsoleUnit;
import whocraft.tardis_refined.common.block.console.GlobalConsoleBlock;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;

public class RefurbishedConsoleModel
extends HierarchicalModel
implements ConsoleUnit {
    private static final ResourceLocation REFURBISHED_TEXTURE = new ResourceLocation("tardis_refined", "textures/blockentity/console/refurbished/refurbished_console.png");
    private final ModelPart root;
    private final ModelPart throttle;
    private final ModelPart handbrake;
    public static final AnimationDefinition IDLE = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/refurbished/idle.json"));
    public static final AnimationDefinition FLIGHT = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/refurbished/flight.json"));

    public RefurbishedConsoleModel(ModelPart root) {
        this.root = root;
        this.throttle = Frame.findPart(this, "throttle");
        this.handbrake = Frame.findPart(this, "bone309");
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    @Override
    public void renderConsole(GlobalConsoleBlockEntity globalConsoleBlock, Level level, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float rot;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        TardisClientData reactions = TardisClientData.getInstance((ResourceKey<Level>)level.m_46472_());
        if (globalConsoleBlock != null && ((Boolean)globalConsoleBlock.m_58900_().m_61143_((Property)GlobalConsoleBlock.POWERED)).booleanValue()) {
            if (reactions.isFlying()) {
                this.m_233381_(reactions.ROTOR_ANIMATION, FLIGHT, Minecraft.m_91087_().f_91074_.f_19797_);
            } else if (((Boolean)TRConfig.CLIENT.PLAY_CONSOLE_IDLE_ANIMATIONS.get()).booleanValue() && globalConsoleBlock != null) {
                this.m_233381_(globalConsoleBlock.liveliness, IDLE, Minecraft.m_91087_().f_91074_.f_19797_);
            }
        }
        this.throttle.f_104203_ = rot = -1.0f + 2.0f * ((float)reactions.getThrottleStage() / 5.0f);
        this.handbrake.f_104203_ = reactions.isHandbrakeEngaged() ? 1.0f : 0.0f;
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return REFURBISHED_TEXTURE;
    }

    public void m_6973_(Entity entity, float f, float g, float h, float i, float j) {
    }
}

