/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.extra_shells.forge.data;

import dev.jeryn.extra_shells.ESShellRegistry;
import dev.jeryn.extra_shells.ESSounds;
import java.util.Optional;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import whocraft.tardis_refined.common.data.ShellPatternProvider;
import whocraft.tardis_refined.patterns.PatternTexture;
import whocraft.tardis_refined.patterns.ShellPattern;
import whocraft.tardis_refined.patterns.ShellPatterns;
import whocraft.tardis_refined.patterns.sound.ConfiguredSound;
import whocraft.tardis_refined.patterns.sound.ShellSoundProfile;
import whocraft.tardis_refined.patterns.sound.TRShellSoundProfiles;

public class ESPatterns
extends ShellPatternProvider {
    protected void addPatterns() {
        this.quickAdd(ESShellRegistry.MADDOC_WHITTAKER.getId(), "default", false);
        this.quickAdd(ESShellRegistry.MADDOC_NEWBERRY.getId(), "default", false);
        this.quickAdd(ESShellRegistry.MADDOC_2005.getId(), "tennant", false);
        this.quickAdd(ESShellRegistry.MADDOC_2005.getId(), "eccleston", false);
        this.quickAdd(ESShellRegistry.MADDOC_SMITH.getId(), "default", false);
        this.quickAdd(ESShellRegistry.MADDOC_BRACHACKI.getId(), "default", false);
        this.quickAdd(ESShellRegistry.OLD_SCHOOL.getId(), "default", false);
        this.quickAdd(ESShellRegistry.OLD_SCHOOL.getId(), "tardim", false);
        this.quickAdd(ESShellRegistry.EMERALD.getId(), "default", true);
        this.quickAdd(ESShellRegistry.ENGINEERS.getId(), "default", true);
        this.quickAdd(ESShellRegistry.SEA_BLUE.getId(), "default", true);
        this.quickAdd(ESShellRegistry.RTD_ERA.getId(), "default", true);
        this.quickAdd(ESShellRegistry.RTD_ERA.getId(), "tenth", true);
        this.quickAdd(ESShellRegistry.RTD_ERA.getId(), "bad_wolf", true);
        this.quickAdd(ESShellRegistry.RTD_ERA.getId(), "overgrown", true);
        this.quickAdd(ESShellRegistry.MOFFAT_ERA.getId(), "default", true);
        this.quickAdd(ESShellRegistry.MOFFAT_ERA.getId(), "twelfth", true);
        this.quickAdd(ESShellRegistry.GLASGOW.getId(), "default", true);
        this.quickAdd(ESShellRegistry.CHIBNALL_RTD_ERA.getId(), "default", true);
        this.quickAdd(ESShellRegistry.CHIBNALL_RTD_ERA.getId(), "fourteen", true);
        this.quickAdd(ESShellRegistry.ANCIENT.getId(), "default", true);
        this.quickAdd(ESShellRegistry.ANCIENT.getId(), "damaged", true);
        this.quickAdd(ESShellRegistry.LEGO.getId(), "default", true);
        this.quickAdd(ESShellRegistry.LEGO.getId(), "piece", true);
        this.quickAdd(ESShellRegistry.LEGO.getId(), "dimensions", true);
        ShellSoundProfile soundProfile = new ShellSoundProfile();
        soundProfile.setDoorClose(new ConfiguredSound((SoundEvent)ESSounds.DELOREAN_CLOSED.get()));
        soundProfile.setDoorOpen(new ConfiguredSound((SoundEvent)ESSounds.DELOREAN_OPEN.get()));
        soundProfile.setDoorLocked(new ConfiguredSound((SoundEvent)ESSounds.DELOREAN_LOCKED.get()));
        this.quickAdd(ESShellRegistry.DELOREAN.getId(), "default", true, soundProfile);
        this.quickAdd(ESShellRegistry.DELOREAN.getId(), "future", true, soundProfile);
    }

    public void quickAdd(ResourceLocation themeId, String patternName, boolean hasEmissiveTexture) {
        this.addPattern(themeId, this.createPattern(themeId, patternName, hasEmissiveTexture));
    }

    public void quickAdd(ResourceLocation themeId, String patternName, boolean hasEmissiveTexture, ShellSoundProfile soundProfile) {
        this.addPattern(themeId, this.createPattern(themeId, patternName, hasEmissiveTexture, soundProfile));
    }

    public ShellPattern createPattern(ResourceLocation themeId, String patternName, boolean hasEmissiveTexture) {
        ResourceLocation exteriorTextureLocation = ShellPatterns.exteriorTextureLocation((ResourceLocation)themeId, (String)"extra_shells", (String)patternName);
        ResourceLocation interiorTextureLocation = ShellPatterns.interiorTextureLocation((ResourceLocation)themeId, (String)"extra_shells", (String)patternName);
        ShellSoundProfile soundProfile = TRShellSoundProfiles.defaultSoundProfilesByTheme().getOrDefault(themeId, TRShellSoundProfiles.DEFAULT_SOUND_PROFILE);
        ShellPattern pattern = new ShellPattern(new ResourceLocation(themeId.m_135827_(), patternName), new PatternTexture(exteriorTextureLocation, hasEmissiveTexture), new PatternTexture(interiorTextureLocation, hasEmissiveTexture), Optional.of(soundProfile));
        pattern.setThemeId(themeId);
        return ShellPatterns.addDefaultPattern((ResourceLocation)themeId, (ShellPattern)pattern);
    }

    public ShellPattern createPattern(ResourceLocation themeId, String patternName, boolean hasEmissiveTexture, ShellSoundProfile soundProfile) {
        ResourceLocation exteriorTextureLocation = ShellPatterns.exteriorTextureLocation((ResourceLocation)themeId, (String)"extra_shells", (String)patternName);
        ResourceLocation interiorTextureLocation = ShellPatterns.interiorTextureLocation((ResourceLocation)themeId, (String)"extra_shells", (String)patternName);
        ShellPattern pattern = new ShellPattern(new ResourceLocation(themeId.m_135827_(), patternName), new PatternTexture(exteriorTextureLocation, hasEmissiveTexture), new PatternTexture(interiorTextureLocation, hasEmissiveTexture), Optional.of(soundProfile));
        pattern.setThemeId(themeId);
        return ShellPatterns.addDefaultPattern((ResourceLocation)themeId, (ShellPattern)pattern);
    }

    public ESPatterns(DataGenerator generator) {
        super(generator, "extra_shells", false);
    }

    public String m_6055_() {
        return "ExtraShells Patterns";
    }
}

