/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.camera.infrastructure.CompositionGuide;
import io.github.mortuusars.exposure.camera.infrastructure.FlashMode;
import io.github.mortuusars.exposure.camera.infrastructure.ShutterSpeed;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.server.CameraSetCompositionGuideC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetFlashModeC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetSelfieModeC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetShutterSpeedC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetZoomC2SP;
import io.github.mortuusars.exposure.network.packet.server.DeactivateCameraC2SP;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CameraClient {
    public static Optional<Camera<?>> getCamera() {
        return Camera.getCamera((Player)Minecraft.m_91087_().f_91074_);
    }

    public static void deactivate(Player player) {
        Preconditions.checkState((boolean)player.m_9236_().f_46443_, (Object)"Can only be called clientside.");
        Camera.getCamera(player).ifPresent(camera -> camera.deactivate(player));
        Packets.sendToServer(new DeactivateCameraC2SP());
    }

    public static void setZoom(double focalLength) {
        CameraClient.getCamera().ifPresent(c -> {
            c.apply((item, stack) -> item.setZoom((ItemStack)stack, focalLength));
            Packets.sendToServer(new CameraSetZoomC2SP(focalLength));
        });
    }

    public static void setShutterSpeed(ShutterSpeed shutterSpeed) {
        CameraClient.getCamera().ifPresent(c -> {
            c.apply((item, stack) -> item.setShutterSpeed((ItemStack)stack, shutterSpeed));
            Packets.sendToServer(new CameraSetShutterSpeedC2SP(shutterSpeed));
        });
    }

    public static void setFlashMode(FlashMode flashMode) {
        CameraClient.getCamera().ifPresent(c -> {
            c.apply((item, stack) -> item.setFlashMode((ItemStack)stack, flashMode));
            Packets.sendToServer(new CameraSetFlashModeC2SP(flashMode));
        });
    }

    public static void setCompositionGuide(CompositionGuide guide) {
        CameraClient.getCamera().ifPresent(c -> {
            c.apply((item, stack) -> item.setCompositionGuide((ItemStack)stack, guide));
            Packets.sendToServer(new CameraSetCompositionGuideC2SP(guide));
        });
    }

    public static void setSelfieMode(boolean inSelfieMode) {
        CameraClient.getCamera().ifPresent(c -> {
            c.apply((item, stack) -> item.setSelfieModeWithEffects((Player)Minecraft.m_91087_().f_91074_, (ItemStack)stack, inSelfieMode));
            Packets.sendToServer(new CameraSetSelfieModeC2SP(inSelfieMode));
        });
    }
}

