/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.Register;
import io.github.mortuusars.exposure.advancement.trigger.FrameExposedTrigger;
import io.github.mortuusars.exposure.block.FlashBlock;
import io.github.mortuusars.exposure.block.LightroomBlock;
import io.github.mortuusars.exposure.block.entity.FlashBlockEntity;
import io.github.mortuusars.exposure.block.entity.LightroomBlockEntity;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.command.argument.ExposureLookArgument;
import io.github.mortuusars.exposure.command.argument.ExposureSizeArgument;
import io.github.mortuusars.exposure.command.argument.ShaderLocationArgument;
import io.github.mortuusars.exposure.command.argument.TextureLocationArgument;
import io.github.mortuusars.exposure.entity.PhotographEntity;
import io.github.mortuusars.exposure.entity.PhotographFrameEntity;
import io.github.mortuusars.exposure.item.AlbumItem;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.item.FilmRollItem;
import io.github.mortuusars.exposure.item.InterplanarProjectorItem;
import io.github.mortuusars.exposure.item.PhotographFrameItem;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.item.SignedAlbumItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.menu.AlbumMenu;
import io.github.mortuusars.exposure.menu.CameraAttachmentsMenu;
import io.github.mortuusars.exposure.menu.ItemRenameMenu;
import io.github.mortuusars.exposure.menu.LecternAlbumMenu;
import io.github.mortuusars.exposure.menu.LightroomMenu;
import io.github.mortuusars.exposure.recipe.FilmDevelopingRecipe;
import io.github.mortuusars.exposure.recipe.PhotographAgingRecipe;
import io.github.mortuusars.exposure.recipe.PhotographCopyingRecipe;
import io.github.mortuusars.exposure.util.CameraInHand;
import io.github.mortuusars.exposure.util.supporter.Supporters;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatFormatter;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.slf4j.Logger;

public class Exposure {
    public static final String ID = "exposure";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final float CROP_FACTOR = 1.142857f;

    public static void init() {
        Blocks.init();
        BlockEntityTypes.init();
        EntityTypes.init();
        Items.init();
        MenuTypes.init();
        RecipeSerializers.init();
        SoundEvents.init();
        ArgumentTypes.init();
        Supporters.query();
        Camera.registerCameraGetter(Exposure.resource("camera_in_hand"), player -> CameraInHand.ofPlayer(player, CameraItem.class));
    }

    public static void initServer(MinecraftServer server) {
        ExposureServer.init(server);
    }

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(ID, path);
    }

    public static class Blocks {
        public static final Supplier<LightroomBlock> LIGHTROOM = Register.block("lightroom", () -> new LightroomBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_60953_(state -> 15)));
        public static final Supplier<FlashBlock> FLASH = Register.block("flash", () -> new FlashBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)net.minecraft.world.level.block.Blocks.f_50016_).m_60913_(-1.0f, 3600000.8f).m_222994_().m_284180_(MapColor.f_283808_).m_60955_().m_60910_().m_60953_(state -> 15)));

        static void init() {
        }
    }

    public static class BlockEntityTypes {
        public static final Supplier<BlockEntityType<LightroomBlockEntity>> LIGHTROOM = Register.blockEntityType("lightroom", () -> Register.newBlockEntityType(LightroomBlockEntity::new, Blocks.LIGHTROOM.get()));
        public static final Supplier<BlockEntityType<FlashBlockEntity>> FLASH = Register.blockEntityType("flash", () -> Register.newBlockEntityType(FlashBlockEntity::new, Blocks.FLASH.get()));

        static void init() {
        }
    }

    public static class EntityTypes {
        public static final Supplier<EntityType<PhotographEntity>> PHOTOGRAPH = Register.entityType("photograph", PhotographEntity::new, MobCategory.MISC, 0.5f, 0.5f, 128, false, Integer.MAX_VALUE);
        public static final Supplier<EntityType<PhotographFrameEntity>> PHOTOGRAPH_FRAME = Register.entityType("photograph_frame", PhotographFrameEntity::new, MobCategory.MISC, 0.5f, 0.5f, 128, false, Integer.MAX_VALUE);

        static void init() {
        }
    }

    public static class Items {
        public static final Supplier<CameraItem> CAMERA = Register.item("camera", () -> new CameraItem(new Item.Properties().m_41487_(1)));
        public static final Supplier<FilmRollItem> BLACK_AND_WHITE_FILM = Register.item("black_and_white_film", () -> new FilmRollItem(FilmType.BLACK_AND_WHITE, Mth.m_14159_((float)0.8f, (float)0.8f, (float)0.9f), new Item.Properties().m_41487_(16)));
        public static final Supplier<FilmRollItem> COLOR_FILM = Register.item("color_film", () -> new FilmRollItem(FilmType.COLOR, Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f), new Item.Properties().m_41487_(16)));
        public static final Supplier<DevelopedFilmItem> DEVELOPED_BLACK_AND_WHITE_FILM = Register.item("developed_black_and_white_film", () -> new DevelopedFilmItem(FilmType.BLACK_AND_WHITE, new Item.Properties().m_41487_(1)));
        public static final Supplier<DevelopedFilmItem> DEVELOPED_COLOR_FILM = Register.item("developed_color_film", () -> new DevelopedFilmItem(FilmType.COLOR, new Item.Properties().m_41487_(1)));
        public static final Supplier<PhotographItem> PHOTOGRAPH = Register.item("photograph", () -> new PhotographItem(new Item.Properties().m_41487_(1)));
        public static final Supplier<ChromaticSheetItem> CHROMATIC_SHEET = Register.item("chromatic_sheet", () -> new ChromaticSheetItem(new Item.Properties().m_41487_(1)));
        public static final Supplier<PhotographItem> AGED_PHOTOGRAPH = Register.item("aged_photograph", () -> new PhotographItem(new Item.Properties().m_41487_(1)));
        public static final Supplier<InterplanarProjectorItem> INTERPLANAR_PROJECTOR = Register.item("interplanar_projector", () -> new InterplanarProjectorItem(new Item.Properties()));
        public static final Supplier<StackedPhotographsItem> STACKED_PHOTOGRAPHS = Register.item("stacked_photographs", () -> new StackedPhotographsItem(new Item.Properties().m_41487_(1)));
        public static final Supplier<AlbumItem> ALBUM = Register.item("album", () -> new AlbumItem(new Item.Properties().m_41487_(1)));
        public static final Supplier<SignedAlbumItem> SIGNED_ALBUM = Register.item("signed_album", () -> new SignedAlbumItem(new Item.Properties().m_41487_(1)));
        public static final Supplier<PhotographFrameItem> PHOTOGRAPH_FRAME = Register.item("photograph_frame", () -> new PhotographFrameItem(new Item.Properties()));
        public static final Supplier<BlockItem> LIGHTROOM = Register.item("lightroom", () -> new BlockItem((Block)Blocks.LIGHTROOM.get(), new Item.Properties()));

        static void init() {
        }
    }

    public static class MenuTypes {
        public static final Supplier<MenuType<CameraAttachmentsMenu>> CAMERA = Register.menuType("camera", CameraAttachmentsMenu::fromBuffer);
        public static final Supplier<MenuType<AlbumMenu>> ALBUM = Register.menuType("album", AlbumMenu::fromBuffer);
        public static final Supplier<MenuType<LecternAlbumMenu>> LECTERN_ALBUM = Register.menuType("lectern_album", LecternAlbumMenu::fromBuffer);
        public static final Supplier<MenuType<LightroomMenu>> LIGHTROOM = Register.menuType("lightroom", LightroomMenu::fromBuffer);
        public static final Supplier<MenuType<ItemRenameMenu>> ITEM_RENAME = Register.menuType("item_rename", ItemRenameMenu::fromBuffer);

        static void init() {
        }
    }

    public static class RecipeSerializers {
        public static final Supplier<RecipeSerializer<?>> FILM_DEVELOPING = Register.recipeSerializer("film_developing", FilmDevelopingRecipe.Serializer::new);
        public static final Supplier<RecipeSerializer<?>> PHOTOGRAPH_CLONING = Register.recipeSerializer("photograph_copying", PhotographCopyingRecipe.Serializer::new);
        public static final Supplier<RecipeSerializer<?>> PHOTOGRAPH_AGING = Register.recipeSerializer("photograph_aging", PhotographAgingRecipe.Serializer::new);

        static void init() {
        }
    }

    public static class SoundEvents {
        public static final Supplier<SoundEvent> VIEWFINDER_OPEN = SoundEvents.register("item", "camera.viewfinder_open");
        public static final Supplier<SoundEvent> VIEWFINDER_CLOSE = SoundEvents.register("item", "camera.viewfinder_close");
        public static final Supplier<SoundEvent> SHUTTER_OPEN = SoundEvents.register("item", "camera.shutter_open");
        public static final Supplier<SoundEvent> SHUTTER_CLOSE = SoundEvents.register("item", "camera.shutter_close");
        public static final Supplier<SoundEvent> SHUTTER_TICKING = SoundEvents.register("item", "camera.shutter_ticking");
        public static final Supplier<SoundEvent> FILM_ADVANCING = SoundEvents.register("item", "camera.film_advance");
        public static final Supplier<SoundEvent> FILM_ADVANCE_LAST = SoundEvents.register("item", "camera.film_advance_last");
        public static final Supplier<SoundEvent> FILM_REMOVED = SoundEvents.register("item", "camera.film_removed");
        public static final Supplier<SoundEvent> CAMERA_GENERIC_CLICK = SoundEvents.register("item", "camera.generic_click");
        public static final Supplier<SoundEvent> CAMERA_BUTTON_CLICK = SoundEvents.register("item", "camera.button_click");
        public static final Supplier<SoundEvent> CAMERA_RELEASE_BUTTON_CLICK = SoundEvents.register("item", "camera.release_button_click");
        public static final Supplier<SoundEvent> CAMERA_DIAL_CLICK = SoundEvents.register("item", "camera.dial_click");
        public static final Supplier<SoundEvent> CAMERA_LENS_RING_CLICK = SoundEvents.register("item", "camera.lens_ring_click");
        public static final Supplier<SoundEvent> LENS_INSERT = SoundEvents.register("item", "camera.lens_insert");
        public static final Supplier<SoundEvent> LENS_REMOVE = SoundEvents.register("item", "camera.lens_remove");
        public static final Supplier<SoundEvent> FILTER_INSERT = SoundEvents.register("item", "camera.filter_insert");
        public static final Supplier<SoundEvent> FILTER_REMOVE = SoundEvents.register("item", "camera.filter_remove");
        public static final Supplier<SoundEvent> FLASH = SoundEvents.register("item", "camera.flash");
        public static final Supplier<SoundEvent> INTERPLANAR_PROJECT = SoundEvents.register("item", "camera.interplanar_projector.project");
        public static final Supplier<SoundEvent> PHOTOGRAPH_PLACE = SoundEvents.register("item", "photograph.place");
        public static final Supplier<SoundEvent> PHOTOGRAPH_BREAK = SoundEvents.register("item", "photograph.break");
        public static final Supplier<SoundEvent> PHOTOGRAPH_RUSTLE = SoundEvents.register("item", "photograph.rustle");
        public static final Supplier<SoundEvent> PHOTOGRAPH_FRAME_PLACE = SoundEvents.register("item", "photograph_frame.place");
        public static final Supplier<SoundEvent> PHOTOGRAPH_FRAME_BREAK = SoundEvents.register("item", "photograph_frame.break");
        public static final Supplier<SoundEvent> PHOTOGRAPH_FRAME_ADD_ITEM = SoundEvents.register("item", "photograph_frame.add_item");
        public static final Supplier<SoundEvent> PHOTOGRAPH_FRAME_REMOVE_ITEM = SoundEvents.register("item", "photograph_frame.remove_item");
        public static final Supplier<SoundEvent> PHOTOGRAPH_FRAME_ROTATE_ITEM = SoundEvents.register("item", "photograph_frame.rotate_item");
        public static final Supplier<SoundEvent> LIGHTROOM_PRINT = SoundEvents.register("block", "lightroom.print");

        private static Supplier<SoundEvent> register(String category, String key) {
            Preconditions.checkState((category != null && !category.isEmpty() ? 1 : 0) != 0, (Object)"'category' should not be empty.");
            Preconditions.checkState((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"'key' should not be empty.");
            String path = category + "." + key;
            return Register.soundEvent(path, () -> SoundEvent.m_262824_((ResourceLocation)Exposure.resource(path)));
        }

        static void init() {
        }
    }

    public static class ArgumentTypes {
        public static final Supplier<ArgumentTypeInfo<ExposureSizeArgument, SingletonArgumentInfo.Template>> EXPOSURE_SIZE = Register.commandArgumentType("exposure_size", ExposureSizeArgument.class, SingletonArgumentInfo.m_235451_(ExposureSizeArgument::new));
        public static final Supplier<ArgumentTypeInfo<ExposureLookArgument, SingletonArgumentInfo.Template>> EXPOSURE_LOOK = Register.commandArgumentType("exposure_look", ExposureLookArgument.class, SingletonArgumentInfo.m_235451_(ExposureLookArgument::new));
        public static final Supplier<ArgumentTypeInfo<ShaderLocationArgument, SingletonArgumentInfo.Template>> SHADER_LOCATION = Register.commandArgumentType("shader_location", ShaderLocationArgument.class, SingletonArgumentInfo.m_235451_(ShaderLocationArgument::new));
        public static final Supplier<ArgumentTypeInfo<TextureLocationArgument, SingletonArgumentInfo.Template>> TEXTURE_LOCATION = Register.commandArgumentType("texture_location", TextureLocationArgument.class, SingletonArgumentInfo.m_235451_(TextureLocationArgument::new));

        public static void init() {
        }
    }

    public static class Tags {

        public static class Blocks {
            public static final TagKey<Block> CHROMATIC_REFRACTORS = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)Exposure.resource("chromatic_refractors"));
        }

        public static class Items {
            public static final TagKey<Item> FILM_ROLLS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Exposure.resource("film_rolls"));
            public static final TagKey<Item> DEVELOPED_FILM_ROLLS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Exposure.resource("developed_film_rolls"));
            public static final TagKey<Item> CYAN_PRINTING_DYES = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Exposure.resource("cyan_printing_dyes"));
            public static final TagKey<Item> MAGENTA_PRINTING_DYES = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Exposure.resource("magenta_printing_dyes"));
            public static final TagKey<Item> YELLOW_PRINTING_DYES = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Exposure.resource("yellow_printing_dyes"));
            public static final TagKey<Item> BLACK_PRINTING_DYES = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Exposure.resource("black_printing_dyes"));
            public static final TagKey<Item> PHOTO_PAPERS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Exposure.resource("photo_papers"));
            public static final TagKey<Item> PHOTO_AGERS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Exposure.resource("photo_agers"));
            public static final TagKey<Item> FLASHES = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Exposure.resource("flashes"));
            public static final TagKey<Item> LENSES = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Exposure.resource("lenses"));
            public static final TagKey<Item> FILTERS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Exposure.resource("filters"));
            public static final TagKey<Item> RED_FILTERS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Exposure.resource("red_filters"));
            public static final TagKey<Item> GREEN_FILTERS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Exposure.resource("green_filters"));
            public static final TagKey<Item> BLUE_FILTERS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Exposure.resource("blue_filters"));
        }
    }

    public static class Advancements {
        public static FrameExposedTrigger FILM_FRAME_EXPOSED = new FrameExposedTrigger();
        public static PlayerTrigger PHOTOGRAPH_ENDERMAN_EYES = new PlayerTrigger(Exposure.resource("photograph_enderman_eyes"));

        public static void register() {
            CriteriaTriggers.m_10595_((CriterionTrigger)FILM_FRAME_EXPOSED);
            CriteriaTriggers.m_10595_((CriterionTrigger)PHOTOGRAPH_ENDERMAN_EYES);
        }
    }

    public static class Stats {
        private static final Map<ResourceLocation, StatFormatter> STATS = new HashMap<ResourceLocation, StatFormatter>();
        public static final ResourceLocation INTERACT_WITH_LIGHTROOM = Stats.register(Exposure.resource("interact_with_lightroom"), StatFormatter.f_12873_);
        public static final ResourceLocation FILM_FRAMES_EXPOSED = Stats.register(Exposure.resource("film_frames_exposed"), StatFormatter.f_12873_);
        public static final ResourceLocation FLASHES_TRIGGERED = Stats.register(Exposure.resource("flashes_triggered"), StatFormatter.f_12873_);

        private static ResourceLocation register(ResourceLocation location, StatFormatter formatter) {
            STATS.put(location, formatter);
            return location;
        }

        public static void register() {
            STATS.forEach((location, formatter) -> {
                Registry.m_122965_((Registry)BuiltInRegistries.f_256771_, (ResourceLocation)location, (Object)location);
                net.minecraft.stats.Stats.f_12988_.m_12899_(location, formatter);
            });
        }
    }
}

