/*
 * Decompiled with CFR 0.152.
 */
package cristelknight.wwoo.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cristelknight.wwoo.EEExpectPlatform;
import cristelknight.wwoo.ExpandedEcosphere;
import cristelknight.wwoo.utils.Update;
import cristelknight.wwoo.utils.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Optional;
import net.cristellib.CristelLibExpectPlatform;
import net.cristellib.util.Platform;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class Updater {
    private Optional<Update> info;
    private final String currentVersion;
    private boolean isBig = false;
    private int newUpdates;
    private static final String s = "[Expanded Ecosphere Updater]";

    public Updater(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public void checkForUpdates() {
        try {
            InputStream in = new URL("https://github.com/Cristelknight999/CristelknightUpdateChecker/releases/download/1.0/update.json").openStream();
            try {
                String updateIndex;
                try {
                    updateIndex = JsonParser.parseReader((Reader)new InputStreamReader(in)).getAsJsonObject().get(Updater.getReleaseTarget()).getAsString();
                }
                catch (NullPointerException e) {
                    ExpandedEcosphere.LOGGER.warn("[Expanded Ecosphere Updater] This version doesn't have an update index, skipping");
                    this.info = Optional.empty();
                    if (in != null) {
                        in.close();
                    }
                    return;
                }
                JsonObject object = JsonParser.parseReader((Reader)new InputStreamReader(new URL(updateIndex).openStream())).getAsJsonObject();
                ArrayList<Update> newUpdate = new ArrayList<Update>();
                for (JsonElement element : object.getAsJsonArray("versions")) {
                    Update u = (Update)new Gson().fromJson(element, Update.class);
                    boolean isForge = CristelLibExpectPlatform.getPlatform().equals((Object)Platform.FORGE);
                    if (isForge && u.modDownloadFO.isEmpty() || !isForge && u.modDownloadFA.isEmpty() || !EEExpectPlatform.isNewer(this.currentVersion, u.semanticVersion)) continue;
                    newUpdate.add(u);
                    if (!u.isBig) continue;
                    this.isBig = true;
                }
                if (newUpdate.isEmpty()) {
                    this.info = Optional.empty();
                    ExpandedEcosphere.LOGGER.info("[Expanded Ecosphere Updater] Found no updates");
                    return;
                }
                this.newUpdates = newUpdate.size();
                String isBigString = this.isBig ? " important" : "";
                ExpandedEcosphere.LOGGER.warn("[Expanded Ecosphere Updater] Found an" + isBigString + " update!");
                this.info = newUpdate.stream().findFirst();
                return;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            ExpandedEcosphere.LOGGER.warn("[Expanded Ecosphere Updater] Unable to download " + e.getMessage());
        }
        catch (IOException e) {
            ExpandedEcosphere.LOGGER.warn("[Expanded Ecosphere Updater] Failed to get update info!", (Throwable)e);
        }
        this.info = Optional.empty();
    }

    public boolean isBig() {
        return this.isBig;
    }

    public Optional<Component> getUpdateMessage() {
        Update update = this.info.orElse(null);
        if (update == null) {
            return Optional.empty();
        }
        String string = this.isBig ? "expanded_ecosphere.config.text.newUpdateBig" : "expanded_ecosphere.config.text.newUpdate";
        MutableComponent component1 = Component.m_237110_((String)"expanded_ecosphere.config.text.newUpdates", (Object[])new Object[]{this.newUpdates, this.newUpdates > 1 ? Util.translatableText("multiple") : Util.translatableText("null")}).m_130940_(ChatFormatting.GRAY);
        MutableComponent component = Component.m_237110_((String)string, (Object[])new Object[]{Util.translatableText("ch").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.UNDERLINE).m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, update.modDownloadFA))), component1});
        return Optional.of(component);
    }

    public static String getReleaseTarget() {
        return SharedConstants.m_183709_().m_132498_() ? SharedConstants.m_183709_().m_132493_() : "1.20.2";
    }
}

