/*
 * Decompiled with CFR 0.152.
 */
package cristelknight.wwoo.config.jankson.config;

import com.mojang.serialization.Codec;
import cristelknight.wwoo.config.jankson.ConfigUtil;
import cristelknight.wwoo.config.jankson.JanksonOps;
import java.nio.file.Path;
import java.util.HashMap;
import net.cristellib.CristelLibExpectPlatform;
import org.jetbrains.annotations.Nullable;

public interface CommentedConfig<T extends Record> {
    public String getSubPath();

    public T getInstance();

    public T getDefault();

    public Codec<T> getCodec();

    @Nullable
    public HashMap<String, String> getComments();

    @Nullable
    public String getHeader();

    public boolean isSorted();

    public void setInstance(T var1);

    default public T getConfig() {
        return this.getConfig(false, false);
    }

    default public Path getConfigPath() {
        return CristelLibExpectPlatform.getConfigDirectory().resolve(this.getSubPath() + ".json5");
    }

    default public T getConfig(boolean fromFile, boolean save) {
        if (this.getInstance() == null || fromFile || save) {
            this.setInstance(this.readConfig(save));
        }
        return this.getInstance();
    }

    default public T readConfig(boolean recreate) {
        if (!this.getConfigPath().toFile().exists() || recreate) {
            this.createConfig();
        }
        return (T)((Record)ConfigUtil.readConfig(this.getConfigPath(), this.getCodec(), JanksonOps.INSTANCE));
    }

    default public void createConfig() {
        T create = this.getInstance();
        if (create == null) {
            create = this.getDefault();
        }
        ConfigUtil.createConfig(this.getConfigPath(), this.getCodec(), this.getMap(this.getComments()), JanksonOps.INSTANCE, create, this.isSorted(), this.getComment(this.getHeader()));
    }

    private String getComment(String header) {
        if (header != null) {
            return "/*\n" + header + "\n*/";
        }
        return null;
    }

    private HashMap<String, String> getMap(HashMap<String, String> comments) {
        if (comments == null) {
            comments = new HashMap();
        }
        return comments;
    }
}

