/*
 * Decompiled with CFR 0.152.
 */
package cristelknight.wwoo.config.cloth;

import cristelknight.wwoo.ExpandedEcosphere;
import cristelknight.wwoo.config.configs.EEConfig;
import cristelknight.wwoo.config.configs.ReplaceBiomesConfig;
import cristelknight.wwoo.terra.TerraInit;
import cristelknight.wwoo.utils.BiomeReplace;
import cristelknight.wwoo.utils.Util;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListListEntry;
import me.shedaniel.clothconfig2.gui.entries.TextListEntry;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import net.cristellib.CristelLib;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ClothConfigScreen {
    public Screen create(Screen parent) {
        EEConfig config = (EEConfig)EEConfig.DEFAULT.getConfig();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setDefaultBackgroundTexture(new ResourceLocation(ClothConfigScreen.getIdentifier(config.backGroundBlock().m_60734_()))).setTitle((Component)Component.m_237115_((String)"expanded_ecosphere.config.title").m_130940_(ChatFormatting.BOLD));
        ConfigEntries entries = new ConfigEntries(builder.entryBuilder(), builder.getOrCreateCategory(ClothConfigScreen.mainName("main")), builder.getOrCreateCategory(ClothConfigScreen.mainName("biomes")), builder.getOrCreateCategory(ClothConfigScreen.mainName("modes")));
        builder.setSavingRunnable(() -> {
            EEConfig.DEFAULT.setInstance(entries.createConfig());
            EEConfig.DEFAULT.getConfig(true, true);
            ReplaceBiomesConfig.DEFAULT.setInstance(entries.createBiomesConfig());
            ReplaceBiomesConfig config2 = (ReplaceBiomesConfig)ReplaceBiomesConfig.DEFAULT.getConfig(true, true);
            if (ExpandedEcosphere.isTerraBlenderLoaded()) {
                TerraInit.terraEnableDisable();
            }
            if (config2.enableBiomes() && ExpandedEcosphere.currentMode.equals((Object)ExpandedEcosphere.Mode.DEFAULT)) {
                BiomeReplace.replace();
            } else {
                CristelLib.DATA_PACK.removeData(new ResourceLocation("minecraft", "dimension/overworld.json"));
            }
        });
        return builder.build();
    }

    private static Component fieldName(String id) {
        return Component.m_237115_((String)("expanded_ecosphere.config.entry." + id));
    }

    private static Component mainName(String id) {
        return Component.m_237115_((String)("expanded_ecosphere.config.category." + id));
    }

    private static Component fieldToolTip(String id) {
        return Component.m_237115_((String)("expanded_ecosphere.config.entry." + id + ".toolTip"));
    }

    private static String getIdentifier(Block b) {
        Stream<String> s = Arrays.stream(BuiltInRegistries.f_256975_.m_7981_((Object)b).toString().split(":"));
        List<String> l = s.toList();
        Object s2 = l.get(1);
        if (b instanceof SnowyDirtBlock || b instanceof DoorBlock || b.equals(Blocks.f_50145_) || b.equals(Blocks.f_50617_)) {
            s2 = (String)s2 + "_top";
        } else if (b.equals(Blocks.f_50077_)) {
            s2 = (String)s2 + "_side";
        } else if (b.equals(Blocks.f_49991_) || b.equals(Blocks.f_49990_)) {
            s2 = (String)s2 + "_still";
        } else if (b instanceof FireBlock) {
            s2 = (String)s2 + "_0";
        }
        return l.get(0) + ":textures/block/" + (String)s2 + ".png";
    }

    private static class ConfigEntries {
        private final ConfigEntryBuilder builder;
        private final BooleanListEntry removeOreBlobs;
        private final BooleanListEntry showUpdates;
        private final BooleanListEntry showBigUpdates;
        private final BooleanListEntry forceLargeBiomes;
        private final BooleanListEntry enableBiomes;
        @NotNull
        private final DropdownBoxEntry<Block> backgroundBlock;
        private final EnumListEntry<ExpandedEcosphere.Mode> mode;
        private final StringListListEntry biomeList;

        public ConfigEntries(ConfigEntryBuilder builder, ConfigCategory category1, ConfigCategory category2, ConfigCategory category3) {
            this.builder = builder;
            EEConfig config = (EEConfig)EEConfig.DEFAULT.getConfig();
            if (!ExpandedEcosphere.isTerraBlenderLoaded()) {
                this.textListEntry((Component)Component.m_237110_((String)"expanded_ecosphere.config.text.requiresTerrablender", (Object[])new Object[]{"3.0.0.169"}), category3);
                this.textListEntry((Component)Component.m_237115_((String)"expanded_ecosphere.config.text.downloadTB").m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://modrinth.com/mod/terrablender"))), category3);
            }
            this.mode = builder.startEnumSelector(ClothConfigScreen.fieldName("selectMode"), ExpandedEcosphere.Mode.class, (Enum)ExpandedEcosphere.currentMode).setDefaultValue((Enum)ExpandedEcosphere.Mode.DEFAULT).build();
            category3.addEntry(this.mode);
            this.textListEntry((Component)Component.m_237115_((String)"expanded_ecosphere.config.text.defaultMode").m_130940_(ChatFormatting.GRAY), category3);
            this.textListEntry((Component)Component.m_237115_((String)"expanded_ecosphere.config.text.compatibleMode").m_130940_(ChatFormatting.GRAY), category3);
            this.enableBiomes = this.createBooleanField("enableBiomes", ((ReplaceBiomesConfig)ReplaceBiomesConfig.DEFAULT.getConfig()).enableBiomes(), ReplaceBiomesConfig.DEFAULT.enableBiomes(), category2, new Component[0]);
            this.biomeList = builder.startStrList(ClothConfigScreen.fieldName("biomeList"), ConfigEntries.convertMapToList(((ReplaceBiomesConfig)ReplaceBiomesConfig.DEFAULT.getConfig()).bannedBiomes())).setTooltip(new Component[]{ClothConfigScreen.fieldToolTip("biomeList")}).setDefaultValue(List.of()).build();
            category2.addEntry((AbstractConfigListEntry)this.biomeList);
            this.textListEntry((Component)Component.m_237115_((String)"expanded_ecosphere.config.text.replaceBiomes").m_130940_(ChatFormatting.GRAY), category2);
            this.textListEntry((Component)Component.m_237110_((String)"expanded_ecosphere.config.text.modes", (Object[])new Object[]{Component.m_237113_((String)ExpandedEcosphere.currentMode.toString()).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GRAY), category1);
            this.backgroundBlock = this.createBlockField("bB", config.backGroundBlock().m_60734_(), EEConfig.DEFAULT.backGroundBlock().m_60734_(), category1, List.of(FT.NO_BLOCK_ENTITY, FT.NO_BUTTON));
            this.showUpdates = this.createBooleanField("showUpdates", config.showUpdates(), EEConfig.DEFAULT.showUpdates(), category1, new Component[0]);
            this.showBigUpdates = this.createBooleanField("showBigUpdates", config.showBigUpdates(), EEConfig.DEFAULT.showBigUpdates(), category1, new Component[0]);
            this.removeOreBlobs = this.createBooleanField("removeOreBlobs", config.removeOreBlobs(), EEConfig.DEFAULT.removeOreBlobs(), category1, new Component[]{ClothConfigScreen.fieldToolTip("removeOreBlobs")});
            this.forceLargeBiomes = this.createBooleanField("forceLargeBiomes", config.forceLargeBiomes(), EEConfig.DEFAULT.forceLargeBiomes(), category1, new Component[0]);
            this.textListEntry((Component)Util.translatableText("forceLargeBiomes").m_130940_(ChatFormatting.GRAY), category1);
        }

        public EEConfig createConfig() {
            ExpandedEcosphere.Mode currentMode;
            ExpandedEcosphere.currentMode = currentMode = (ExpandedEcosphere.Mode)((Object)this.mode.getValue());
            return new EEConfig(currentMode.toString(), this.forceLargeBiomes.getValue(), this.removeOreBlobs.getValue(), this.showUpdates.getValue(), this.showBigUpdates.getValue(), ((Block)this.backgroundBlock.getValue()).m_49966_());
        }

        public ReplaceBiomesConfig createBiomesConfig() {
            return new ReplaceBiomesConfig(this.enableBiomes.getValue(), ConfigEntries.convertListToMap(this.biomeList.getValue()));
        }

        private static List<String> convertMapToList(Map<String, String> stringMap) {
            return stringMap.entrySet().stream().map(entry -> (String)entry.getKey() + "/" + (String)entry.getValue()).collect(Collectors.toList());
        }

        private static Map<String, String> convertListToMap(List<String> stringList) {
            return stringList.stream().map(s -> s.split("/")).filter(parts -> ((String[])parts).length == 2).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1]));
        }

        private BooleanListEntry createBooleanField(String id, boolean value, boolean defaultValue, ConfigCategory category, Component[] tooltip) {
            BooleanListEntry e = this.builder.startBooleanToggle(ClothConfigScreen.fieldName(id), value).setDefaultValue(defaultValue).setTooltip(tooltip).build();
            category.addEntry((AbstractConfigListEntry)e);
            return e;
        }

        @NotNull
        private DropdownBoxEntry<Block> createBlockField(String id, Block value, Block defaultValue, ConfigCategory category, List<FT> filter) {
            DropdownMenuBuilder e = this.builder.startDropdownMenu(ClothConfigScreen.fieldName(id), DropdownMenuBuilder.TopCellElementBuilder.ofBlockObject((Block)value), DropdownMenuBuilder.CellCreatorBuilder.ofBlockObject()).setDefaultValue((Object)defaultValue).setSelections((Iterable)BuiltInRegistries.f_256975_.m_123024_().sorted(Comparator.comparing(Block::toString)).filter(new BlockPredicate(filter)).collect(Collectors.toCollection(LinkedHashSet::new)));
            @NotNull DropdownBoxEntry entry = e.build();
            category.addEntry((AbstractConfigListEntry)entry);
            return entry;
        }

        public void textListEntry(Component component, ConfigCategory category) {
            TextListEntry tle = this.builder.startTextDescription(component).build();
            category.addEntry((AbstractConfigListEntry)tle);
        }

        static class BlockPredicate
        implements Predicate<Block> {
            private final List<FT> filters;

            public BlockPredicate(List<FT> filters) {
                this.filters = filters;
            }

            @Override
            public boolean test(Block block) {
                boolean b = true;
                for (FT filter : this.filters) {
                    if (block instanceof AirBlock) {
                        b = false;
                    }
                    if (filter.equals((Object)FT.NO_BUTTON) && block instanceof ButtonBlock) {
                        b = false;
                    }
                    if (filter.equals((Object)FT.PILLAR) && !(block instanceof RotatedPillarBlock)) {
                        b = false;
                    }
                    if (!filter.equals((Object)FT.NO_BLOCK_ENTITY) || !block.m_49966_().m_155947_()) continue;
                    b = false;
                }
                return b;
            }
        }
    }

    public static enum FT {
        NO_BUTTON,
        PILLAR,
        NO_BLOCK_ENTITY,
        NONE;

    }
}

