/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.util;

import com.example.examplemod.recipe.properties.RecipePropertyLibrary;
import com.example.examplemod.recipe.properties.RecipePropertyState;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class KubeJSExporter {
    private static final char[] MECHANICAL_KEY_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz!#$%&*+-/<=>?@^_|~:".toCharArray();

    public static String generateRecipeScript(String recipeType, String recipeId, ItemStackHandler inputs, ItemStackHandler outputs, int activeInputSlots, int activeOutputSlots, RecipePropertyState propertyState) {
        String lowerType;
        StringBuilder script = new StringBuilder();
        script.append("// Generated by Recipe Editor GUI\n");
        script.append("ServerEvents.recipes(event => {\n");
        script.append("  event.custom({\n");
        script.append("    type: \"").append(recipeType).append("\",\n");
        RecipePropertyState state = propertyState != null ? propertyState : new RecipePropertyState();
        int beforeLength = script.length();
        RecipePropertyLibrary.appendSelectedProperties(script, recipeType, state, inputs, outputs);
        if (script.length() > beforeLength) {
            script.append('\n');
        }
        if ((lowerType = recipeType.toLowerCase()).contains("mechanical_crafting")) {
            KubeJSExporter.generateMechanicalCrafting(script, inputs, outputs, state);
        } else if (lowerType.contains("shaped") || lowerType.contains("crafting_shaped")) {
            KubeJSExporter.generateShapedCrafting(script, inputs, outputs, activeInputSlots, activeOutputSlots, state);
        } else if (lowerType.contains("shapeless") || lowerType.contains("crafting_shapeless")) {
            KubeJSExporter.generateShapelessCrafting(script, recipeType, inputs, outputs, activeInputSlots, activeOutputSlots, state);
        } else if (lowerType.contains("smelting") || lowerType.contains("blasting") || lowerType.contains("smoking") || lowerType.contains("campfire")) {
            KubeJSExporter.generateSmeltingRecipe(script, inputs, outputs, recipeType, state);
        } else if (lowerType.contains("stonecutting")) {
            KubeJSExporter.generateStonecuttingRecipe(script, inputs, outputs, state);
        } else if (lowerType.contains("smithing")) {
            KubeJSExporter.generateSmithingRecipe(script, inputs, outputs, state);
        } else {
            KubeJSExporter.generateGenericRecipe(script, recipeType, inputs, outputs, activeInputSlots, activeOutputSlots, state);
        }
        script.append("  }).id(\"kubejs:").append(recipeId).append("\");\n");
        script.append("});\n");
        return script.toString();
    }

    private static void generateMechanicalCrafting(StringBuilder script, ItemStackHandler inputs, ItemStackHandler outputs, RecipePropertyState state) {
        int gridSize = 9;
        int totalSlots = 81;
        script.append("        pattern: [\n");
        for (int row = 0; row < 9; ++row) {
            script.append("            \"");
            for (int col = 0; col < 9; ++col) {
                int slotIndex = row * 9 + col;
                ItemStack stack = inputs.getStackInSlot(slotIndex);
                if (!stack.m_41619_()) {
                    script.append(KubeJSExporter.getMechanicalKeyChar(slotIndex));
                    continue;
                }
                script.append(' ');
            }
            script.append("\"");
            if (row < 8) {
                script.append(',');
            }
            script.append("\n");
        }
        script.append("        ],\n");
        script.append("        key: {\n");
        for (int i = 0; i < 81; ++i) {
            ItemStack stack = inputs.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            char keyChar = KubeJSExporter.getMechanicalKeyChar(i);
            String itemId = KubeJSExporter.getItemId(stack);
            int count = KubeJSExporter.resolveSlotCount(state, "common.ingredientCount", i, stack.m_41613_());
            script.append("            \"").append(keyChar).append("\": { item: \"").append(itemId).append("\"");
            if (count > 1) {
                script.append(", count: ").append(count);
            }
            script.append(" }");
            boolean hasMore = false;
            for (int j = i + 1; j < 81; ++j) {
                if (inputs.getStackInSlot(j).m_41619_()) continue;
                hasMore = true;
                break;
            }
            if (hasMore) {
                script.append(',');
            }
            script.append("\n");
        }
        script.append("        },\n");
        ItemStack resultStack = outputs.getStackInSlot(0);
        if (!resultStack.m_41619_()) {
            String resultId = KubeJSExporter.getItemId(resultStack);
            int resultCount = KubeJSExporter.resolveSlotCount(state, "common.resultCount", 0, resultStack.m_41613_());
            script.append("        result: {\n");
            script.append("            item: \"").append(resultId).append("\",\n");
            script.append("            count: ").append(resultCount).append("\n");
            script.append("        },\n");
        }
        boolean acceptMirrored = KubeJSExporter.resolveAcceptMirrored(state);
        script.append("        acceptMirrored: ").append(acceptMirrored ? "true" : "false").append('\n');
    }

    private static void generateShapedCrafting(StringBuilder script, ItemStackHandler inputs, ItemStackHandler outputs, int activeInputSlots, int activeOutputSlots, RecipePropertyState state) {
        script.append("        pattern: [\n");
        for (int row = 0; row < 3; ++row) {
            script.append("            \"");
            for (int col = 0; col < 3; ++col) {
                int index = row * 3 + col;
                ItemStack stack = inputs.getStackInSlot(index);
                if (!stack.m_41619_()) {
                    script.append((char)(65 + index));
                    continue;
                }
                script.append(' ');
            }
            script.append("\"");
            if (row < 2) {
                script.append(",");
            }
            script.append("\n");
        }
        script.append("        ],\n");
        script.append("        key: {\n");
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = inputs.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            String itemId = KubeJSExporter.getItemId(stack);
            script.append("            \"").append((char)(65 + i)).append("\": { item: \"").append(itemId).append("\"");
            int count = KubeJSExporter.resolveSlotCount(state, "common.ingredientCount", i, stack.m_41613_());
            if (count > 1) {
                script.append(", count: ").append(count);
            }
            script.append(" }");
            boolean hasMore = false;
            for (int j = i + 1; j < 9; ++j) {
                if (inputs.getStackInSlot(j).m_41619_()) continue;
                hasMore = true;
                break;
            }
            if (hasMore) {
                script.append(",");
            }
            script.append("\n");
        }
        script.append("        },\n");
        if (activeOutputSlots > 0 && !outputs.getStackInSlot(0).m_41619_()) {
            ItemStack result = outputs.getStackInSlot(0);
            String itemId = KubeJSExporter.getItemId(result);
            int count = KubeJSExporter.resolveSlotCount(state, "common.resultCount", 0, result.m_41613_());
            script.append("        result: { item: \"").append(itemId).append("\"");
            if (count > 1) {
                script.append(", count: ").append(count);
            }
            script.append(" }\n");
        }
    }

    private static void generateShapelessCrafting(StringBuilder script, String recipeType, ItemStackHandler inputs, ItemStackHandler outputs, int activeInputSlots, int activeOutputSlots, RecipePropertyState state) {
        script.append("    ingredients: [\n");
        for (int i = 0; i < activeInputSlots; ++i) {
            ItemStack stack = inputs.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            String itemId = KubeJSExporter.getItemId(stack);
            int count = KubeJSExporter.resolveSlotCount(state, "common.ingredientCount", i, stack.m_41613_());
            script.append("      { item: \"").append(itemId).append("\"");
            if (count > 1) {
                script.append(", count: ").append(count);
            }
            script.append(" }");
            boolean hasMore = false;
            for (int j = i + 1; j < activeInputSlots; ++j) {
                if (inputs.getStackInSlot(j).m_41619_()) continue;
                hasMore = true;
                break;
            }
            if (hasMore) {
                script.append(",");
            }
            script.append("\n");
        }
        script.append("    ],\n");
        if (activeOutputSlots > 0 && !outputs.getStackInSlot(0).m_41619_()) {
            ItemStack result = outputs.getStackInSlot(0);
            String itemId = KubeJSExporter.getItemId(result);
            int count = KubeJSExporter.resolveSlotCount(state, "common.resultCount", 0, result.m_41613_());
            boolean isCraftingTableRecipe = recipeType.toLowerCase().contains("crafting");
            if (isCraftingTableRecipe) {
                script.append("    result: { item: \"").append(itemId).append("\"");
                if (count > 1) {
                    script.append(", count: ").append(count);
                }
                script.append(" }\n");
            } else {
                script.append("    results: [\n");
                script.append("      { item: \"").append(itemId).append("\"");
                if (count > 1) {
                    script.append(", count: ").append(count);
                }
                script.append(" }");
                script.append("\n    ]\n");
            }
        }
    }

    private static void generateSmeltingRecipe(StringBuilder script, ItemStackHandler inputs, ItemStackHandler outputs, String recipeType, RecipePropertyState state) {
        if (!inputs.getStackInSlot(0).m_41619_()) {
            String itemId = KubeJSExporter.getItemId(inputs.getStackInSlot(0));
            script.append("        ingredient: { item: '").append(itemId).append("' },\n");
        }
        if (!outputs.getStackInSlot(0).m_41619_()) {
            ItemStack resultStack = outputs.getStackInSlot(0);
            String itemId = KubeJSExporter.getItemId(resultStack);
            int count = KubeJSExporter.resolveSlotCount(state, "common.resultCount", 0, resultStack.m_41613_());
            script.append("        result: '").append(itemId).append("',\n");
            if (count > 1) {
                script.append("        count: ").append(count).append(",\n");
            }
        }
        script.append("        experience: 0.1,\n");
        if (recipeType.contains("blasting")) {
            script.append("        cookingtime: 100\n");
        } else if (recipeType.contains("smoking")) {
            script.append("        cookingtime: 100\n");
        } else if (recipeType.contains("campfire")) {
            script.append("        cookingtime: 600\n");
        } else {
            script.append("        cookingtime: 200\n");
        }
    }

    private static void generateStonecuttingRecipe(StringBuilder script, ItemStackHandler inputs, ItemStackHandler outputs, RecipePropertyState state) {
        if (!inputs.getStackInSlot(0).m_41619_()) {
            String itemId = KubeJSExporter.getItemId(inputs.getStackInSlot(0));
            script.append("        ingredient: { item: '").append(itemId).append("' },\n");
        }
        if (!outputs.getStackInSlot(0).m_41619_()) {
            ItemStack resultStack = outputs.getStackInSlot(0);
            String itemId = KubeJSExporter.getItemId(resultStack);
            int count = KubeJSExporter.resolveSlotCount(state, "common.resultCount", 0, resultStack.m_41613_());
            script.append("        result: '").append(itemId).append("'\n");
            if (count > 1) {
                script.append("        count: ").append(count).append('\n');
            }
        }
    }

    private static void generateSmithingRecipe(StringBuilder script, ItemStackHandler inputs, ItemStackHandler outputs, RecipePropertyState state) {
        String itemId;
        script.append("        base: ");
        if (!inputs.getStackInSlot(1).m_41619_()) {
            itemId = KubeJSExporter.getItemId(inputs.getStackInSlot(1));
            script.append("{ item: '").append(itemId).append("' }");
        } else {
            script.append("{ item: 'minecraft:air' }");
        }
        script.append(",\n");
        script.append("        addition: ");
        if (!inputs.getStackInSlot(2).m_41619_()) {
            itemId = KubeJSExporter.getItemId(inputs.getStackInSlot(2));
            script.append("{ item: '").append(itemId).append("' }");
        } else {
            script.append("{ item: 'minecraft:air' }");
        }
        script.append(",\n");
        script.append("        template: ");
        if (!inputs.getStackInSlot(0).m_41619_()) {
            itemId = KubeJSExporter.getItemId(inputs.getStackInSlot(0));
            script.append("{ item: '").append(itemId).append("' }");
        } else {
            script.append("{ item: 'minecraft:air' }");
        }
        script.append(",\n");
        if (!outputs.getStackInSlot(0).m_41619_()) {
            ItemStack resultStack = outputs.getStackInSlot(0);
            String itemId2 = KubeJSExporter.getItemId(resultStack);
            int count = KubeJSExporter.resolveSlotCount(state, "common.resultCount", 0, resultStack.m_41613_());
            script.append("        result: { item: '").append(itemId2).append("'");
            if (count > 1) {
                script.append(", count: ").append(count);
            }
            script.append(" }\n");
        }
    }

    private static void generateGenericRecipe(StringBuilder script, String recipeType, ItemStackHandler inputs, ItemStackHandler outputs, int activeInputSlots, int activeOutputSlots, RecipePropertyState state) {
        boolean isCutting;
        script.append("    ingredients: [\n");
        for (int i = 0; i < activeInputSlots; ++i) {
            ItemStack stack = inputs.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            String itemId = KubeJSExporter.getItemId(stack);
            int count = KubeJSExporter.resolveSlotCount(state, "common.ingredientCount", i, stack.m_41613_());
            script.append("      { item: \"").append(itemId).append("\"");
            if (count > 1) {
                script.append(", count: ").append(count);
            }
            script.append(" }");
            boolean hasMore = false;
            for (int j = i + 1; j < activeInputSlots; ++j) {
                if (inputs.getStackInSlot(j).m_41619_()) continue;
                hasMore = true;
                break;
            }
            if (hasMore) {
                script.append(",");
            }
            script.append("\n");
        }
        script.append("    ],\n");
        ResourceLocation typeId = ResourceLocation.m_135820_((String)recipeType);
        boolean isFarmersDelight = typeId != null && "farmersdelight".equals(typeId.m_135827_());
        boolean isCooking = isFarmersDelight && "cooking".equals(typeId.m_135815_());
        boolean bl = isCutting = isFarmersDelight && "cutting".equals(typeId.m_135815_());
        if (isCooking) {
            for (int i = 0; i < activeOutputSlots; ++i) {
                ItemStack stack = outputs.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                String itemId = KubeJSExporter.getItemId(stack);
                int count = KubeJSExporter.resolveSlotCount(state, "common.resultCount", i, stack.m_41613_());
                script.append("    result: { item: \"").append(itemId).append("\"");
                if (count > 1) {
                    script.append(", count: ").append(count);
                }
                script.append(" }\n");
                break;
            }
            return;
        }
        String outputField = isCutting ? "result" : "results";
        script.append("    ").append(outputField).append(": [\n");
        for (int i = 0; i < activeOutputSlots; ++i) {
            ItemStack stack = outputs.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            String itemId = KubeJSExporter.getItemId(stack);
            int count = KubeJSExporter.resolveSlotCount(state, "common.resultCount", i, stack.m_41613_());
            script.append("      { item: \"").append(itemId).append("\"");
            if (count > 1) {
                script.append(", count: ").append(count);
            }
            script.append(" }");
            boolean hasMore = false;
            for (int j = i + 1; j < activeOutputSlots; ++j) {
                if (outputs.getStackInSlot(j).m_41619_()) continue;
                hasMore = true;
                break;
            }
            if (hasMore) {
                script.append(",");
            }
            script.append("\n");
        }
        script.append("    ]\n");
    }

    private static String getItemId(ItemStack stack) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        return id.toString();
    }

    private static int resolveSlotCount(RecipePropertyState state, String propertyId, int slotIndex, int fallback) {
        if (state == null) {
            return Math.max(fallback, 1);
        }
        String override = state.getSlotValue(propertyId, slotIndex);
        if (override == null || override.isBlank()) {
            return Math.max(fallback, 1);
        }
        try {
            int parsed = Integer.parseInt(override);
            return parsed > 0 ? parsed : Math.max(fallback, 1);
        }
        catch (NumberFormatException ex) {
            return Math.max(fallback, 1);
        }
    }

    private static char getMechanicalKeyChar(int index) {
        if (index >= 0 && index < MECHANICAL_KEY_CHARS.length) {
            return MECHANICAL_KEY_CHARS[index];
        }
        return (char)(65 + index % 26);
    }

    private static boolean resolveAcceptMirrored(RecipePropertyState state) {
        if (state == null) {
            return false;
        }
        int index = state.getOptionIndex("create.acceptMirrored");
        return index >= 1;
    }

    public static boolean exportToFile(String script, String recipeId) {
        try {
            File gameDir = new File(".");
            File kubeJSDir = new File(gameDir, "kubejs");
            File serverScriptsDir = new File(kubeJSDir, "server_scripts");
            if (!serverScriptsDir.exists()) {
                serverScriptsDir.mkdirs();
            }
            File scriptFile = new File(serverScriptsDir, recipeId + ".js");
            try (FileWriter writer = new FileWriter(scriptFile);){
                writer.write(script);
            }
            System.out.println("Recipe exported to: " + scriptFile.getAbsolutePath());
            return true;
        }
        catch (IOException e) {
            System.err.println("Failed to export recipe: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

