/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.recipe.properties;

import java.util.HashMap;
import java.util.Map;

public class RecipePropertyState {
    private final Map<String, Integer> optionSelections = new HashMap<String, Integer>();
    private final Map<String, String> valueSelections = new HashMap<String, String>();
    private final Map<String, Integer> slotSelections = new HashMap<String, Integer>();
    private final Map<String, Map<Integer, String>> slotValueSelections = new HashMap<String, Map<Integer, String>>();

    public int getOptionIndex(String propertyId) {
        return this.optionSelections.getOrDefault(propertyId, 0);
    }

    public void setOptionIndex(String propertyId, int index) {
        this.optionSelections.put(propertyId, index);
    }

    public void clearOptions() {
        this.optionSelections.clear();
    }

    public boolean hasValue(String propertyId) {
        return this.valueSelections.containsKey(propertyId);
    }

    public String getValue(String propertyId) {
        return this.valueSelections.get(propertyId);
    }

    public void setValue(String propertyId, String value) {
        if (value == null || value.isBlank()) {
            this.valueSelections.remove(propertyId);
        } else {
            this.valueSelections.put(propertyId, value);
        }
    }

    public void clearValues() {
        this.valueSelections.clear();
    }

    public int getSlotIndex(String propertyId) {
        return this.slotSelections.getOrDefault(propertyId, -1);
    }

    public void setSlotIndex(String propertyId, int slotIndex) {
        if (slotIndex < 0) {
            this.slotSelections.remove(propertyId);
        } else {
            this.slotSelections.put(propertyId, slotIndex);
        }
    }

    public String getSlotValue(String propertyId, int slotIndex) {
        Map<Integer, String> perSlot = this.slotValueSelections.get(propertyId);
        if (perSlot == null) {
            return null;
        }
        return perSlot.get(slotIndex);
    }

    public void setSlotValue(String propertyId, int slotIndex, String value) {
        if (slotIndex < 0) {
            return;
        }
        if (value == null || value.isBlank()) {
            Map<Integer, String> perSlot = this.slotValueSelections.get(propertyId);
            if (perSlot != null) {
                perSlot.remove(slotIndex);
                if (perSlot.isEmpty()) {
                    this.slotValueSelections.remove(propertyId);
                }
            }
            return;
        }
        this.slotValueSelections.computeIfAbsent(propertyId, key -> new HashMap()).put(slotIndex, value);
    }

    public void clearSlots() {
        this.slotSelections.clear();
        this.slotValueSelections.clear();
    }

    public void clear() {
        this.clearOptions();
        this.clearValues();
        this.clearSlots();
    }
}

