/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.recipe.properties;

import com.example.examplemod.recipe.properties.RecipePropertyState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public final class RecipePropertyLibrary {
    public static final String INGREDIENT_COUNT_ID = "common.ingredientCount";
    public static final String RESULT_COUNT_ID = "common.resultCount";
    public static final String CREATE_ACCEPT_MIRRORED_ID = "create.acceptMirrored";
    private static final Map<String, Map<String, List<PropertyDefinition>>> PROPERTIES_BY_MOD = new HashMap<String, Map<String, List<PropertyDefinition>>>();
    private static final PropertyDefinition INGREDIENT_COUNT = PropertyDefinition.builder("common.ingredientCount", "Ingredient Count").value("1", "%1$s").numeric(true).valueHint("Count").slot(SlotDomain.INPUT, true).emitter((definition, state, context) -> Optional.empty()).build();
    private static final PropertyDefinition RESULT_COUNT = PropertyDefinition.builder("common.resultCount", "Result Count").value("1", "%1$s").numeric(true).valueHint("Count").slot(SlotDomain.OUTPUT, true).emitter((definition, state, context) -> Optional.empty()).build();
    private static final PropertyDefinition CREATE_HEAT_REQUIREMENT = PropertyDefinition.builder("create.heatRequirement", "Heat Requirement").select("heatRequirement: \"%1$s\",", List.of(PropertyOption.skip("None"), PropertyOption.emit("Heated", "heated"), PropertyOption.emit("Superheated", "superheated"))).build();
    private static final PropertyDefinition CREATE_REQUIRED_FLUID = PropertyDefinition.builder("create.requiredFluid", "Required Fluid").select("requiredFluid: \"%1$s\",", List.of(PropertyOption.skip("None"), PropertyOption.emit("Water", "minecraft:water"), PropertyOption.emit("Lava", "minecraft:lava"))).build();
    private static final PropertyDefinition CREATE_PROCESSING_TIME = PropertyDefinition.builder("create.processingTime", "Processing Time").value("100", "processingTime: %1$s,").numeric(true).valueHint("Ticks").build();
    private static final PropertyDefinition CREATE_ACCEPT_MIRRORED = PropertyDefinition.builder("create.acceptMirrored", "Accept Mirrored").select("%1$s", List.of(PropertyOption.emit("False", "false"), PropertyOption.emit("True", "true"))).emitter((definition, state, context) -> Optional.empty()).build();
    private static final PropertyDefinition COOKING_TIME = PropertyDefinition.builder("farmersdelight.cookingTime", "Cooking Time").value("200", "cookingtime: %1$s,").numeric(true).valueHint("Ticks").build();
    private static final PropertyDefinition COOKING_EXPERIENCE = PropertyDefinition.builder("farmersdelight.experience", "Experience").value("0.35", "experience: %1$s,").numeric(false).valueHint("Value").build();
    private static final PropertyDefinition FARMERS_DELIGHT_TOOL_DAMAGE = PropertyDefinition.builder("farmersdelight.toolDamage", "Tool Damage").value("1", "toolDamage: %1$s,").numeric(true).valueHint("Points").build();
    private static final PropertyDefinition FARMERS_DELIGHT_TOOL_TAG = PropertyDefinition.builder("farmersdelight.toolTag", "Tool Tag").value("forge:tools/knives", "tool: { tag: \"%1$s\" },").numeric(false).valueHint("forge:tools/knives").emitter((definition, state, context) -> {
        String value;
        String string = value = state.hasValue(definition.getId()) ? state.getValue(definition.getId()) : definition.getDefaultValue();
        if (value == null || value.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(String.format("tool: { tag: \"%1$s\" },", value.trim()));
    }).build();
    private static final PropertyDefinition KEEP_HELD_ITEM = PropertyDefinition.builder("common.keepHeldItem", "Keep Held Item").select("keepHeldItem: %1$s,", List.of(PropertyOption.skip("Default"), PropertyOption.emit("True", "true"), PropertyOption.emit("False", "false"))).slot(SlotDomain.INPUT, true).emitter((definition, state, context) -> {
        PropertyOption option;
        List<PropertyOption> options = definition.getOptions();
        if (options.isEmpty()) {
            return Optional.empty();
        }
        int index = state.getOptionIndex(definition.getId());
        if (index < 0 || index >= options.size()) {
            index = 0;
        }
        if (!(option = options.get(index)).shouldEmit()) {
            return Optional.empty();
        }
        int slotIndex = state.getSlotIndex(definition.getId());
        if (slotIndex < 0) {
            return Optional.empty();
        }
        String heldItemId = context.getInputItemId(slotIndex);
        if (heldItemId == null || heldItemId.isBlank()) {
            return Optional.empty();
        }
        StringBuilder snippet = new StringBuilder();
        snippet.append("heldItem: { item: \"").append(heldItemId).append("\" },\n");
        snippet.append("    keepHeldItem: ").append(option.getScriptValue()).append(',');
        return Optional.of(snippet.toString());
    }).build();

    private RecipePropertyLibrary() {
    }

    private static void registerCreate() {
        RecipePropertyLibrary.register("create", "mixing", CREATE_HEAT_REQUIREMENT, CREATE_REQUIRED_FLUID, CREATE_PROCESSING_TIME, INGREDIENT_COUNT, RESULT_COUNT);
        RecipePropertyLibrary.register("create", "pressing", CREATE_PROCESSING_TIME, INGREDIENT_COUNT, RESULT_COUNT);
        RecipePropertyLibrary.register("create", "deploying", KEEP_HELD_ITEM, INGREDIENT_COUNT, RESULT_COUNT);
        RecipePropertyLibrary.register("create", "cutting", INGREDIENT_COUNT, RESULT_COUNT);
        RecipePropertyLibrary.register("create", "mechanical_crafting", CREATE_ACCEPT_MIRRORED, INGREDIENT_COUNT, RESULT_COUNT);
    }

    private static void registerFarmersDelight() {
        RecipePropertyLibrary.register("farmersdelight", "cooking", COOKING_TIME, COOKING_EXPERIENCE, INGREDIENT_COUNT, RESULT_COUNT);
        RecipePropertyLibrary.register("farmersdelight", "cutting", FARMERS_DELIGHT_TOOL_TAG, FARMERS_DELIGHT_TOOL_DAMAGE, KEEP_HELD_ITEM, INGREDIENT_COUNT, RESULT_COUNT);
    }

    private static void register(String modId, String recipePath, PropertyDefinition ... definitions) {
        Map byPath = PROPERTIES_BY_MOD.computeIfAbsent(modId, key -> new HashMap());
        List list = byPath.computeIfAbsent(recipePath, key -> new ArrayList());
        Collections.addAll(list, definitions);
    }

    public static List<PropertyDefinition> getPropertiesFor(String recipeTypeId) {
        List<PropertyDefinition> specific;
        ResourceLocation id;
        if (recipeTypeId == null || recipeTypeId.isBlank()) {
            return List.of();
        }
        try {
            id = new ResourceLocation(recipeTypeId);
        }
        catch (IllegalArgumentException ex) {
            return List.of();
        }
        Map<String, List<PropertyDefinition>> byPath = PROPERTIES_BY_MOD.get(id.m_135827_());
        if (byPath == null) {
            return List.of();
        }
        ArrayList<PropertyDefinition> results = new ArrayList<PropertyDefinition>();
        List<PropertyDefinition> wildcard = byPath.get("*");
        if (wildcard != null) {
            results.addAll(wildcard);
        }
        if ((specific = byPath.get(id.m_135815_())) != null) {
            results.addAll(specific);
        }
        return Collections.unmodifiableList(results);
    }

    public static void appendSelectedProperties(StringBuilder script, String recipeTypeId, RecipePropertyState state, ItemStackHandler inputs, ItemStackHandler outputs) {
        List<PropertyDefinition> definitions = RecipePropertyLibrary.getPropertiesFor(recipeTypeId);
        if (definitions.isEmpty()) {
            return;
        }
        RecipeContext context = new RecipeContext(recipeTypeId, inputs, outputs);
        for (PropertyDefinition definition : definitions) {
            String value;
            Optional<String> snippet = definition.buildSnippet(state, context);
            if (!snippet.isPresent() || (value = snippet.get()).isBlank()) continue;
            script.append("    ").append(value).append('\n');
        }
    }

    private static String itemId(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return "";
        }
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        return id == null ? "" : id.toString();
    }

    static {
        RecipePropertyLibrary.registerCreate();
        RecipePropertyLibrary.registerFarmersDelight();
    }

    public static final class PropertyDefinition {
        private final String id;
        private final String label;
        private final PropertyType type;
        private final List<PropertyOption> options;
        private final String snippetTemplate;
        private final String defaultValue;
        private final SlotDomain slotDomain;
        private final boolean slotRequired;
        private final boolean numericValue;
        private final String valueHint;
        private final SnippetEmitter emitter;

        private PropertyDefinition(String id, String label, PropertyType type, List<PropertyOption> options, String snippetTemplate, String defaultValue, SlotDomain slotDomain, boolean slotRequired, boolean numericValue, String valueHint, SnippetEmitter emitter) {
            this.id = id;
            this.label = label;
            this.type = type;
            this.options = options;
            this.snippetTemplate = snippetTemplate;
            this.defaultValue = defaultValue;
            this.slotDomain = slotDomain;
            this.slotRequired = slotRequired;
            this.numericValue = numericValue;
            this.valueHint = valueHint;
            this.emitter = emitter;
        }

        public static Builder builder(String id, String label) {
            return new Builder(id, label);
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public PropertyType getType() {
            return this.type;
        }

        public List<PropertyOption> getOptions() {
            return this.options;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public SlotDomain getSlotDomain() {
            return this.slotDomain;
        }

        public boolean requiresSlotSelection() {
            return this.slotDomain != SlotDomain.NONE && this.slotRequired;
        }

        public boolean supportsSlotSelection() {
            return this.slotDomain != SlotDomain.NONE;
        }

        public boolean isNumericValue() {
            return this.numericValue;
        }

        public String getValueHint() {
            return this.valueHint;
        }

        private Optional<String> buildSnippet(RecipePropertyState state, RecipeContext context) {
            if (this.emitter != null) {
                return this.emitter.emit(this, state, context);
            }
            if (this.type == PropertyType.SELECT) {
                return this.buildSelectSnippet(state);
            }
            if (this.type == PropertyType.VALUE) {
                return this.buildValueSnippet(state);
            }
            return Optional.empty();
        }

        private Optional<String> buildSelectSnippet(RecipePropertyState state) {
            PropertyOption option;
            if (this.options.isEmpty()) {
                return Optional.empty();
            }
            int index = state.getOptionIndex(this.id);
            if (index < 0 || index >= this.options.size()) {
                index = 0;
            }
            if (!(option = this.options.get(index)).shouldEmit()) {
                return Optional.empty();
            }
            if (this.slotDomain != SlotDomain.NONE) {
                int slotIndex = state.getSlotIndex(this.id);
                if (this.slotRequired && slotIndex < 0) {
                    return Optional.empty();
                }
                return Optional.of(String.format(this.snippetTemplate, option.getScriptValue(), slotIndex));
            }
            return Optional.of(String.format(this.snippetTemplate, option.getScriptValue()));
        }

        private Optional<String> buildValueSnippet(RecipePropertyState state) {
            if (this.slotDomain != SlotDomain.NONE) {
                int slotIndex = state.getSlotIndex(this.id);
                if (this.slotRequired && slotIndex < 0) {
                    return Optional.empty();
                }
                if (slotIndex < 0) {
                    return Optional.empty();
                }
                String value = state.getSlotValue(this.id, slotIndex);
                if (value == null || value.isBlank()) {
                    return Optional.empty();
                }
                return Optional.of(String.format(this.snippetTemplate, value, slotIndex));
            }
            if (!state.hasValue(this.id)) {
                return Optional.empty();
            }
            String value = state.getValue(this.id);
            if (value == null || value.isBlank()) {
                return Optional.empty();
            }
            return Optional.of(String.format(this.snippetTemplate, value));
        }

        public static final class Builder {
            private final String id;
            private final String label;
            private PropertyType type = PropertyType.SELECT;
            private List<PropertyOption> options = List.of();
            private String snippetTemplate = "";
            private String defaultValue = "";
            private SlotDomain slotDomain = SlotDomain.NONE;
            private boolean slotRequired = false;
            private boolean numericValue = true;
            private String valueHint = "";
            private SnippetEmitter emitter;

            private Builder(String id, String label) {
                this.id = id;
                this.label = label;
            }

            public Builder select(String snippetTemplate, List<PropertyOption> options) {
                this.type = PropertyType.SELECT;
                this.snippetTemplate = snippetTemplate;
                this.options = options;
                return this;
            }

            public Builder value(String defaultValue, String snippetTemplate) {
                this.type = PropertyType.VALUE;
                this.defaultValue = defaultValue;
                this.snippetTemplate = snippetTemplate;
                return this;
            }

            public Builder slot(SlotDomain domain, boolean required) {
                this.slotDomain = domain;
                this.slotRequired = required;
                return this;
            }

            public Builder numeric(boolean numeric) {
                this.numericValue = numeric;
                return this;
            }

            public Builder valueHint(String hint) {
                this.valueHint = hint;
                return this;
            }

            public Builder emitter(SnippetEmitter emitter) {
                this.emitter = emitter;
                return this;
            }

            public PropertyDefinition build() {
                return new PropertyDefinition(this.id, this.label, this.type, this.options, this.snippetTemplate, this.defaultValue, this.slotDomain, this.slotRequired, this.numericValue, this.valueHint, this.emitter);
            }
        }
    }

    public static final class RecipeContext {
        private final String recipeTypeId;
        private final ItemStackHandler inputs;
        private final ItemStackHandler outputs;

        private RecipeContext(String recipeTypeId, ItemStackHandler inputs, ItemStackHandler outputs) {
            this.recipeTypeId = recipeTypeId;
            this.inputs = inputs;
            this.outputs = outputs;
        }

        public String getRecipeTypeId() {
            return this.recipeTypeId;
        }

        public String getInputItemId(int slotIndex) {
            if (this.inputs == null || slotIndex < 0 || slotIndex >= this.inputs.getSlots()) {
                return "";
            }
            return RecipePropertyLibrary.itemId(this.inputs.getStackInSlot(slotIndex));
        }

        public String getOutputItemId(int slotIndex) {
            if (this.outputs == null || slotIndex < 0 || slotIndex >= this.outputs.getSlots()) {
                return "";
            }
            return RecipePropertyLibrary.itemId(this.outputs.getStackInSlot(slotIndex));
        }
    }

    public static final class PropertyOption {
        private final String displayName;
        private final String scriptValue;
        private final boolean emit;

        private PropertyOption(String displayName, String scriptValue, boolean emit) {
            this.displayName = displayName;
            this.scriptValue = scriptValue;
            this.emit = emit;
        }

        public static PropertyOption emit(String displayName, String scriptValue) {
            return new PropertyOption(displayName, scriptValue, true);
        }

        public static PropertyOption skip(String displayName) {
            return new PropertyOption(displayName, "", false);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getScriptValue() {
            return this.scriptValue;
        }

        public boolean shouldEmit() {
            return this.emit;
        }
    }

    public static enum SlotDomain {
        NONE,
        INPUT,
        OUTPUT;

    }

    @FunctionalInterface
    public static interface SnippetEmitter {
        public Optional<String> emit(PropertyDefinition var1, RecipePropertyState var2, RecipeContext var3);
    }

    public static enum PropertyType {
        SELECT,
        VALUE;

    }
}

