/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeTypeRegistry {
    private static Map<String, List<RecipeTypeInfo>> recipeTypesByMod = new LinkedHashMap<String, List<RecipeTypeInfo>>();
    private static boolean initialized = false;

    public static void scanRecipeTypes() {
        if (initialized) {
            return;
        }
        recipeTypesByMod.clear();
        HashSet<ResourceLocation> recipeTypes = new HashSet<ResourceLocation>();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91073_.m_7465_() != null) {
            mc.f_91073_.m_7465_().m_44051_().forEach(recipe -> {
                String typeId = recipe.m_6671_().toString();
                recipeTypes.add(new ResourceLocation(typeId));
            });
        }
        ForgeRegistries.RECIPE_TYPES.getKeys().forEach(recipeTypes::add);
        recipeTypes.add(new ResourceLocation("minecraft", "crafting_shaped"));
        recipeTypes.add(new ResourceLocation("minecraft", "crafting_shapeless"));
        for (ResourceLocation typeId : recipeTypes) {
            String modId = typeId.m_135827_();
            String recipePath = typeId.m_135815_();
            RecipeTypeInfo info = new RecipeTypeInfo(typeId, modId, recipePath);
            recipeTypesByMod.computeIfAbsent(modId, k -> new ArrayList()).add(info);
        }
        recipeTypesByMod.values().forEach(list -> list.sort(Comparator.comparing(RecipeTypeInfo::getPath)));
        initialized = true;
    }

    public static Map<String, List<RecipeTypeInfo>> getRecipeTypesByMod() {
        if (!initialized) {
            RecipeTypeRegistry.scanRecipeTypes();
        }
        return Collections.unmodifiableMap(recipeTypesByMod);
    }

    public static List<String> getModNamespaces() {
        if (!initialized) {
            RecipeTypeRegistry.scanRecipeTypes();
        }
        return new ArrayList<String>(recipeTypesByMod.keySet());
    }

    public static List<RecipeTypeInfo> getRecipeTypesForMod(String modId) {
        if (!initialized) {
            RecipeTypeRegistry.scanRecipeTypes();
        }
        return recipeTypesByMod.getOrDefault(modId, Collections.emptyList());
    }

    public static class RecipeTypeInfo {
        private final ResourceLocation id;
        private final String modId;
        private final String path;

        public RecipeTypeInfo(ResourceLocation id, String modId, String path) {
            this.id = id;
            this.modId = modId;
            this.path = path;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public String getModId() {
            return this.modId;
        }

        public String getPath() {
            return this.path;
        }

        public String getFullId() {
            return this.id.toString();
        }

        public String toString() {
            return this.getFullId();
        }
    }
}

