/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.menu;

import com.example.examplemod.registry.ModMenuTypes;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class RecipeEditorMenu
extends AbstractContainerMenu {
    private static final int MAX_INPUT_SLOTS = 81;
    private static final int MAX_OUTPUT_SLOTS = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private final ItemStackHandler inputItems = new ItemStackHandler(81);
    private final ItemStackHandler outputItems = new ItemStackHandler(9);
    private final Slot[] inputSlots = new Slot[81];
    private final Slot[] outputSlots = new Slot[9];
    private final Slot[] playerInventorySlots = new Slot[27];
    private final Slot[] hotbarSlots = new Slot[9];
    private int activeInputSlots = 1;
    private int activeOutputSlots = 1;
    private static final Field SLOT_X_FIELD;
    private static final Field SLOT_Y_FIELD;

    public RecipeEditorMenu(int id, Inventory playerInventory) {
        super((MenuType)ModMenuTypes.RECIPE_EDITOR.get(), id);
        Slot slot;
        SlotItemHandler slot2;
        int slotIndex;
        int i;
        for (i = 0; i < 81; ++i) {
            slotIndex = i;
            slot2 = new SlotItemHandler((IItemHandler)this.inputItems, i, 8, 17){

                public boolean m_5857_(ItemStack stack) {
                    return true;
                }

                public boolean m_6659_() {
                    return slotIndex < RecipeEditorMenu.this.activeInputSlots;
                }
            };
            this.inputSlots[i] = slot2;
            this.m_38897_((Slot)slot2);
        }
        for (i = 0; i < 9; ++i) {
            slotIndex = i;
            slot2 = new SlotItemHandler((IItemHandler)this.outputItems, i, 116, 17){

                public boolean m_5857_(ItemStack stack) {
                    return true;
                }

                public boolean m_6659_() {
                    return slotIndex < RecipeEditorMenu.this.activeOutputSlots;
                }
            };
            this.outputSlots[i] = slot2;
            this.m_38897_((Slot)slot2);
        }
        int playerSlot = 0;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                slot = new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18);
                this.playerInventorySlots[playerSlot++] = slot;
                this.m_38897_(slot);
            }
        }
        int hotbarSlot = 0;
        for (int col = 0; col < 9; ++col) {
            slot = new Slot((Container)playerInventory, col, 8 + col * 18, 142);
            this.hotbarSlots[hotbarSlot++] = slot;
            this.m_38897_(slot);
        }
        this.configureLayout(9, 3, 8, 17, 1, 3, 116, 17, 84, 142);
    }

    public ItemStackHandler getInputItems() {
        return this.inputItems;
    }

    public ItemStackHandler getOutputItems() {
        return this.outputItems;
    }

    public void configureLayout(int inputs, int inputColumns, int inputOffsetX, int inputOffsetY, int outputs, int outputColumns, int outputOffsetX, int outputOffsetY, int playerInventoryOffsetY, int hotbarOffsetY) {
        int row;
        int column;
        Slot slot;
        int i;
        this.activeInputSlots = Math.min(inputs, 81);
        this.activeOutputSlots = Math.min(outputs, 9);
        int resolvedInputColumns = Math.max(1, inputColumns);
        int resolvedOutputColumns = Math.max(1, outputColumns);
        for (i = 0; i < this.inputSlots.length; ++i) {
            slot = this.inputSlots[i];
            column = i % resolvedInputColumns;
            row = i / resolvedInputColumns;
            RecipeEditorMenu.moveSlot(slot, inputOffsetX + column * 18, inputOffsetY + row * 18);
        }
        for (i = 0; i < this.outputSlots.length; ++i) {
            slot = this.outputSlots[i];
            column = i % resolvedOutputColumns;
            row = i / resolvedOutputColumns;
            RecipeEditorMenu.moveSlot(slot, outputOffsetX + column * 18, outputOffsetY + row * 18);
        }
        for (i = 0; i < this.playerInventorySlots.length; ++i) {
            slot = this.playerInventorySlots[i];
            column = i % 9;
            row = i / 9;
            RecipeEditorMenu.moveSlot(slot, 8 + column * 18, playerInventoryOffsetY + row * 18);
        }
        for (i = 0; i < this.hotbarSlots.length; ++i) {
            slot = this.hotbarSlots[i];
            RecipeEditorMenu.moveSlot(slot, 8 + i * 18, hotbarOffsetY);
        }
    }

    private static Field resolveSlotCoordinateField(Slot referenceSlot, int expectedValue) {
        Field[] fields;
        for (Field field : fields = Slot.class.getDeclaredFields()) {
            if (field.getType() != Integer.TYPE || Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                if (field.getInt(referenceSlot) != expectedValue) continue;
                return field;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Unable to resolve slot coordinate field");
    }

    private static void moveSlot(Slot slot, int x, int y) {
        try {
            SLOT_X_FIELD.setInt(slot, x);
            SLOT_Y_FIELD.setInt(slot, y);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to reposition slot", e);
        }
    }

    public int getActiveInputSlots() {
        return this.activeInputSlots;
    }

    public int getActiveOutputSlots() {
        return this.activeOutputSlots;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            int containerSlotEnd = 90;
            if (index < containerSlotEnd ? !this.m_38903_(stack, containerSlotEnd, this.f_38839_.size(), true) : this.activeInputSlots == 0 || !this.m_38903_(stack, 0, this.activeInputSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    static {
        ItemStackHandler referenceHandler = new ItemStackHandler(1);
        SlotItemHandler referenceSlot = new SlotItemHandler((IItemHandler)referenceHandler, 0, 113, 211);
        SLOT_X_FIELD = RecipeEditorMenu.resolveSlotCoordinateField((Slot)referenceSlot, 113);
        SLOT_Y_FIELD = RecipeEditorMenu.resolveSlotCoordinateField((Slot)referenceSlot, 211);
    }
}

