/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.client;

import com.example.examplemod.client.RecipeEditorScreen;
import com.example.examplemod.recipe.properties.RecipePropertyLibrary;
import com.example.examplemod.recipe.properties.RecipePropertyState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class RecipePropertiesScreen
extends Screen {
    private static final int PANEL_WIDTH = 260;
    private static final int PANEL_HEIGHT = 190;
    private static final int ROW_HEIGHT = 28;
    private static final int LABEL_COLUMN_WIDTH = 100;
    private static final int SLOT_BUTTON_WIDTH = 60;
    private static final int OPTION_BUTTON_WIDTH = 80;
    private static final int VALUE_BOX_WIDTH = 80;
    private static final int CONTROL_SPACING = 4;
    private final RecipeEditorScreen parent;
    private final RecipePropertyState propertyState;
    private final String recipeTypeId;
    private final int activeInputSlots;
    private final int activeOutputSlots;
    private final List<RecipePropertyLibrary.PropertyDefinition> properties;
    private final List<RowMetadata> rows = new ArrayList<RowMetadata>();
    private final Map<String, Integer> pendingOptionIndices = new HashMap<String, Integer>();
    private final Map<String, Integer> pendingSlotIndices = new HashMap<String, Integer>();

    public RecipePropertiesScreen(RecipeEditorScreen parent, RecipePropertyState propertyState, String recipeTypeId, int activeInputSlots, int activeOutputSlots) {
        super((Component)Component.m_237113_((String)"Recipe Properties"));
        this.parent = parent;
        this.propertyState = propertyState;
        this.recipeTypeId = recipeTypeId;
        this.activeInputSlots = activeInputSlots;
        this.activeOutputSlots = activeOutputSlots;
        this.properties = RecipePropertyLibrary.getPropertiesFor(recipeTypeId);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.rows.clear();
        this.m_169413_();
        this.pendingOptionIndices.clear();
        this.pendingSlotIndices.clear();
        int panelX0 = (this.f_96543_ - 260) / 2;
        int startX = panelX0 + 12;
        int startY = (this.f_96544_ - 190) / 2 + 38;
        int rowIndex = 0;
        for (RecipePropertyLibrary.PropertyDefinition definition : this.properties) {
            int slotCount = this.getSlotCount(definition.getSlotDomain());
            if (definition.requiresSlotSelection() && slotCount <= 0) continue;
            int rowY = startY + rowIndex * 28;
            RowMetadata row = new RowMetadata(definition, startX, rowY);
            int controlX = startX + 100;
            if (definition.supportsSlotSelection() && slotCount > 0) {
                Button slotButton;
                int selectedSlot = this.propertyState.getSlotIndex(definition.getId());
                if (selectedSlot < 0 || selectedSlot >= slotCount) {
                    selectedSlot = 0;
                }
                this.pendingSlotIndices.put(definition.getId(), selectedSlot);
                row.slotButton = slotButton = Button.m_253074_((Component)Component.m_237113_((String)this.formatSlotLabel(definition.getSlotDomain(), selectedSlot)), button -> this.cycleSlot(definition, row, button)).m_252987_(controlX, rowY - 6, 60, 20).m_253136_();
                this.m_142416_((GuiEventListener)slotButton);
                controlX += 64;
            }
            if (definition.getType() == RecipePropertyLibrary.PropertyType.SELECT) {
                Button optionButton;
                List<RecipePropertyLibrary.PropertyOption> options = definition.getOptions();
                if (options.isEmpty()) continue;
                int currentIndex = this.propertyState.getOptionIndex(definition.getId());
                if (currentIndex < 0 || currentIndex >= options.size()) {
                    currentIndex = 0;
                }
                this.pendingOptionIndices.put(definition.getId(), currentIndex);
                String label = options.get(currentIndex).getDisplayName();
                row.optionButton = optionButton = Button.m_253074_((Component)Component.m_237113_((String)label), button -> this.cycleOption(definition, button)).m_252987_(controlX, rowY - 6, 80, 20).m_253136_();
                this.m_142416_((GuiEventListener)optionButton);
            } else if (definition.getType() == RecipePropertyLibrary.PropertyType.VALUE) {
                String currentValue;
                if (definition.getSlotDomain() == RecipePropertyLibrary.SlotDomain.NONE) {
                    currentValue = this.propertyState.hasValue(definition.getId()) ? this.propertyState.getValue(definition.getId()) : definition.getDefaultValue();
                } else {
                    int selectedSlot = this.pendingSlotIndices.getOrDefault(definition.getId(), 0);
                    String stored = this.propertyState.getSlotValue(definition.getId(), selectedSlot);
                    String string = currentValue = stored != null ? stored : definition.getDefaultValue();
                }
                if (currentValue == null) {
                    currentValue = "";
                }
                EditBox valueBox = new EditBox(this.f_96547_, controlX, rowY - 6, 80, 20, (Component)Component.m_237113_((String)definition.getLabel()));
                valueBox.m_94199_(32);
                valueBox.m_94144_(currentValue);
                if (!definition.getValueHint().isBlank()) {
                    valueBox.m_257771_((Component)Component.m_237113_((String)definition.getValueHint()));
                }
                row.valueBox = valueBox;
                this.m_142416_((GuiEventListener)valueBox);
            }
            this.rows.add(row);
            ++rowIndex;
        }
        int buttonY = startY + Math.max(rowIndex, 1) * 28 + 14;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), button -> this.saveSelections()).m_252987_(startX, buttonY, 80, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.m_7379_()).m_252987_(startX + 160, buttonY, 80, 20).m_253136_());
        if (!this.rows.isEmpty()) {
            RowMetadata firstRow = this.rows.get(0);
            if (firstRow.valueBox != null) {
                this.m_264313_((GuiEventListener)firstRow.valueBox);
            } else if (firstRow.optionButton != null) {
                this.m_264313_((GuiEventListener)firstRow.optionButton);
            }
        }
    }

    private void cycleOption(RecipePropertyLibrary.PropertyDefinition definition, Button button) {
        List<RecipePropertyLibrary.PropertyOption> options = definition.getOptions();
        if (options.isEmpty()) {
            return;
        }
        int currentIndex = this.pendingOptionIndices.getOrDefault(definition.getId(), 0);
        currentIndex = (currentIndex + 1) % options.size();
        this.pendingOptionIndices.put(definition.getId(), currentIndex);
        button.m_93666_((Component)Component.m_237113_((String)options.get(currentIndex).getDisplayName()));
    }

    private void cycleSlot(RecipePropertyLibrary.PropertyDefinition definition, RowMetadata row, Button button) {
        int slotCount = this.getSlotCount(definition.getSlotDomain());
        if (slotCount <= 0) {
            return;
        }
        int currentIndex = this.pendingSlotIndices.getOrDefault(definition.getId(), 0);
        currentIndex = (currentIndex + 1) % slotCount;
        this.pendingSlotIndices.put(definition.getId(), currentIndex);
        button.m_93666_((Component)Component.m_237113_((String)this.formatSlotLabel(definition.getSlotDomain(), currentIndex)));
        if (row.valueBox != null && definition.getSlotDomain() != RecipePropertyLibrary.SlotDomain.NONE) {
            String stored = this.propertyState.getSlotValue(definition.getId(), currentIndex);
            if (stored == null || stored.isBlank()) {
                stored = definition.getDefaultValue();
            }
            row.valueBox.m_94144_(stored == null ? "" : stored);
        }
    }

    private void saveSelections() {
        for (RowMetadata row : this.rows) {
            RecipePropertyLibrary.PropertyDefinition definition = row.definition;
            if (definition.getType() == RecipePropertyLibrary.PropertyType.SELECT && row.optionButton != null) {
                int index = this.pendingOptionIndices.getOrDefault(definition.getId(), 0);
                this.propertyState.setOptionIndex(definition.getId(), index);
                if (!definition.supportsSlotSelection()) continue;
                int slot = this.pendingSlotIndices.getOrDefault(definition.getId(), -1);
                this.propertyState.setSlotIndex(definition.getId(), slot);
                continue;
            }
            if (definition.getType() != RecipePropertyLibrary.PropertyType.VALUE || row.valueBox == null) continue;
            int slot = this.pendingSlotIndices.getOrDefault(definition.getId(), -1);
            String sanitized = this.sanitizeValue(definition, row.valueBox.m_94155_());
            if (definition.getSlotDomain() == RecipePropertyLibrary.SlotDomain.NONE) {
                this.propertyState.setValue(definition.getId(), sanitized);
                row.valueBox.m_94144_(sanitized);
                continue;
            }
            this.propertyState.setSlotIndex(definition.getId(), slot);
            this.propertyState.setSlotValue(definition.getId(), slot, sanitized);
            row.valueBox.m_94144_(sanitized);
        }
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aRecipe properties saved."));
        }
    }

    private String sanitizeValue(RecipePropertyLibrary.PropertyDefinition definition, String value) {
        if (value == null) {
            return "";
        }
        String trimmed = value.trim();
        if (!definition.isNumericValue()) {
            return trimmed;
        }
        return trimmed.replaceAll("[^0-9]", "");
    }

    private int getSlotCount(RecipePropertyLibrary.SlotDomain domain) {
        return switch (domain) {
            case RecipePropertyLibrary.SlotDomain.INPUT -> this.activeInputSlots;
            case RecipePropertyLibrary.SlotDomain.OUTPUT -> this.activeOutputSlots;
            default -> 0;
        };
    }

    private String formatSlotLabel(RecipePropertyLibrary.SlotDomain domain, int slotIndex) {
        return switch (domain) {
            case RecipePropertyLibrary.SlotDomain.INPUT -> "Input " + (slotIndex + 1);
            case RecipePropertyLibrary.SlotDomain.OUTPUT -> "Output " + (slotIndex + 1);
            default -> "Slot";
        };
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_((Screen)this.parent);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        int panelX0 = (this.f_96543_ - 260) / 2;
        int panelY0 = (this.f_96544_ - 190) / 2;
        int panelX1 = panelX0 + 260;
        int panelY1 = panelY0 + 190;
        guiGraphics.m_280509_(panelX0, panelY0, panelX1, panelY1, -1440866786);
        guiGraphics.m_280509_(panelX0, panelY0, panelX1, panelY0 + 1, -11184811);
        guiGraphics.m_280509_(panelX0, panelY1 - 1, panelX1, panelY1, -16777216);
        guiGraphics.m_280509_(panelX0, panelY0, panelX0 + 1, panelY1, -11184811);
        guiGraphics.m_280509_(panelX1 - 1, panelY0, panelX1, panelY1, -16777216);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int titleY = panelY0 + 14;
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, titleY, 0xFFFFFF);
        if (this.rows.isEmpty()) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)"No properties available"), this.f_96543_ / 2, titleY + 24, 0xBBBBBB);
        } else {
            for (RowMetadata row : this.rows) {
                guiGraphics.m_280056_(this.f_96547_, row.definition.getLabel(), row.labelX, row.labelY, 0xFFFFFF, false);
            }
        }
    }

    private static final class RowMetadata {
        final RecipePropertyLibrary.PropertyDefinition definition;
        final int labelX;
        final int labelY;
        Button optionButton;
        EditBox valueBox;
        Button slotButton;

        RowMetadata(RecipePropertyLibrary.PropertyDefinition definition, int labelX, int labelY) {
            this.definition = definition;
            this.labelX = labelX;
            this.labelY = labelY;
        }
    }
}

