/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.client;

import com.example.examplemod.client.RecipePropertiesScreen;
import com.example.examplemod.menu.RecipeEditorMenu;
import com.example.examplemod.recipe.RecipeTypeRegistry;
import com.example.examplemod.recipe.properties.RecipePropertyState;
import com.example.examplemod.util.KubeJSExporter;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RecipeEditorScreen
extends AbstractContainerScreen<RecipeEditorMenu> {
    private static final int SLOT_SIZE = 18;
    private static final int PANEL_BORDER_COLOR = -16777216;
    private static final int PANEL_BACKGROUND_COLOR = -13816531;
    private static final int SLOT_BACKGROUND_COLOR = -12632257;
    private static final int SLOT_HIGHLIGHT_COLOR = -11184811;
    private static final int SLOT_SHADOW_COLOR = -15000805;
    private static final int INPUT_SLOT_COUNT = 81;
    private static final int OUTPUT_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private EditBox recipeIdBox;
    private Button modFilterButton;
    private Button recipeTypeButton;
    private Button exportButton;
    private Button clearButton;
    private Button propertiesButton;
    private String selectedMod = "minecraft";
    private String selectedRecipeType = "minecraft:crafting_shaped";
    private List<String> availableMods;
    private List<RecipeTypeRegistry.RecipeTypeInfo> availableRecipeTypes;
    private int modFilterIndex = 0;
    private int recipeTypeIndex = 0;
    private final RecipePropertyState propertyState = new RecipePropertyState();
    private LayoutConfig currentLayout;

    public RecipeEditorScreen(RecipeEditorMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97729_ = 6;
        RecipeTypeRegistry.scanRecipeTypes();
        this.availableMods = RecipeTypeRegistry.getModNamespaces();
        this.updateAvailableRecipeTypes();
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonX = this.f_97735_ - 90;
        int buttonY = this.f_97736_ + 20;
        this.recipeIdBox = new EditBox(this.f_96547_, buttonX, buttonY, 85, 16, (Component)Component.m_237113_((String)"Recipe ID"));
        this.recipeIdBox.m_94199_(128);
        this.recipeIdBox.m_94144_("my_recipe");
        this.recipeIdBox.m_257771_((Component)Component.m_237113_((String)"Recipe ID..."));
        this.m_142416_((GuiEventListener)this.recipeIdBox);
        this.modFilterButton = Button.m_253074_((Component)Component.m_237113_((String)("Mod: " + this.selectedMod)), button -> this.cycleModFilter()).m_252987_(buttonX, buttonY + 22, 85, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.modFilterButton);
        this.recipeTypeButton = Button.m_253074_((Component)Component.m_237113_((String)this.getShortRecipeTypeName()), button -> this.cycleRecipeType()).m_252987_(buttonX, buttonY + 44, 85, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.recipeTypeButton);
        this.propertiesButton = Button.m_253074_((Component)Component.m_237113_((String)"Properties"), button -> this.openProperties()).m_252987_(buttonX, buttonY + 66, 85, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.propertiesButton);
        this.exportButton = Button.m_253074_((Component)Component.m_237113_((String)"Export"), button -> this.exportRecipe()).m_252987_(buttonX, buttonY + 88, 85, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.exportButton);
        this.clearButton = Button.m_253074_((Component)Component.m_237113_((String)"Clear"), button -> this.clearRecipe()).m_252987_(buttonX, buttonY + 110, 85, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.clearButton);
        this.updateSlotConfiguration();
    }

    private void cycleModFilter() {
        if (this.availableMods.isEmpty()) {
            return;
        }
        this.modFilterIndex = (this.modFilterIndex + 1) % this.availableMods.size();
        this.selectedMod = this.availableMods.get(this.modFilterIndex);
        this.modFilterButton.m_93666_((Component)Component.m_237113_((String)("Mod: " + this.selectedMod)));
        this.updateAvailableRecipeTypes();
        this.recipeTypeIndex = 0;
        if (!this.availableRecipeTypes.isEmpty()) {
            this.selectedRecipeType = this.availableRecipeTypes.get(0).getFullId();
            this.recipeTypeButton.m_93666_((Component)Component.m_237113_((String)this.getShortRecipeTypeName()));
            this.updateSlotConfiguration();
        }
    }

    private void cycleRecipeType() {
        if (this.availableRecipeTypes.isEmpty()) {
            return;
        }
        this.recipeTypeIndex = (this.recipeTypeIndex + 1) % this.availableRecipeTypes.size();
        this.selectedRecipeType = this.availableRecipeTypes.get(this.recipeTypeIndex).getFullId();
        this.recipeTypeButton.m_93666_((Component)Component.m_237113_((String)this.getShortRecipeTypeName()));
        this.updateSlotConfiguration();
    }

    private String getShortRecipeTypeName() {
        if (this.availableRecipeTypes.isEmpty()) {
            return "No types";
        }
        String fullType = this.selectedRecipeType;
        String[] parts = fullType.split(":");
        return parts.length > 1 ? parts[1] : fullType;
    }

    private void updateAvailableRecipeTypes() {
        this.availableRecipeTypes = RecipeTypeRegistry.getRecipeTypesForMod(this.selectedMod);
        if (!this.availableRecipeTypes.isEmpty()) {
            this.selectedRecipeType = this.availableRecipeTypes.get(0).getFullId();
        }
    }

    private void updateSlotConfiguration() {
        String recipeType = this.selectedRecipeType.toLowerCase();
        LayoutConfig layout = recipeType.contains("mechanical_crafting") ? LayoutConfig.mechanical() : (recipeType.contains("crafting_shaped") || recipeType.contains("crafting_shapeless") || recipeType.equals("minecraft:crafting") || recipeType.endsWith(":crafting") ? LayoutConfig.standardCrafting() : (recipeType.contains("shaped") || recipeType.contains("shapeless") ? LayoutConfig.standardCrafting() : (recipeType.contains("smelting") || recipeType.contains("blasting") || recipeType.contains("smoking") || recipeType.contains("campfire") ? LayoutConfig.singleInputCooker() : (recipeType.contains("stonecutting") ? LayoutConfig.singleInputCooker() : (recipeType.contains("smithing") ? LayoutConfig.smithing() : LayoutConfig.genericProcessing())))));
        this.applyLayout(layout);
    }

    private void applyLayout(LayoutConfig layout) {
        this.currentLayout = layout;
        this.f_97726_ = layout.imageWidth;
        this.f_97727_ = layout.imageHeight;
        this.f_97731_ = layout.inventoryLabelY;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        ((RecipeEditorMenu)this.f_97732_).configureLayout(layout.activeInputSlots, layout.inputColumns, layout.inputOffsetX, layout.inputOffsetY, layout.activeOutputSlots, layout.outputColumns, layout.outputOffsetX, layout.outputOffsetY, layout.playerInventoryY, layout.hotbarY);
        this.updateLayout();
    }

    private void exportRecipe() {
        String script;
        boolean success;
        String recipeId = this.recipeIdBox.m_94155_();
        if (recipeId.isEmpty()) {
            recipeId = "my_recipe";
        }
        if ((success = KubeJSExporter.exportToFile(script = KubeJSExporter.generateRecipeScript(this.selectedRecipeType, recipeId, ((RecipeEditorMenu)this.f_97732_).getInputItems(), ((RecipeEditorMenu)this.f_97732_).getOutputItems(), ((RecipeEditorMenu)this.f_97732_).getActiveInputSlots(), ((RecipeEditorMenu)this.f_97732_).getActiveOutputSlots(), this.propertyState), recipeId)) && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7aRecipe exported to kubejs/server_scripts/" + recipeId + ".js")));
        } else if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7cFailed to export recipe. Check console for details."));
        }
    }

    private void clearRecipe() {
        int i;
        for (i = 0; i < ((RecipeEditorMenu)this.f_97732_).getActiveInputSlots(); ++i) {
            ((RecipeEditorMenu)this.f_97732_).getInputItems().setStackInSlot(i, ItemStack.f_41583_);
        }
        for (i = 0; i < ((RecipeEditorMenu)this.f_97732_).getActiveOutputSlots(); ++i) {
            ((RecipeEditorMenu)this.f_97732_).getOutputItems().setStackInSlot(i, ItemStack.f_41583_);
        }
        this.propertyState.clear();
    }

    private void updateLayout() {
        int margin = 6;
        int controlWidth = 85;
        int rowGap = 22;
        int leftSideX = this.f_97735_ - 91;
        int rightSideX = this.f_97735_ + this.f_97726_ + 6;
        int buttonX = leftSideX >= 6 ? leftSideX : rightSideX;
        buttonX = Math.max(6, Math.min(buttonX, this.f_96543_ - 85 - 6));
        int buttonY = this.f_97736_ + 20;
        this.recipeIdBox.m_252865_(buttonX);
        this.recipeIdBox.m_253211_(buttonY);
        this.modFilterButton.m_264152_(buttonX, buttonY + 22);
        this.recipeTypeButton.m_264152_(buttonX, buttonY + 44);
        this.propertiesButton.m_264152_(buttonX, buttonY + 66);
        this.exportButton.m_264152_(buttonX, buttonY + 88);
        this.clearButton.m_264152_(buttonX, buttonY + 110);
    }

    private void openProperties() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new RecipePropertiesScreen(this, this.propertyState, this.selectedRecipeType, ((RecipeEditorMenu)this.f_97732_).getActiveInputSlots(), ((RecipeEditorMenu)this.f_97732_).getActiveOutputSlots()));
        }
    }

    public void m_6574_(Minecraft mc, int w, int h) {
        super.m_6574_(mc, w, h);
        if (this.recipeIdBox != null) {
            this.updateLayout();
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int x = this.f_97735_;
        int y = this.f_97736_;
        guiGraphics.m_280509_(x - 4, y - 4, x + this.f_97726_ + 4, y + this.f_97727_ + 4, -16777216);
        guiGraphics.m_280509_(x - 3, y - 3, x + this.f_97726_ + 3, y + this.f_97727_ + 3, -13816531);
        int recipeBottom = this.currentLayout != null ? this.currentLayout.recipePanelBottom : 78;
        guiGraphics.m_280509_(x + 3, y + 3, x + this.f_97726_ - 3, y + recipeBottom, -16777216);
        guiGraphics.m_280509_(x + 4, y + 4, x + this.f_97726_ - 4, y + recipeBottom - 1, -13816531);
        int inventoryTop = this.currentLayout != null ? this.currentLayout.inventoryPanelTop : 79;
        guiGraphics.m_280509_(x + 3, y + inventoryTop, x + this.f_97726_ - 3, y + this.f_97727_ - 3, -16777216);
        guiGraphics.m_280509_(x + 4, y + inventoryTop + 1, x + this.f_97726_ - 4, y + this.f_97727_ - 4, -13816531);
        this.drawSlotGroup(guiGraphics, 0, ((RecipeEditorMenu)this.f_97732_).getActiveInputSlots());
        this.drawSlotGroup(guiGraphics, 81, ((RecipeEditorMenu)this.f_97732_).getActiveOutputSlots());
        this.drawSlotGroup(guiGraphics, 90, 27);
        this.drawSlotGroup(guiGraphics, 117, 9);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.recipeIdBox.m_93696_() && this.recipeIdBox.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.recipeIdBox.m_93696_() && this.recipeIdBox.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    private void drawSlotGroup(GuiGraphics guiGraphics, int startIndex, int slotCount) {
        int maxIndex = Math.min(startIndex + slotCount, ((RecipeEditorMenu)this.f_97732_).f_38839_.size());
        for (int slotIndex = startIndex; slotIndex < maxIndex; ++slotIndex) {
            Slot slot = (Slot)((RecipeEditorMenu)this.f_97732_).f_38839_.get(slotIndex);
            int slotX = this.f_97735_ + slot.f_40220_ - 1;
            int slotY = this.f_97736_ + slot.f_40221_ - 1;
            this.drawSlot(guiGraphics, slotX, slotY);
        }
    }

    private void drawSlot(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280509_(x, y, x + 18, y + 18, -16777216);
        guiGraphics.m_280509_(x + 1, y + 1, x + 18 - 1, y + 18 - 1, -12632257);
        guiGraphics.m_280509_(x + 1, y + 1, x + 18 - 1, y + 2, -11184811);
        guiGraphics.m_280509_(x + 1, y + 1, x + 2, y + 18 - 1, -11184811);
        guiGraphics.m_280509_(x + 1, y + 18 - 2, x + 18 - 1, y + 18 - 1, -15000805);
        guiGraphics.m_280509_(x + 18 - 2, y + 1, x + 18 - 1, y + 18 - 1, -15000805);
    }

    private static LayoutConfig createLayout(int inputs, int inputColumns, int inputOffsetX, int inputOffsetY, int outputs, int outputColumns, int outputOffsetX, int outputOffsetY, int playerInventoryY, int hotbarY, int imageWidth, int imageHeight) {
        return new LayoutConfig(inputs, inputColumns, inputOffsetX, inputOffsetY, outputs, outputColumns, outputOffsetX, outputOffsetY, playerInventoryY, hotbarY, imageWidth, imageHeight);
    }

    private static final class LayoutConfig {
        final int activeInputSlots;
        final int inputColumns;
        final int inputOffsetX;
        final int inputOffsetY;
        final int activeOutputSlots;
        final int outputColumns;
        final int outputOffsetX;
        final int outputOffsetY;
        final int playerInventoryY;
        final int hotbarY;
        final int imageWidth;
        final int imageHeight;
        final int recipePanelBottom;
        final int inventoryPanelTop;
        final int inventoryLabelY;

        private LayoutConfig(int activeInputSlots, int inputColumns, int inputOffsetX, int inputOffsetY, int activeOutputSlots, int outputColumns, int outputOffsetX, int outputOffsetY, int playerInventoryY, int hotbarY, int imageWidth, int imageHeight) {
            this.activeInputSlots = activeInputSlots;
            this.inputColumns = Math.max(1, inputColumns);
            this.inputOffsetX = inputOffsetX;
            this.inputOffsetY = inputOffsetY;
            this.activeOutputSlots = activeOutputSlots;
            this.outputColumns = Math.max(1, outputColumns);
            this.outputOffsetX = outputOffsetX;
            this.outputOffsetY = outputOffsetY;
            this.playerInventoryY = playerInventoryY;
            this.hotbarY = hotbarY;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            int rows = activeInputSlots <= 0 ? 1 : (int)Math.ceil((double)activeInputSlots / (double)this.inputColumns);
            int slotBottom = inputOffsetY + rows * 18;
            int inferredRecipeBottom = playerInventoryY - 6;
            this.recipePanelBottom = Math.max(slotBottom + 6, inferredRecipeBottom);
            this.inventoryPanelTop = playerInventoryY - 5;
            this.inventoryLabelY = playerInventoryY - 12;
        }

        static LayoutConfig standardCrafting() {
            return RecipeEditorScreen.createLayout(9, 3, 8, 17, 1, 3, 116, 17, 84, 142, 176, 166);
        }

        static LayoutConfig genericProcessing() {
            return RecipeEditorScreen.createLayout(9, 3, 8, 17, 9, 3, 116, 17, 84, 142, 176, 166);
        }

        static LayoutConfig singleInputCooker() {
            return RecipeEditorScreen.createLayout(1, 1, 44, 35, 1, 1, 116, 35, 84, 142, 176, 166);
        }

        static LayoutConfig smithing() {
            return RecipeEditorScreen.createLayout(3, 3, 26, 35, 1, 1, 134, 53, 84, 142, 176, 166);
        }

        static LayoutConfig mechanical() {
            int inputOffsetX = 8;
            int inputOffsetY = 17;
            int inputColumns = 9;
            int activeInputs = 81;
            int inputRows = 9;
            int outputOffsetX = inputOffsetX + inputColumns * 18 + 24;
            int outputOffsetY = inputOffsetY + inputRows * 18 / 2 - 9;
            int playerInventoryY = inputOffsetY + inputRows * 18 + 36;
            int hotbarY = playerInventoryY + 58;
            int imageWidth = outputOffsetX + 18 + 8;
            int imageHeight = hotbarY + 24;
            return RecipeEditorScreen.createLayout(activeInputs, inputColumns, inputOffsetX, inputOffsetY, 1, 1, outputOffsetX, outputOffsetY, playerInventoryY, hotbarY, imageWidth, imageHeight);
        }
    }
}

