/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client;

import dev.latvian.mods.kubejs.util.UtilsJS;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.builders.misc.CustomEntityBuilder;
import net.liopyu.entityjs.builders.misc.CustomEntityJSBuilder;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ArrowEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ProjectileEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.vanilla.BoatEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.vanilla.EyeOfEnderEntityBuilder;
import net.liopyu.entityjs.client.living.CustomKubeJSEntityRenderer;
import net.liopyu.entityjs.client.living.KubeJSEntityRenderer;
import net.liopyu.entityjs.client.nonliving.KubeJSArrowEntityRenderer;
import net.liopyu.entityjs.client.nonliving.KubeJSBoatRenderer;
import net.liopyu.entityjs.client.nonliving.KubeJSEnderEyeRenderer;
import net.liopyu.entityjs.client.nonliving.KubeJSNLEntityRenderer;
import net.liopyu.entityjs.client.nonliving.KubeJSProjectileEntityRenderer;
import net.liopyu.entityjs.util.ModKeybinds;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientEventHandlers {
    public static void init() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ClientEventHandlers::registerEntityRenders);
    }

    private static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        for (BaseLivingEntityBuilder<?> baseLivingEntityBuilder : BaseLivingEntityBuilder.thisList) {
            event.registerEntityRenderer((EntityType)UtilsJS.cast((Object)baseLivingEntityBuilder.get()), renderManager -> new KubeJSEntityRenderer(renderManager, builder));
        }
        for (ArrowEntityBuilder arrowEntityBuilder : ArrowEntityBuilder.thisList) {
            event.registerEntityRenderer((EntityType)UtilsJS.cast((Object)arrowEntityBuilder.get()), renderManager -> new KubeJSArrowEntityRenderer(renderManager, arrowEntityBuilder));
        }
        for (ProjectileEntityBuilder projectileEntityBuilder : ProjectileEntityBuilder.thisList) {
            event.registerEntityRenderer((EntityType)UtilsJS.cast((Object)projectileEntityBuilder.get()), renderManager -> new KubeJSProjectileEntityRenderer(renderManager, projectileEntityBuilder));
        }
        for (EyeOfEnderEntityBuilder eyeOfEnderEntityBuilder : EyeOfEnderEntityBuilder.thisList) {
            event.registerEntityRenderer((EntityType)UtilsJS.cast((Object)eyeOfEnderEntityBuilder.get()), renderManager -> new KubeJSEnderEyeRenderer(renderManager, eyeOfEnderEntityBuilder));
        }
        for (BaseEntityBuilder baseEntityBuilder : BaseEntityBuilder.thisList) {
            event.registerEntityRenderer((EntityType)UtilsJS.cast((Object)baseEntityBuilder.get()), renderManager -> new KubeJSNLEntityRenderer(renderManager, baseEntityBuilder));
        }
        for (BoatEntityBuilder boatEntityBuilder : BoatEntityBuilder.thisList) {
            event.registerEntityRenderer((EntityType)UtilsJS.cast((Object)boatEntityBuilder.get()), renderManager -> new KubeJSBoatRenderer(renderManager, boatEntityBuilder));
        }
        for (CustomEntityJSBuilder customEntityJSBuilder : CustomEntityBuilder.thisList) {
            event.registerEntityRenderer((EntityType)UtilsJS.cast((Object)customEntityJSBuilder.get()), renderManager -> new CustomKubeJSEntityRenderer(renderManager, customEntityJSBuilder));
        }
    }

    @Mod.EventBusSubscriber(modid="entityjs", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(ModKeybinds.mount_jump);
        }
    }
}

