/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.builders.modification;

import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Consumer;
import java.util.function.Function;
import net.liopyu.entityjs.builders.modification.ModifyEntityBuilder;
import net.liopyu.entityjs.util.ContextUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class ModifyProjectileBuilder
extends ModifyEntityBuilder {
    public transient Consumer<ContextUtils.ProjectileEntityHitContext> onHitEntity;
    public transient Consumer<ContextUtils.ProjectileBlockHitContext> onHitBlock;
    public transient Function<Entity, Object> canHitEntity;
    public transient Consumer<Entity> defineSyncedData;

    public ModifyProjectileBuilder(EntityType<?> entityType) {
        super(entityType);
    }

    public ModifyEntityBuilder defineSyncedData(Consumer<Entity> consumer) {
        this.defineSyncedData = consumer;
        return this;
    }

    @Info(value="Sets a callback function to be executed when the projectile hits an entity.\nThe provided Consumer accepts a {@link ContextUtils.ProjectileEntityHitContext} parameter,\nrepresenting the context of the projectile's interaction with a specific entity.\n\nExample usage:\n```javascript\nprojectileBuilder.onHitEntity(context -> {\n    // Custom logic to handle the projectile hitting an entity.\n    // Access information about the entity and projectile using the provided context.\n});\n```\n")
    public ModifyProjectileBuilder onHitEntity(Consumer<ContextUtils.ProjectileEntityHitContext> consumer) {
        this.onHitEntity = consumer;
        return this;
    }

    @Info(value="Sets a callback function to be executed when the projectile hits a block.\nThe provided Consumer accepts a {@link ContextUtils.ProjectileBlockHitContext} parameter,\nrepresenting the context of the projectile's interaction with a specific block.\n\nExample usage:\n```javascript\nprojectileBuilder.onHitBlock(context -> {\n    // Custom logic to handle the projectile hitting a block.\n    // Access information about the block and projectile using the provided context.\n});\n```\n")
    public ModifyProjectileBuilder onHitBlock(Consumer<ContextUtils.ProjectileBlockHitContext> consumer) {
        this.onHitBlock = consumer;
        return this;
    }

    @Info(value="Sets a function to determine if the projectile entity can hit a specific entity.\n\n@param canHitEntity The predicate to check if the arrow can hit the entity.\n\nExample usage:\n```javascript\nprojectileEntityBuilder.canHitEntity(entity -> {\n    // Custom logic to determine if the projectile can hit the specified entity\n    // Return true if the arrow can hit, false otherwise.\n});\n```\n")
    public ModifyProjectileBuilder canHitEntity(Function<Entity, Object> function) {
        this.canHitEntity = function;
        return this;
    }
}

