/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.simple;

import java.util.List;
import org.apache.commons.lang3.function.TriFunction;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.methods.MethodRegistry;

public class TriFunctionMethods
extends MathMethod {
    protected TriFunctionMethods(List<String> args, boolean isNegative, EMFAnimation calculationInstance, TriFunction<Float, Float, Float, Float> function) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        MathComponent arg = TriFunctionMethods.parseArg(args.get(0), calculationInstance);
        MathComponent arg2 = TriFunctionMethods.parseArg(args.get(1), calculationInstance);
        MathComponent arg3 = TriFunctionMethods.parseArg(args.get(2), calculationInstance);
        this.setSupplierAndOptimize(() -> ((Float)function.apply((Object)Float.valueOf(arg.getResult()), (Object)Float.valueOf(arg2.getResult()), (Object)Float.valueOf(arg3.getResult()))).floatValue(), List.of(arg, arg2, arg3));
    }

    public static MethodRegistry.MethodFactory makeFactory(String methodName, TriFunction<Float, Float, Float, Float> function) {
        return (args, isNegative, calculationInstance) -> {
            try {
                return new TriFunctionMethods(args, isNegative, calculationInstance, function);
            }
            catch (Exception e) {
                throw new EMFMathException("Failed to create " + methodName + "() method, because: " + e);
            }
        };
    }

    public static float easeInQuad(float t, float start, float end) {
        float delta = end - start;
        return start + delta * t * t;
    }

    public static float easeOutQuad(float t, float start, float end) {
        float delta = end - start;
        return start + delta * -t * (t - 2.0f);
    }

    public static float easeInOutQuad(float t, float start, float end) {
        float delta = end - start;
        if ((double)(t /= 1.0f) < 0.5) {
            return start + delta * (2.0f * t * t);
        }
        return start + delta * (-2.0f * t * (t - 2.0f) - 1.0f);
    }

    public static float easeInCubic(float t, float start, float end) {
        float delta = end - start;
        return start + delta * t * t * t;
    }

    public static float easeOutCubic(float t, float start, float end) {
        float delta = end - start;
        return start + delta * (t -= 1.0f) * t * t + 1.0f;
    }

    public static float easeInOutCubic(float t, float start, float end) {
        float delta = end - start;
        if ((double)(t /= 1.0f) < 0.5) {
            return start + delta * 4.0f * t * t * t;
        }
        return start + delta * (t -= 1.0f) * (2.0f * t * t + 2.0f) + 1.0f;
    }

    public static float easeInQuart(float t, float start, float end) {
        float delta = end - start;
        return start + delta * t * t * t * t;
    }

    public static float easeOutQuart(float t, float start, float end) {
        float delta = end - start;
        return start + delta * (t -= 1.0f) * t * t * t + 1.0f;
    }

    public static float easeInOutQuart(float t, float start, float end) {
        float delta = end - start;
        if ((double)(t /= 1.0f) < 0.5) {
            return start + delta * 8.0f * t * t * t * t;
        }
        return start + delta * (t -= 1.0f) * (8.0f * t * t * t + 1.0f) + 1.0f;
    }

    public static float easeInQuint(float t, float start, float end) {
        float delta = end - start;
        return start + delta * t * t * t * t * t;
    }

    public static float easeOutQuint(float t, float start, float end) {
        float delta = end - start;
        return start + delta * (t -= 1.0f) * t * t * t * t + 1.0f;
    }

    public static float easeInOutQuint(float t, float start, float end) {
        float delta = end - start;
        if ((double)(t /= 1.0f) < 0.5) {
            return start + delta * 16.0f * t * t * t * t * t;
        }
        return start + delta * (t -= 1.0f) * (16.0f * t * t * t * t + 1.0f) + 1.0f;
    }

    public static float easeInSine(float t, float start, float end) {
        float delta = end - start;
        return start + delta * (1.0f - (float)Math.cos((double)t * Math.PI / 2.0));
    }

    public static float easeOutSine(float t, float start, float end) {
        float delta = end - start;
        return start + delta * (float)Math.sin((double)t * Math.PI / 2.0);
    }

    public static float easeInOutSine(float t, float start, float end) {
        float delta = end - start;
        return start + delta * (float)(-0.5 * (Math.cos(Math.PI * (double)t) - 1.0));
    }

    public static float easeInExpo(float t, float start, float end) {
        float delta = end - start;
        return start + delta * (float)Math.pow(2.0, 10.0f * (t - 1.0f));
    }

    public static float easeOutExpo(float t, float start, float end) {
        float delta = end - start;
        return start + delta * (float)(-Math.pow(2.0, -10.0f * t) + 1.0);
    }

    public static float easeInOutExpo(float t, float start, float end) {
        float delta = end - start;
        if ((t /= 1.0f) < 1.0f) {
            return start + delta * (float)(0.5 * Math.pow(2.0, 10.0f * (t - 1.0f)));
        }
        return start + delta * (float)(0.5 * (-Math.pow(2.0, -10.0f * (t -= 1.0f)) + 2.0));
    }

    public static float easeInCirc(float t, float start, float end) {
        float delta = end - start;
        return start + delta * (float)(-(Math.sqrt(1.0f - t * t) - 1.0));
    }

    public static float easeOutCirc(float t, float start, float end) {
        float delta = end - start;
        float tMinus1 = t - 1.0f;
        return start + delta * (float)Math.sqrt(1.0f - tMinus1 * tMinus1);
    }

    public static float easeInOutCirc(float t, float start, float end) {
        float delta = end - start;
        float tTimes2 = t * 2.0f;
        if (tTimes2 < 1.0f) {
            return start + delta * (float)(-0.5 * (Math.sqrt(1.0f - tTimes2 * tTimes2) - 1.0));
        }
        float tTimes2Minus2 = tTimes2 - 2.0f;
        return start + delta * (float)(0.5 * (Math.sqrt(1.0f - tTimes2Minus2 * tTimes2Minus2) + 1.0));
    }

    public static float easeInElastic(float t, float start, float end) {
        float delta = end - start;
        return start + delta * (float)(-Math.pow(2.0, 10.0f * (t -= 1.0f)) * Math.sin(((double)t - 0.075) * (Math.PI * 2) / 0.3));
    }

    public static float easeOutElastic(float t, float start, float end) {
        float delta = end - start;
        return start + delta * (float)(Math.pow(2.0, -10.0f * t) * Math.sin(((double)t - 0.075) * (Math.PI * 2) / 0.3) + 1.0);
    }

    public static float easeInOutElastic(float t, float start, float end) {
        float delta = end - start;
        if ((double)(t /= 1.0f) < 0.5) {
            return start + delta * (float)(-0.5 * Math.pow(2.0, 10.0f * (t -= 1.0f)) * Math.sin(((double)t - 0.05625) * (Math.PI * 2) / 0.45));
        }
        return start + delta * (float)(0.5 * Math.pow(2.0, -10.0f * (t -= 1.0f)) * Math.sin(((double)t - 0.05625) * (Math.PI * 2) / 0.45) + 1.0);
    }

    public static float easeInBounce(float t, float start, float end) {
        float delta = end - start;
        return start + delta * (1.0f - TriFunctionMethods.easeOutBounce(1.0f - t, 0.0f, 1.0f));
    }

    public static float easeOutBounce(float t, float start, float end) {
        float delta = end - start;
        if ((double)(t /= 1.0f) < 0.36363636363636365) {
            return start + delta * (7.5625f * t * t);
        }
        if ((double)t < 0.7272727272727273) {
            return (float)((double)start + (double)delta * ((double)(7.5625f * (t -= 0.54545456f) * t) + 0.75));
        }
        if ((double)t < 0.9090909090909091) {
            return (float)((double)start + (double)delta * ((double)(7.5625f * (t -= 0.8181818f) * t) + 0.9375));
        }
        return (float)((double)start + (double)delta * ((double)(7.5625f * (t -= 0.95454544f) * t) + 0.984375));
    }

    public static float easeInOutBounce(float t, float start, float end) {
        float delta = end - start;
        if ((double)t < 0.5) {
            return start + delta * (0.5f * TriFunctionMethods.easeInBounce(t * 2.0f, 0.0f, 1.0f));
        }
        return start + delta * (0.5f * TriFunctionMethods.easeOutBounce(t * 2.0f - 1.0f, 0.0f, 1.0f) + 0.5f);
    }

    public static float easeInBack(float t, float start, float end) {
        float delta = end - start;
        return start + delta * (t * t * (2.70158f * t - 1.70158f));
    }

    public static float easeOutBack(float t, float start, float end) {
        float delta = end - start;
        return start + delta * ((t -= 1.0f) * t * (2.70158f * t + 1.70158f) + 1.0f);
    }

    public static float easeInOutBack(float t, float start, float end) {
        float delta = end - start;
        if ((double)(t /= 1.0f) < 0.5) {
            return start + delta * (t * t * (7.0f * t - 2.5f) * 2.0f);
        }
        return start + delta * (((t -= 1.0f) * t * (7.0f * t + 2.5f) + 2.0f) * 2.0f);
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount == 3;
    }
}

