/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.util;

import com.google.common.base.Suppliers;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.util.ConditionalStack;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;

public class WidgetRowBuilder {
    private final int maxWidth;
    private final List<ClientBuiltPool> poolList = new ArrayList<ClientBuiltPool>();
    private final Supplier<List<ConditionalStack>> stacks = Suppliers.memoize(() -> {
        ArrayList list = new ArrayList();
        for (ClientBuiltPool pool : this.poolList) {
            list.addAll(pool.stacks().stream().map(stack -> stack.getRawStacks().stream().sorted(Comparator.comparingInt(s -> BuiltInRegistries.f_257033_.m_7447_((Object)s.m_41720_()))).map(s -> new ConditionalStack(stack.conditions(), stack.weight(), List.of(s))).toList()).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll));
        }
        return list;
    });
    private int width = 0;

    public WidgetRowBuilder(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public List<ClientBuiltPool> getPoolList() {
        return this.poolList;
    }

    public int ingredientCount() {
        int count = 0;
        for (ClientBuiltPool pool : this.poolList) {
            count += pool.stacks().size();
        }
        return count;
    }

    public List<ConditionalStack> ingredients() {
        ArrayList<ConditionalStack> list = new ArrayList<ConditionalStack>();
        for (ClientBuiltPool pool : this.poolList) {
            list.addAll(pool.stacks());
        }
        return list;
    }

    public List<ConditionalStack> stacks() {
        return this.stacks.get();
    }

    public int getWidth() {
        return this.width;
    }

    private boolean add(ClientBuiltPool newPool) {
        int newWidth = this.getNewWidth(newPool);
        if (this.width + newWidth > this.maxWidth) {
            return false;
        }
        this.width += newWidth;
        this.poolList.add(newPool);
        return true;
    }

    public void addSimple(ClientBuiltPool newPool) {
        this.width = this.getNewWidth(newPool);
        this.poolList.add(newPool);
    }

    public Optional<ClientBuiltPool> addAndTrim(ClientBuiltPool newPool) {
        if (this.add(newPool)) {
            return Optional.empty();
        }
        if (this.width == 0) {
            ArrayList<ConditionalStack> madeItIn = new ArrayList<ConditionalStack>();
            ArrayList<ConditionalStack> leftOvers = new ArrayList<ConditionalStack>();
            AtomicInteger newWidth = new AtomicInteger(14 + 11 * ((newPool.conditions().size() - 1) / 2 - 1));
            newPool.stacks().forEach(s -> {
                float weight = s.weight();
                List<ItemStack> stacks = s.getRawStacks().stream().sorted(Comparator.comparingInt(s1 -> BuiltInRegistries.f_257033_.m_7447_((Object)s1.m_41720_()))).toList();
                if (newWidth.addAndGet(20) <= this.maxWidth) {
                    madeItIn.add(new ConditionalStack(s.conditions(), weight, stacks));
                } else {
                    leftOvers.add(new ConditionalStack(s.conditions(), weight, stacks));
                }
            });
            this.add(new ClientBuiltPool(newPool.conditions(), madeItIn));
            return Optional.of(new ClientBuiltPool(newPool.conditions(), leftOvers));
        }
        return Optional.of(newPool);
    }

    private int getNewWidth(ClientBuiltPool newPool) {
        int newWidth = this.poolList.isEmpty() ? 14 + 11 * ((newPool.conditions().size() - 1) / 2) + 20 * newPool.stacks().size() : 20 + 11 * ((newPool.conditions().size() - 1) / 2) + 20 * newPool.stacks().size();
        return newWidth;
    }

    public boolean canAddPool(ClientBuiltPool newPool) {
        int newWidth = this.getNewWidth(newPool);
        return this.width + newWidth <= this.maxWidth;
    }

    public boolean canAddOther(WidgetRowBuilder other) {
        return this.width + other.width + 6 <= this.maxWidth;
    }

    public void addOther(WidgetRowBuilder other) {
        this.poolList.addAll(other.poolList);
    }

    public static void collate(List<WidgetRowBuilder> builders) {
        if (builders.isEmpty()) {
            return;
        }
        Int2IntOpenHashMap collateMap = new Int2IntOpenHashMap();
        for (int i = 0; i < builders.size(); ++i) {
            for (int j = 0; j < builders.size(); ++j) {
                if (i == j || !builders.get(j).canAddOther(builders.get(i))) continue;
                collateMap.put(j, i);
            }
        }
        if (!collateMap.isEmpty()) {
            Int2IntMap.Entry entry = (Int2IntMap.Entry)collateMap.int2IntEntrySet().stream().toList().get(0);
        }
    }
}

