/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.schematicdisplay.clipboard;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.runtime.EmiFavorites;
import java.util.List;
import net.liukrast.schematicdisplay.EMICreateSchematics;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class ClipboardScreenUtils {
    private ClipboardScreenUtils() {
    }

    public static boolean load(@Nullable CompoundTag tag, boolean save) {
        try {
            if (tag == null) {
                throw new Exception("Tag is null");
            }
            ListTag pages = tag.m_128437_("Pages", 10);
            if (pages.isEmpty()) {
                throw new Exception("Pages size is 0");
            }
            for (int i = 0; i < pages.size(); ++i) {
                ListTag entries = pages.m_128728_(i).m_128437_("Entries", 10);
                if (entries.isEmpty()) {
                    throw new Exception("Entries size is 0");
                }
                for (int k = 0; k < entries.size(); ++k) {
                    CompoundTag entry = entries.m_128728_(k);
                    CompoundTag icon = entry.m_128469_("Icon");
                    String id = icon.m_128461_("id");
                    ResourceLocation location = new ResourceLocation(id);
                    String text = entry.m_128461_("Text");
                    MutableComponent lT = Component.Serializer.m_130701_((String)text);
                    if (lT == null) {
                        return false;
                    }
                    List components = lT.m_7360_();
                    if (components.isEmpty()) continue;
                    int c = Integer.parseInt(((Component)components.get(1)).toString().replace("literal{\n x", "").replace("}[style={color=black}]", ""));
                    if (!save) continue;
                    ItemStack stack = new ItemStack((Holder)ForgeRegistries.ITEMS.getDelegateOrThrow(location));
                    EmiIngredient ingredient = EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
                    ingredient.setAmount((long)c);
                    EmiFavorites.addFavorite((EmiIngredient)ingredient);
                }
            }
            return true;
        }
        catch (Exception exception) {
            EMICreateSchematics.LOGGER.debug("Error during export of clipboard content to EMI list");
            exception.printStackTrace();
            return false;
        }
    }
}

