/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public record SaveDialogButtonMessage(UUID uuid, UUID dialogId, UUID dialogButtonId, DialogButtonEntry dialogButtonEntry) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "save_dialog_button");

    public static SaveDialogButtonMessage create(FriendlyByteBuf buffer) {
        return new SaveDialogButtonMessage(buffer.m_130259_(), buffer.m_130259_(), buffer.m_130259_(), new DialogButtonEntry(buffer.m_130260_()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130077_(this.dialogId);
        buffer.m_130077_(this.dialogButtonId);
        buffer.m_130079_(this.dialogButtonEntry.createTag());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        int permissionLevel;
        MinecraftServer minecraftServer;
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.dialogButtonEntry == null) {
            log.error("Invalid dialog button data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DialogDataCapable dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Invalid dialog data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        ActionEventDataCapable actionEventData = easyNPC.getEasyNPCActionEventData();
        if (actionEventData == null) {
            log.error("Invalid action data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (!dialogData.hasDialog(this.dialogId)) {
            log.error("Unknown dialog button editor request for dialog {} for {} from {}", (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.dialogButtonId != null && !dialogData.hasDialogButton(this.dialogId, this.dialogButtonId)) {
            log.error("Invalid dialog button {} for {} from {}", (Object)this.dialogButtonId, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        int currentPermissionLevel = actionEventData.getActionPermissionLevel();
        if (currentPermissionLevel == 0 && (minecraftServer = serverPlayer.m_20194_()) != null && (permissionLevel = minecraftServer.m_129944_(serverPlayer.m_36316_())) > currentPermissionLevel) {
            log.debug("Update owner permission level from {} to {} for {} from {}", (Object)currentPermissionLevel, (Object)permissionLevel, (Object)easyNPC, (Object)serverPlayer);
            actionEventData.setActionPermissionLevel(permissionLevel);
        }
        if (this.dialogButtonId == null) {
            log.info("Add new dialog button {} for dialog {} for {} from {}", (Object)this.dialogButtonEntry, (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
            dialogData.getDialogDataSet().getDialog(this.dialogId).setDialogButton(this.dialogButtonEntry);
        } else {
            log.info("Edit existing dialog button {} for dialog {} for {} from {}", (Object)this.dialogButtonEntry, (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
            dialogData.getDialogDataSet().getDialog(this.dialogId).setDialogButton(this.dialogButtonId, this.dialogButtonEntry);
        }
    }
}

