/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.SkinHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeSkinMessage(UUID uuid, SkinDataEntry skinDataEntry) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_skin");

    public static ChangeSkinMessage create(FriendlyByteBuf buffer) {
        return new ChangeSkinMessage(buffer.m_130259_(), new SkinDataEntry(buffer.m_130260_()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130079_(this.skinDataEntry.createTag());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null || this.skinDataEntry == null || easyNPC.getEasyNPCSkinData() == null) {
            log.error("Skin validation failed for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (!SkinHandler.setSkin((EasyNPC)easyNPC, (SkinDataEntry)this.skinDataEntry)) {
            log.error("Failed changing skin data entry:{} for {} from {}", (Object)this.skinDataEntry, (Object)easyNPC, (Object)serverPlayer);
        }
    }
}

