/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeProfessionMessage(UUID uuid, Profession profession) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_profession");

    public static ChangeProfessionMessage create(FriendlyByteBuf buffer) {
        return new ChangeProfessionMessage(buffer.m_130259_(), (Profession)buffer.m_130066_(Profession.class));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.profession);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.profession == null) {
            log.error("Invalid profession for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        ProfessionDataCapable professionData = easyNPC.getEasyNPCProfessionData();
        if (professionData == null) {
            log.error("Invalid profession data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change profession {} for {} from {}", (Object)this.profession, (Object)easyNPC, (Object)serverPlayer);
        professionData.setProfession(this.profession);
    }
}

