/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.NameHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeNameMessage(UUID uuid, String name, int color, NameVisibilityType nameVisibilityType) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_name");

    public static ChangeNameMessage create(FriendlyByteBuf buffer) {
        return new ChangeNameMessage(buffer.m_130259_(), buffer.m_130277_(), buffer.readInt(), (NameVisibilityType)buffer.m_130066_(NameVisibilityType.class));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130070_(this.name);
        buffer.writeInt(this.color);
        buffer.m_130068_((Enum)this.nameVisibilityType);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (!NameHandler.setCustomName((EasyNPC)easyNPC, (String)this.name, (int)this.color, (NameVisibilityType)this.nameVisibilityType)) {
            log.error("Unable to set custom name {} for {} from {}", (Object)this.name, (Object)easyNPC, (Object)serverPlayer);
        }
    }
}

