/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.client;

import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.dialog.DialogDataManager;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.menu.ClientMenuManager;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record OpenMenuCallbackMessage(UUID uuid, UUID menuId, CompoundTag data) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "open_menu_callback_message");

    public static OpenMenuCallbackMessage create(FriendlyByteBuf buffer) {
        return new OpenMenuCallbackMessage(buffer.m_130259_(), buffer.m_130259_(), buffer.m_130260_());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130077_(this.menuId);
        buffer.m_130079_(this.data);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleClient() {
        AdditionalScreenData additionalScreenData;
        UUID uuid = this.uuid;
        UUID menuId = this.menuId;
        CompoundTag data = this.data;
        if (uuid == null || menuId == null || data == null) {
            log.error("Invalid menu data received for {} with menuId {} and data: {}", (Object)uuid, (Object)menuId, (Object)data);
            return;
        }
        ClientMenuManager.setMenuData((UUID)menuId, (CompoundTag)data);
        if (ClientMenuManager.hasAdditionalScreenData() && (additionalScreenData = ClientMenuManager.getAdditionalScreenData()).hasDialogDataSet()) {
            DialogDataManager.addDialogDataSet((UUID)this.uuid, (DialogDataSet)additionalScreenData.getDialogDataSet());
        }
        NetworkMessageHandlerManager.getServerHandler().openMenu(uuid, menuId);
    }
}

