/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.utils;

import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BlockHitFromScreen {
    @Nullable
    public static BlockHitResult getHit(float tickDelta, int x, int y) {
        Minecraft client = Minecraft.m_91087_();
        int width = client.m_91268_().m_85445_();
        int height = client.m_91268_().m_85446_();
        Vec3 cameraDirection = client.f_91075_.m_20252_(tickDelta);
        double fov = ((Integer)client.f_91066_.m_231837_().m_231551_()).intValue();
        double angleSize = fov / (double)height;
        Vector3f verticalRotationAxis = cameraDirection.m_252839_();
        verticalRotationAxis.cross(0.0f, 1.0f, 0.0f);
        verticalRotationAxis.normalize();
        Vector3f horizontalRotationAxis = cameraDirection.m_252839_();
        horizontalRotationAxis.cross((Vector3fc)verticalRotationAxis);
        horizontalRotationAxis.normalize();
        verticalRotationAxis = cameraDirection.m_252839_();
        verticalRotationAxis.cross((Vector3fc)horizontalRotationAxis);
        Vec3 direction = BlockHitFromScreen.map((float)angleSize, cameraDirection, Axis.m_253057_((Vector3f)horizontalRotationAxis), Axis.m_253057_((Vector3f)verticalRotationAxis), x, y, width, height);
        HitResult hit = BlockHitFromScreen.raycastInDirection(client, tickDelta, direction);
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHit = (BlockHitResult)hit;
            return blockHit;
        }
        return null;
    }

    private static Vec3 map(float anglePerPixel, Vec3 center, Axis horizontalRotationAxis, Axis verticalRotationAxis, int x, int y, int width, int height) {
        float horizontalRotation = ((float)x - (float)width / 2.0f) * anglePerPixel;
        float verticalRotation = ((float)y - (float)height / 2.0f) * anglePerPixel;
        Vector3f temp2 = center.m_252839_();
        temp2.rotate((Quaternionfc)verticalRotationAxis.m_252961_(verticalRotation));
        temp2.rotate((Quaternionfc)horizontalRotationAxis.m_252961_(horizontalRotation));
        return new Vec3(temp2);
    }

    private static HitResult raycastInDirection(Minecraft client, float tickDelta, Vec3 direction) {
        return BlockHitFromScreen.raycastInDirection(client, tickDelta, direction, client.f_91072_.m_105286_());
    }

    private static HitResult raycastInDirection(Minecraft client, float tickDelta, Vec3 direction, double reachDistance) {
        AABB box;
        Vec3 vec3d3;
        EntityHitResult entityHitResult;
        Entity entity = client.m_91288_();
        if (entity == null || client.f_91073_ == null) {
            return null;
        }
        HitResult target = BlockHitFromScreen.raycast(entity, reachDistance, tickDelta, false, direction);
        boolean tooFar = false;
        double extendedReach = reachDistance;
        if (client.f_91072_.m_105291_()) {
            reachDistance = extendedReach = 6.0;
        } else if (reachDistance > 3.0) {
            tooFar = true;
        }
        Vec3 cameraPos = entity.m_20299_(tickDelta);
        extendedReach *= extendedReach;
        if (target != null) {
            extendedReach = target.m_82450_().m_82557_(cameraPos);
        }
        if ((entityHitResult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)cameraPos, (Vec3)(vec3d3 = cameraPos.m_82549_(direction.m_82490_(reachDistance))), (AABB)(box = entity.m_20191_().m_82369_(entity.m_20252_(1.0f).m_82490_(reachDistance)).m_82377_(1.0, 1.0, 1.0)), entityx -> !entityx.m_5833_() && entityx.m_6087_(), (double)extendedReach)) == null) {
            return target;
        }
        Entity entity2 = entityHitResult.m_82443_();
        Vec3 vec3d4 = entityHitResult.m_82450_();
        double g = cameraPos.m_82557_(vec3d4);
        if (tooFar && g > 9.0) {
            return null;
        }
        if (g < extendedReach || target == null) {
            target = entityHitResult;
            if (entity2 instanceof LivingEntity || entity2 instanceof ItemFrame) {
                client.f_91076_ = entity2;
            }
        }
        return target;
    }

    private static HitResult raycast(Entity entity, double maxDistance, float tickDelta, boolean includeFluids, Vec3 direction) {
        Vec3 end = entity.m_20299_(tickDelta).m_82549_(direction.m_82490_(maxDistance));
        return entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(tickDelta), end, ClipContext.Block.OUTLINE, includeFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, entity));
    }
}

