/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.sculkophone;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.peripherals.IPeripheralTileDucky;
import com.samsthenerd.duckyperiphs.peripherals.sculkophone.SculkophoneBlock;
import com.samsthenerd.duckyperiphs.peripherals.sculkophone.SculkophonePeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SculkophoneBlockEntity
extends BlockEntity
implements GameEventListener.Holder<VibrationSystem.Listener>,
VibrationSystem,
IPeripheralTileDucky {
    private static final Logger LOGGER = LogUtils.getLogger();
    private VibrationSystem.Data listenerData;
    private final VibrationSystem.Listener listener;
    private final VibrationSystem.User callback;
    private int lastVibrationFrequency;
    private SculkophonePeripheral sculkPeriph = new SculkophonePeripheral(this);

    public SculkophoneBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DuckyPeriphs.SCULKOPHONE_BLOCK_ENTITY.get(), pos, state);
        this.callback = new SPVibrationCallback(this, pos, this.sculkPeriph);
        this.listenerData = new VibrationSystem.Data();
        this.listener = new VibrationSystem.Listener((VibrationSystem)this);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.lastVibrationFrequency = nbt.m_128451_("last_vibration_frequency");
        if (nbt.m_128425_("listener", 10)) {
            new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128469_("listener"));
            VibrationSystem.Data.f_279637_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128469_("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(listener -> {
                this.listenerData = listener;
            });
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("last_vibration_frequency", this.lastVibrationFrequency);
        VibrationSystem.Data.f_279637_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.listenerData).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(listenerNbt -> nbt.m_128365_("listener", listenerNbt));
    }

    public VibrationSystem.Listener getEventListener() {
        return this.listener;
    }

    public VibrationSystem.Data m_280002_() {
        return this.listenerData;
    }

    public VibrationSystem.User m_280445_() {
        return this.callback;
    }

    public int getLastVibrationFrequency() {
        return this.lastVibrationFrequency;
    }

    @Override
    @Nullable
    public IPeripheral getPeripheral(@Nonnull Direction side) {
        if (this.sculkPeriph == null) {
            this.sculkPeriph = new SculkophonePeripheral(this);
        }
        return this.sculkPeriph;
    }

    public void makeVibration(GameEvent event) {
    }

    public static class SPVibrationCallback
    implements VibrationSystem.User {
        private final SculkophoneBlockEntity spbe;
        private final SculkophonePeripheral sculkPeriph;
        private final BlockPos spPos;
        PositionSource posSource;

        public SPVibrationCallback(SculkophoneBlockEntity spbe, BlockPos pos, SculkophonePeripheral sculkPeriph) {
            this.spbe = spbe;
            this.spPos = pos;
            this.sculkPeriph = sculkPeriph;
            this.posSource = new BlockPositionSource(pos);
        }

        public boolean m_280076_() {
            return true;
        }

        public boolean m_280080_(ServerLevel world, BlockPos pos, GameEvent event, @Nullable GameEvent.Context emitter) {
            if (this.spbe.m_58901_() || pos.equals((Object)this.spPos) && (event == GameEvent.f_157794_ || event == GameEvent.f_157797_)) {
                return false;
            }
            return SculkophoneBlock.isInactive(this.spbe.m_58900_());
        }

        public void m_280271_(ServerLevel world, BlockPos pos, GameEvent event, @Nullable Entity entity, @Nullable Entity sourceEntity, float distance) {
            BlockState blockState = this.spbe.m_58900_();
            if (SculkophoneBlock.isInactive(blockState)) {
                if (this.sculkPeriph != null) {
                    this.sculkPeriph.vibrationEvent(event, distance);
                }
                SculkophoneBlock.setActive(entity, (Level)world, this.spPos, blockState);
            }
        }

        public void m_280022_() {
            this.spbe.m_6596_();
        }

        public int m_280351_() {
            return 8;
        }

        public PositionSource m_280010_() {
            return this.posSource;
        }

        public boolean m_280215_() {
            return true;
        }
    }
}

