/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.sculkophone;

import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.peripherals.sculkophone.SculkophoneBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.Nullable;

public class SculkophoneBlock
extends BaseEntityBlock {
    public static final int field_31239 = 40;
    public static final int field_31240 = 1;
    public static final EnumProperty<SculkSensorPhase> SCULK_SENSOR_PHASE = BlockStateProperties.f_155999_;
    private final int range;

    public SculkophoneBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SCULK_SENSOR_PHASE, (Comparable)SculkSensorPhase.INACTIVE));
        this.range = 8;
    }

    public int getRange() {
        return this.range;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.m_49966_();
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (SculkophoneBlock.getPhase(state) != SculkSensorPhase.ACTIVE) {
            if (SculkophoneBlock.getPhase(state) == SculkSensorPhase.COOLDOWN) {
                world.m_7731_(pos, (BlockState)state.m_61124_(SCULK_SENSOR_PHASE, (Comparable)SculkSensorPhase.INACTIVE), 3);
            }
            return;
        }
        SculkophoneBlock.setCooldown((Level)world, pos, state);
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (!world.m_5776_() && SculkophoneBlock.isInactive(state) && entity.m_6095_() != EntityType.f_217015_) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof SculkophoneBlockEntity) {
                SculkophoneBlockEntity sculkophoneBlockEntity = (SculkophoneBlockEntity)blockEntity;
            }
            SculkophoneBlock.setActive(entity, world, pos, state);
        }
        super.m_141947_(world, pos, state, entity);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        if (SculkophoneBlock.getPhase(state) == SculkSensorPhase.ACTIVE) {
            SculkophoneBlock.updateNeighbors(world, pos);
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    private static void updateNeighbors(Level world, BlockPos pos) {
        world.m_46672_(pos, Blocks.f_152500_);
        world.m_46672_(pos.m_121945_(Direction.UP.m_122424_()), Blocks.f_152500_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SculkophoneBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener m_214009_(ServerLevel world, T blockEntity) {
        if (blockEntity instanceof SculkophoneBlockEntity) {
            return ((SculkophoneBlockEntity)blockEntity).getEventListener();
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world2, BlockState state2, BlockEntityType<T> type) {
        if (!world2.f_46443_) {
            return SculkophoneBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)DuckyPeriphs.SCULKOPHONE_BLOCK_ENTITY.get()), (world, pos, state, blockEntity) -> VibrationSystem.Ticker.m_280259_((Level)world, (VibrationSystem.Data)blockEntity.m_280002_(), (VibrationSystem.User)blockEntity.m_280445_()));
        }
        return null;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public static SculkSensorPhase getPhase(BlockState state) {
        return (SculkSensorPhase)state.m_61143_(SCULK_SENSOR_PHASE);
    }

    public static boolean isInactive(BlockState state) {
        return SculkophoneBlock.getPhase(state) == SculkSensorPhase.INACTIVE;
    }

    public static void setCooldown(Level world, BlockPos pos, BlockState state) {
        world.m_7731_(pos, (BlockState)state.m_61124_(SCULK_SENSOR_PHASE, (Comparable)SculkSensorPhase.COOLDOWN), 3);
        world.m_186460_(pos, state.m_60734_(), 1);
        world.m_5594_(null, pos, (SoundEvent)DuckyPeriphs.SCULKOPHONE_CLICKING_STOP_EVENT.get(), SoundSource.BLOCKS, 0.25f, world.f_46441_.m_188501_() * 0.2f + 0.8f);
        SculkophoneBlock.updateNeighbors(world, pos);
    }

    public static void setActive(@Nullable Entity entity, Level world, BlockPos pos, BlockState state) {
        world.m_7731_(pos, (BlockState)state.m_61124_(SCULK_SENSOR_PHASE, (Comparable)SculkSensorPhase.ACTIVE), 3);
        world.m_186460_(pos, state.m_60734_(), 20);
        SculkophoneBlock.updateNeighbors(world, pos);
        world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)DuckyPeriphs.SCULKOPHONE_CLICKING_EVENT.get(), SoundSource.BLOCKS, 0.25f, world.f_46441_.m_188501_() * 0.2f + 0.8f);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SCULK_SENSOR_PHASE});
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SculkophoneBlockEntity) {
            SculkophoneBlockEntity SculkophoneBlockEntity2 = (SculkophoneBlockEntity)blockEntity;
            return SculkophoneBlock.getPhase(state) == SculkSensorPhase.ACTIVE ? SculkophoneBlockEntity2.getLastVibrationFrequency() : 0;
        }
        return 0;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

