/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.keyboards;

import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardScreenHandler;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardTile;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class KeyboardUtils {
    public static void keyPressHandler(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int key = buf.readInt();
        int scancode = buf.readInt();
        int modifiers = buf.readInt();
        Boolean repeat = buf.readBoolean();
        String pasteText = buf.m_130277_();
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        if (!(player.f_36096_ instanceof KeyboardScreenHandler)) {
            return;
        }
        BlockPos pos = ((KeyboardScreenHandler)player.f_36096_).pos;
        MinecraftServer server = player.m_20194_();
        Level world = player.m_20193_();
        DuckyPeriphs.logPrint("recieved key press packet: " + key + " on worldtype: " + (world.f_46443_ ? "client" : "server"));
        server.execute(() -> KeyboardTile.keyPress(pos, world, key, scancode, modifiers, repeat, pasteText));
    }

    public static void keyUpHandler(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int key = buf.readInt();
        int scancode = buf.readInt();
        int modifiers = buf.readInt();
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        if (!(player.f_36096_ instanceof KeyboardScreenHandler)) {
            return;
        }
        BlockPos pos = ((KeyboardScreenHandler)player.f_36096_).pos;
        MinecraftServer server = player.m_20194_();
        Level world = player.m_20193_();
        DuckyPeriphs.logPrint("recieved key up packet: " + key + " on worldtype: " + (world.f_46443_ ? "client" : "server"));
        server.execute(() -> KeyboardTile.keyUp(pos, world, key, scancode, modifiers));
    }

    public static void charTypedHandler(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        char char_sent = buf.readChar();
        int modifiers = buf.readInt();
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        if (!(player.f_36096_ instanceof KeyboardScreenHandler)) {
            return;
        }
        BlockPos pos = ((KeyboardScreenHandler)player.f_36096_).pos;
        MinecraftServer server = player.m_20194_();
        Level world = player.m_20193_();
        DuckyPeriphs.logPrint("recieved char " + char_sent + " on worldtype: " + (world.f_46443_ ? "client" : "server"));
        server.execute(() -> KeyboardTile.charTyped(pos, world, char_sent, modifiers));
    }

    public static void eventShortcutHandler(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int eventCode = buf.readInt();
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        if (!(player.f_36096_ instanceof KeyboardScreenHandler)) {
            return;
        }
        BlockPos pos = ((KeyboardScreenHandler)player.f_36096_).pos;
        MinecraftServer server = player.m_20194_();
        Level world = player.m_20193_();
        DuckyPeriphs.logPrint("recieved event " + eventCode + " on worldtype: " + (world.f_46443_ ? "client" : "server"));
        server.execute(() -> KeyboardTile.handleEvents(pos, world, eventCode));
    }
}

