/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.keyboards;

import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.peripherals.IPeripheralTileDucky;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyCaps;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardPeripheral;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardScreenHandler;
import dan200.computercraft.api.peripheral.IPeripheral;
import dev.architectury.registry.menu.MenuRegistry;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class KeyboardTile
extends BlockEntity
implements IPeripheralTileDucky,
Nameable {
    public KeyboardPeripheral kbPeriph;
    private Component customName;
    KeyCaps keyCaps = new KeyCaps();

    public KeyboardTile(BlockEntityType<KeyboardTile> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.kbPeriph = new KeyboardPeripheral(this);
    }

    public KeyboardTile(BlockPos pos, BlockState state) {
        this((BlockEntityType<KeyboardTile>)((BlockEntityType)DuckyPeriphs.KEYBOARD_TILE.get()), pos, state);
    }

    @Override
    public IPeripheral getPeripheral(@Nonnull Direction side) {
        if (this.kbPeriph == null) {
            this.kbPeriph = new KeyboardPeripheral(this);
        }
        return this.kbPeriph;
    }

    @Nonnull
    public InteractionResult onActivate(Player player, InteractionHand hand, BlockHitResult hit) {
        Level world = this.m_58904_();
        if (!world.f_46443_) {
            MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)new KeyboardScreenHandler.KeyboardScreenHandlerFactory(this), packetByteBuf -> this.writeScreenOpeningData((ServerPlayer)player, (FriendlyByteBuf)packetByteBuf));
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public AbstractContainerMenu createMenu(int syncId, @Nonnull Inventory inv, @Nonnull Player player) {
        return new KeyboardScreenHandler(syncId, inv, this.f_58858_);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public Component m_7755_() {
        if (this.customName != null) {
            return this.customName;
        }
        return Component.m_237115_((String)"block.minecraft.duck");
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public void writeScreenOpeningData(ServerPlayer serverPlayerEntity, FriendlyByteBuf packetByteBuf) {
        packetByteBuf.m_130064_(this.m_58899_());
    }

    public static void keyPress(BlockPos pos, Level world, int key, int scancode, int modifiers, Boolean repeat, String pasteText) {
        DuckyPeriphs.logPrint("reached keyPress in world " + world.m_46472_().m_135782_() + " at " + pos.toString() + " with key " + key);
        KeyboardTile kbTileTry = (KeyboardTile)world.m_7702_(pos);
        if (kbTileTry != null) {
            kbTileTry.kbPeriph.sendKey(key, repeat);
            if (key != 86 || (modifiers & 8) != 0) {
                // empty if block
            }
        }
    }

    public static void keyUp(BlockPos pos, Level world, int key, int scancode, int modifiers) {
        KeyboardTile kbTileTry = (KeyboardTile)world.m_7702_(pos);
        if (kbTileTry != null) {
            kbTileTry.kbPeriph.sendKeyUp(key);
        }
    }

    public static void charTyped(BlockPos pos, Level world, char typedChar, int modifiers) {
        KeyboardTile kbTileTry = (KeyboardTile)world.m_7702_(pos);
        if (kbTileTry != null && typedChar != '\u0000') {
            kbTileTry.kbPeriph.sendChar(typedChar);
        }
    }

    public static void handleEvents(BlockPos pos, Level world, int event) {
        KeyboardTile kbTileTry = (KeyboardTile)world.m_7702_(pos);
        if (kbTileTry != null) {
            if (event == 0) {
                kbTileTry.kbPeriph.sendTerminate();
            }
            if (event == 1) {
                kbTileTry.kbPeriph.sendShutdown();
            }
            if (event == 2) {
                kbTileTry.kbPeriph.sendReboot();
            }
        }
    }

    private static char getChar(int key, int modifiers) {
        Boolean shift = (modifiers & 1) != 0;
        if ((modifiers & 2) == 1) {
            return '\u0000';
        }
        if (key >= 48 && key <= 57) {
            if (shift.booleanValue()) {
                return ")!@#$%^&*(".charAt(key - 48);
            }
            return (char)(key - 48 + 48);
        }
        if (key >= 320 && key <= 323) {
            return (char)(key - 320 + 48);
        }
        if (key >= 65 && key <= 90) {
            if (shift.booleanValue()) {
                return (char)key;
            }
            return (char)(key + 32);
        }
        if (key == 32) {
            return ' ';
        }
        if (key == 39) {
            return shift != false ? (char)'\"' : '\'';
        }
        if (key == 44) {
            return shift != false ? (char)'<' : ',';
        }
        if (key == 45) {
            return shift != false ? (char)'_' : '-';
        }
        if (key == 46) {
            return shift != false ? (char)'>' : '.';
        }
        if (key == 47) {
            return shift != false ? (char)'?' : '/';
        }
        if (key == 59) {
            return shift != false ? (char)':' : ';';
        }
        if (key == 61) {
            return shift != false ? (char)'+' : '=';
        }
        if (key == 91) {
            return shift != false ? (char)'{' : '[';
        }
        if (key == 92) {
            return shift != false ? (char)'|' : '\\';
        }
        if (key == 93) {
            return shift != false ? (char)'}' : ']';
        }
        if (key == 96) {
            return shift != false ? (char)'~' : '`';
        }
        return '\u0000';
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)nbt.m_128461_("CustomName"));
        }
        if (nbt != null) {
            CompoundTag subNBT = nbt.m_128469_("key_caps");
            this.keyCaps = KeyCaps.fromNBT(subNBT);
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.customName != null) {
            nbt.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        nbt.m_128365_("key_caps", (Tag)this.keyCaps.toSubNBT());
    }
}

