/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.keyboards;

import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardScreenHandler;
import com.samsthenerd.duckyperiphs.utils.BlockHitFromScreen;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class KeyboardScreen
extends AbstractContainerScreen<KeyboardScreenHandler> {
    HashSet<Integer> pressedKeys = new HashSet();
    long[] eventsStarted = new long[]{0L, 0L, 0L};
    boolean[] eventChecking = new boolean[]{false, false, false};
    static int[] eventShortcutKeys = new int[]{84, 83, 82};

    public KeyboardScreen(KeyboardScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    protected void m_7286_(GuiGraphics context, float delta, int mouseX, int mouseY) {
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    public final boolean m_7933_(int key, int scancode, int modifiers) {
        if (key == 256) {
            return super.m_7933_(key, scancode, modifiers);
        }
        FriendlyByteBuf keyData = new FriendlyByteBuf(Unpooled.buffer());
        keyData.writeInt(key);
        keyData.writeInt(scancode);
        keyData.writeInt(modifiers);
        keyData.writeBoolean(this.pressedKeys.contains(key));
        String pasteText = "";
        if (KeyboardScreen.m_96630_((int)key)) {
            pasteText = this.f_96541_.f_91068_.m_90876_();
        }
        keyData.m_130070_(pasteText);
        keyData.m_130064_(((KeyboardScreenHandler)this.f_97732_).pos);
        NetworkManager.sendToServer((ResourceLocation)new ResourceLocation("ducky-periphs", "key_press_packet"), (FriendlyByteBuf)keyData);
        this.pressedKeys.add(key);
        return true;
    }

    public final boolean m_5534_(char this_char, int modifiers) {
        FriendlyByteBuf charData = new FriendlyByteBuf(Unpooled.buffer());
        charData.writeChar((int)this_char);
        charData.writeInt(modifiers);
        charData.m_130064_(((KeyboardScreenHandler)this.f_97732_).pos);
        NetworkManager.sendToServer((ResourceLocation)new ResourceLocation("ducky-periphs", "char_typed_packet"), (FriendlyByteBuf)charData);
        return super.m_5534_(this_char, modifiers);
    }

    public final boolean m_7920_(int key, int scancode, int modifiers) {
        FriendlyByteBuf keyData = new FriendlyByteBuf(Unpooled.buffer());
        keyData.writeInt(key);
        keyData.writeInt(scancode);
        keyData.writeInt(modifiers);
        keyData.m_130064_(((KeyboardScreenHandler)this.f_97732_).pos);
        DuckyPeriphs.logPrint("sending key press packet: " + key);
        NetworkManager.sendToServer((ResourceLocation)new ResourceLocation("ducky-periphs", "key_up_packet"), (FriendlyByteBuf)keyData);
        this.pressedKeys.remove(key);
        return super.m_7920_(key, scancode, modifiers);
    }

    protected void m_181908_() {
        boolean ctrlDownNow = KeyboardScreen.m_96637_();
        for (int sCut = 0; sCut < 3; ++sCut) {
            boolean isSKeyPressed = this.pressedKeys.contains(eventShortcutKeys[sCut]);
            if (this.eventChecking[sCut]) {
                if (isSKeyPressed && ctrlDownNow) {
                    if (Util.m_137550_() - this.eventsStarted[sCut] <= 1000L) continue;
                    this.eventChecking[sCut] = false;
                    this.eventsStarted[sCut] = 0L;
                    FriendlyByteBuf eventDataBuf = new FriendlyByteBuf(Unpooled.buffer());
                    eventDataBuf.writeInt(sCut);
                    NetworkManager.sendToServer((ResourceLocation)new ResourceLocation("ducky-periphs", "event_sent_packet"), (FriendlyByteBuf)eventDataBuf);
                    continue;
                }
                this.eventChecking[sCut] = false;
                continue;
            }
            if (!isSKeyPressed || !ctrlDownNow) continue;
            this.eventChecking[sCut] = true;
            this.eventsStarted[sCut] = Util.m_137550_();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        BlockHitResult hit = BlockHitFromScreen.getHit(0.0f, (int)mouseX, (int)mouseY);
        if (hit != null) {
            Minecraft client = Minecraft.m_91087_();
            DuckyPeriphs.logPrint("hit: " + hit.m_6662_() + "; pos: " + hit.m_82425_() + "; side: " + hit.m_82434_() + "; pos: " + hit.m_82450_());
            if (client.f_91073_ == null) {
                return super.m_6375_(mouseX, mouseY, button);
            }
            BlockState state = client.f_91073_.m_8055_(hit.m_82425_());
            if (state != null && state.m_60734_() instanceof MonitorBlock) {
                client.f_91072_.m_233732_(client.f_91074_, InteractionHand.MAIN_HAND, hit);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

