/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.keyboards;

import com.samsthenerd.duckyperiphs.DPRecipeSerializer;
import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.compat.gloopy.GloopyUtils;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyCaps;
import dev.architectury.platform.Platform;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class KeyboardRecipe
extends CustomRecipe {
    private static final Ingredient KEYBOARD = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DuckyPeriphs.KEYBOARD_ITEM.get()});
    private static final Ingredient SOLVENTS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41903_, Items.f_42447_});

    public KeyboardRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer craftingInventory, Level world) {
        int width = craftingInventory.m_39347_();
        int height = craftingInventory.m_39346_();
        boolean foundChanger = false;
        int minChangerX = 0;
        int minChangerY = 0;
        int maxChangerX = 0;
        int maxChangerY = 0;
        int keyboardCount = 0;
        int keyboardX = 0;
        int keyboardY = 0;
        for (int s = 0; s < width * height; ++s) {
            int x = s % width;
            int y = s / width;
            ItemStack stack = craftingInventory.m_8020_(s);
            if (KEYBOARD.test(stack)) {
                keyboardX = x;
                keyboardY = y;
                if (++keyboardCount <= 1) continue;
                return false;
            }
            if (!SOLVENTS.test(stack) && !(stack.m_41720_() instanceof DyeItem) && (!Platform.isModLoaded((String)"hexgloop") || !GloopyUtils.isGloopDye(stack))) continue;
            if (!foundChanger) {
                foundChanger = true;
                minChangerX = x;
                minChangerY = y;
                maxChangerX = x;
                maxChangerY = y;
                continue;
            }
            minChangerX = Math.min(minChangerX, x);
            minChangerY = Math.min(minChangerY, y);
            maxChangerX = Math.max(maxChangerX, x);
            maxChangerY = Math.max(maxChangerY, y);
        }
        if (keyboardCount == 0) {
            return false;
        }
        if (!foundChanger) {
            return false;
        }
        return Math.abs(keyboardX - minChangerX) <= 2 && Math.abs(keyboardY - minChangerY) <= 2 && Math.abs(keyboardX - maxChangerX) <= 2 && Math.abs(keyboardY - maxChangerY) <= 2;
    }

    public ItemStack craft(CraftingContainer craftingInventory, RegistryAccess dynRegManager) {
        int width = craftingInventory.m_39347_();
        int height = craftingInventory.m_39346_();
        int keyboardX = 0;
        int keyboardY = 0;
        ItemStack kbStack = ItemStack.f_41583_;
        for (int s = 0; s < width * height; ++s) {
            int x = s % width;
            int y = s / width;
            ItemStack stack = craftingInventory.m_8020_(s);
            if (!KEYBOARD.test(stack)) continue;
            keyboardX = x;
            keyboardY = y;
            kbStack = stack.m_41777_();
            break;
        }
        KeyCaps keyCaps = KeyCaps.fromItemStack(kbStack);
        for (int s = 0; s < width * height; ++s) {
            int craftingGridIndex;
            int x = s % width;
            int y = s / width;
            ItemStack stack = craftingInventory.m_8020_(s);
            if (SOLVENTS.test(stack)) {
                craftingGridIndex = this.gridIndex(x, y, keyboardX, keyboardY);
                keyCaps.removeColor(craftingGridIndex);
                continue;
            }
            if (stack.m_41720_() instanceof DyeItem) {
                craftingGridIndex = this.gridIndex(x, y, keyboardX, keyboardY);
                float[] thisColorComps = ((DyeItem)stack.m_41720_()).m_41089_().m_41068_();
                int thisColor = (int)(thisColorComps[0] * 255.0f) << 16 | (int)(thisColorComps[1] * 255.0f) << 8 | (int)(thisColorComps[2] * 255.0f);
                keyCaps.blendAndSetColor(thisColor, craftingGridIndex);
                continue;
            }
            if (!Platform.isModLoaded((String)"hexgloop") || !GloopyUtils.isGloopDye(stack)) continue;
            craftingGridIndex = this.gridIndex(x, y, keyboardX, keyboardY);
            int thisColor = GloopyUtils.getGloopDyeColor(stack);
            keyCaps.blendAndSetColor(thisColor, craftingGridIndex);
        }
        kbStack.m_41700_("key_caps", (Tag)keyCaps.toSubNBT());
        return kbStack;
    }

    public NonNullList<ItemStack> getRemainder(TransientCraftingContainer inventory) {
        NonNullList defaultedList = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < defaultedList.size(); ++i) {
            Item item = inventory.m_8020_(i).m_41720_();
            if (item == Items.f_41903_) {
                defaultedList.set(i, (Object)inventory.m_8020_(i));
            } else if (item == Items.f_42447_) {
                defaultedList.set(i, (Object)new ItemStack((ItemLike)Items.f_42446_));
            } else if (Platform.isModLoaded((String)"hexgloop") && GloopyUtils.isGloopDye(inventory.m_8020_(i))) {
                ItemStack stack = inventory.m_8020_(i).m_41777_();
                GloopyUtils.useGloopMedia(stack);
                defaultedList.set(i, (Object)stack);
            }
            if (!item.m_41470_()) continue;
            defaultedList.set(i, (Object)new ItemStack((ItemLike)item.m_41469_()));
        }
        return defaultedList;
    }

    private int gridIndex(int c_x, int c_y, int kb_x, int kb_y) {
        int x = c_x - kb_x + 2;
        int y = c_y - kb_y + 2;
        return x + 5 * y;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)DPRecipeSerializer.KEYBOARD_RECIPE.get();
    }

    public boolean m_5598_() {
        return true;
    }
}

