/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.keyboards;

import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardTile;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;

public class KeyboardPeripheral
implements IPeripheral {
    private final KeyboardTile kbTile;
    public List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    public KeyboardPeripheral(KeyboardTile kbTile) {
        this.kbTile = kbTile;
    }

    @Nonnull
    public String getType() {
        return "keyboard";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public void sendKey(int key, Boolean repeat) {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("key", new Object[]{key, repeat, computer.getAttachmentName()});
        }
    }

    public void sendKeyUp(int key) {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("key_up", new Object[]{key, computer.getAttachmentName()});
        }
    }

    public void sendChar(char c) {
        String stringyChar = Character.toString(c);
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("char", new Object[]{stringyChar, computer.getAttachmentName()});
        }
    }

    public void sendPaste(String text) {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("paste", new Object[]{text, computer.getAttachmentName()});
        }
    }

    public void sendTerminate() {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("terminate", new Object[]{computer.getAttachmentName()});
        }
    }

    public void sendShutdown() {
        for (IComputerAccess computer : this.computers) {
            this.getServerComputer(computer).shutdown();
            computer.queueEvent("shutdown", new Object[]{computer.getAttachmentName()});
        }
    }

    public void sendReboot() {
        for (IComputerAccess computer : this.computers) {
            this.getServerComputer(computer).reboot();
            computer.queueEvent("reboot", new Object[]{computer.getAttachmentName()});
        }
    }

    private ServerComputer getServerComputer(IComputerAccess computer) {
        return ServerContext.get((MinecraftServer)this.kbTile.m_58904_().m_7654_()).registry().get(computer.getID());
    }
}

