/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.keyboards;

import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyCaps;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KeyboardBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)1.0, (double)1.0, (double)11.0, (double)2.0, (double)15.0);

    public KeyboardBlock(BlockBehaviour.Properties settings) {
        super(settings.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void openScreen(BlockState state, Level world, BlockPos pos, Player player) {
        MenuProvider screenHandlerFactory;
        if (!world.f_46443_ && (screenHandlerFactory = state.m_60750_(world, pos)) != null) {
            player.m_5893_(screenHandlerFactory);
        }
    }

    @Nonnull
    public final InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        InteractionResult interactionResult;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof KeyboardTile) {
            KeyboardTile kbTile = (KeyboardTile)tile;
            interactionResult = kbTile.onActivate(player, hand, hit);
        } else {
            interactionResult = InteractionResult.PASS;
        }
        return interactionResult;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_8125_().m_122424_();
        if (direction == Direction.DOWN || direction == Direction.UP) {
            direction = Direction.NORTH;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
    }

    public KeyboardTile getKBTile(Level world, BlockPos pos) {
        return (KeyboardTile)world.m_7702_(pos);
    }

    public KeyCaps getKeyCaps(BlockGetter view, BlockPos pos) {
        KeyCaps keyCapsToReturn;
        BlockEntity kb_tile = view.m_7702_(pos);
        if (kb_tile instanceof KeyboardTile && (keyCapsToReturn = ((KeyboardTile)kb_tile).keyCaps) != null) {
            return keyCapsToReturn;
        }
        return new KeyCaps();
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        KeyCaps itemKeyCaps;
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = world.m_7702_(pos)) instanceof KeyboardTile) {
            ((KeyboardTile)blockEntity).setCustomName(itemStack.m_41786_());
        }
        if ((blockEntity = world.m_7702_(pos)) instanceof KeyboardTile && (itemKeyCaps = KeyCaps.fromItemStack(itemStack)) != null) {
            ((KeyboardTile)blockEntity).keyCaps = itemKeyCaps;
        }
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83148_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return KeyboardBlock.rotateShape(Direction.EAST, direction, SHAPE);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.m_83040_();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeyboardTile(pos, state);
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }
}

