/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.keyboards;

import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyCraftingZone;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyZone;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;

public class KeyCaps {
    public int[] craftingValues = new int[25];
    public int craftingNulls = 0;
    public static final String KEY_CAP_KEY = "key_caps";
    public static final String CRAFTING_VALUES_KEY = "crafting_values";
    public static final String CRAFTING_NULLS_KEY = "crafting_nulls";
    public static final int DEFAULT_COLOR = 0x1D1D21;

    public static KeyCaps fromNBT(CompoundTag nbt) {
        KeyCaps keyCaps = new KeyCaps();
        if (nbt != null && nbt.m_128425_(CRAFTING_NULLS_KEY, 3)) {
            keyCaps.craftingNulls = nbt.m_128451_(CRAFTING_NULLS_KEY);
            if (nbt.m_128425_(CRAFTING_VALUES_KEY, 11)) {
                keyCaps.craftingValues = nbt.m_128465_(CRAFTING_VALUES_KEY);
            }
        }
        return keyCaps;
    }

    public static KeyCaps fromItemStack(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41737_(KEY_CAP_KEY);
        return KeyCaps.fromNBT(nbt);
    }

    public CompoundTag toSubNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(CRAFTING_NULLS_KEY, this.craftingNulls);
        nbt.m_128385_(CRAFTING_VALUES_KEY, this.craftingValues);
        return nbt;
    }

    public static ItemStack changeColor(ItemStack itemStack, int color, int craftingIndex) {
        KeyCaps keyCaps = KeyCaps.fromItemStack(itemStack);
        keyCaps.changeColor(color, craftingIndex);
        CompoundTag nbt = itemStack.m_41698_(KEY_CAP_KEY);
        nbt.m_128365_(KEY_CAP_KEY, (Tag)keyCaps.toSubNBT());
        return itemStack;
    }

    public void changeColor(int newColor, int craftingIndex) {
        this.craftingValues[craftingIndex] = newColor;
        this.craftingNulls |= 1 << craftingIndex;
    }

    public static int blendColors(int color1, int color2) {
        int[] is = new int[3];
        int i = 0;
        int j = 0;
        float f = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float g = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float h = (float)(color1 & 0xFF) / 255.0f;
        i += (int)(Math.max(f, Math.max(g, h)) * 255.0f);
        is[0] = is[0] + (int)(f * 255.0f);
        is[1] = is[1] + (int)(g * 255.0f);
        is[2] = is[2] + (int)(h * 255.0f);
        ++j;
        float[] fs = new float[]{(float)((color2 & 0xFF0000) >> 16) / 255.0f, (float)((color2 & 0xFF00) >> 8) / 255.0f, (float)((color2 & 0xFF) >> 0) / 255.0f};
        int l = (int)(fs[0] * 255.0f);
        int m = (int)(fs[1] * 255.0f);
        int n = (int)(fs[2] * 255.0f);
        i += Math.max(l, Math.max(m, n));
        is[0] = is[0] + l;
        is[1] = is[1] + m;
        is[2] = is[2] + n;
        int k = is[0] / ++j;
        int o = is[1] / j;
        int p = is[2] / j;
        h = (float)i / (float)j;
        float q = Math.max(k, Math.max(o, p));
        k = (int)((float)k * h / q);
        o = (int)((float)o * h / q);
        p = (int)((float)p * h / q);
        n = k;
        n = (n << 8) + o;
        n = (n << 8) + p;
        return n;
    }

    public void blendAndSetColor(int newColor, int craftingIndex) {
        if (this.isDefault(craftingIndex)) {
            this.changeColor(newColor, craftingIndex);
            return;
        }
        int oldColor = this.craftingValues[craftingIndex];
        int blendedColor = KeyCaps.blendColors(oldColor, newColor);
        this.changeColor(blendedColor, craftingIndex);
    }

    public void removeColor(int craftingIndex) {
        this.craftingValues[craftingIndex] = 0x1D1D21;
        this.craftingNulls &= ~(1 << craftingIndex);
    }

    public void logSelf() {
        DuckyPeriphs.logPrint("KeyCaps: " + this.craftingNulls);
    }

    public boolean isDefault() {
        return this.craftingNulls == 0;
    }

    public boolean isDefault(int cZone) {
        return (1 << cZone & this.craftingNulls) == 0;
    }

    public boolean isDefault(KeyCraftingZone cZone) {
        return (1 << cZone.id & this.craftingNulls) == 0;
    }

    public int getZoneColor(KeyZone zone) {
        return this.getZoneColor(zone.tintIndex());
    }

    public static boolean isZoneType(int tintIndex, KeyZone[] zoneType) {
        for (KeyZone zone : zoneType) {
            if (zone.tintIndex() != tintIndex) continue;
            return true;
        }
        return false;
    }

    public Component getDisplayText(KeyZone keyZone) {
        int keyColor = this.getZoneColor(keyZone);
        if (keyColor == 0x1D1D21) {
            return null;
        }
        return Component.m_237115_((String)keyZone.getName()).m_7220_(Component.m_130674_((String)": #")).m_7220_(Component.m_130674_((String)Integer.toHexString(keyColor)));
    }

    Component getDisplayText(KeyCraftingZone keyCraftingZone) {
        if (this.isDefault(keyCraftingZone)) {
            return null;
        }
        int keyColor = this.craftingValues[keyCraftingZone.id];
        MutableComponent colorIndicatorText = Component.m_237113_((String)"\u2665").m_6270_(Style.f_131099_.m_178520_(keyColor));
        MutableComponent colorText = Component.m_237113_((String)": #").m_7220_(Component.m_130674_((String)Integer.toHexString(keyColor))).m_130940_(ChatFormatting.GRAY).m_7220_((Component)colorIndicatorText);
        return Component.m_237115_((String)keyCraftingZone.getNameKey()).m_130940_(ChatFormatting.GRAY).m_7220_((Component)colorText);
    }

    public int getZoneColor(int tintIndex) {
        if (this.isDefault()) {
            return 0x1D1D21;
        }
        if (KeyCaps.isZoneType(tintIndex, KeyZone.CASE_ZONES)) {
            boolean have_main = !this.isDefault(KeyCraftingZone.CASE_MAIN);
            boolean have_left = !this.isDefault(KeyCraftingZone.CASE_LEFT);
            boolean have_right = !this.isDefault(KeyCraftingZone.CASE_RIGHT);
            boolean is_main = KeyCaps.isZoneType(tintIndex, KeyZone.CASE_ZONES_M);
            boolean is_left = KeyCaps.isZoneType(tintIndex, KeyZone.CASE_ZONES_L);
            boolean is_right = KeyCaps.isZoneType(tintIndex, KeyZone.CASE_ZONES_R);
            if (have_main && !have_left && !have_right) {
                return this.craftingValues[KeyCraftingZone.CASE_MAIN.id];
            }
            if (!have_main && have_left && have_right) {
                return is_left ? this.craftingValues[KeyCraftingZone.CASE_LEFT.id] : this.craftingValues[KeyCraftingZone.CASE_RIGHT.id];
            }
            if (have_main && have_left && have_right) {
                if (is_main) {
                    return this.craftingValues[KeyCraftingZone.CASE_MAIN.id];
                }
                if (is_left) {
                    return this.craftingValues[KeyCraftingZone.CASE_LEFT.id];
                }
                if (is_right) {
                    return this.craftingValues[KeyCraftingZone.CASE_RIGHT.id];
                }
            }
            if (!(have_main || have_left || have_right)) {
                return 0x1D1D21;
            }
            if (have_main && !have_left && have_right) {
                return is_left || is_main ? this.craftingValues[KeyCraftingZone.CASE_MAIN.id] : this.craftingValues[KeyCraftingZone.CASE_RIGHT.id];
            }
            if (have_main && have_left && !have_right) {
                return is_right || is_main ? this.craftingValues[KeyCraftingZone.CASE_MAIN.id] : this.craftingValues[KeyCraftingZone.CASE_LEFT.id];
            }
            if (have_left && is_left) {
                return this.craftingValues[KeyCraftingZone.CASE_LEFT.id];
            }
            if (have_right && is_right) {
                return this.craftingValues[KeyCraftingZone.CASE_RIGHT.id];
            }
            return 0x1D1D21;
        }
        if (KeyCaps.isZoneType(tintIndex, KeyZone.FN_ZONES)) {
            if (!this.isDefault(KeyCraftingZone.FN_LEFT) && KeyZone.LEFT_FN_KEYS.equals(tintIndex)) {
                return this.craftingValues[KeyCraftingZone.FN_LEFT.id];
            }
            if (!this.isDefault(KeyCraftingZone.FN_RIGHT) && KeyZone.RIGHT_FN_KEYS.equals(tintIndex)) {
                return this.craftingValues[KeyCraftingZone.FN_RIGHT.id];
            }
            if (!this.isDefault(KeyCraftingZone.FN_MAIN)) {
                return this.craftingValues[KeyCraftingZone.FN_MAIN.id];
            }
        }
        if (!this.isDefault(KeyCraftingZone.TAB) && KeyZone.TAB_KEY.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.TAB.id];
        }
        if (!this.isDefault(KeyCraftingZone.ESC) && KeyZone.ESC_KEY.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.ESC.id];
        }
        if (!this.isDefault(KeyCraftingZone.CAPS) && KeyZone.CAPS_KEY.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.CAPS.id];
        }
        if (!this.isDefault(KeyCraftingZone.LSHIFT) && KeyZone.LSHIFT.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.LSHIFT.id];
        }
        if (!this.isDefault(KeyCraftingZone.RSHIFT) && KeyZone.RSHIFT.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.RSHIFT.id];
        }
        if (!this.isDefault(KeyCraftingZone.SPACE) && KeyZone.SPACE_KEY.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.SPACE.id];
        }
        if (!this.isDefault(KeyCraftingZone.ENTER) && KeyZone.ENTER_KEY.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.ENTER.id];
        }
        if (!this.isDefault(KeyCraftingZone.BACKSPACE) && KeyZone.BACK_KEY.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.BACKSPACE.id];
        }
        if (!this.isDefault(KeyCraftingZone.LEFT_MODIFIERS) && KeyZone.MODIFIER_KEYS_LEFT.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.LEFT_MODIFIERS.id];
        }
        if (!this.isDefault(KeyCraftingZone.RIGHT_MODIFIERS) && KeyZone.MODIFIER_KEYS_RIGHT.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.RIGHT_MODIFIERS.id];
        }
        if (!this.isDefault(KeyCraftingZone.NUM_ROW) && KeyZone.NUM_ROW.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.NUM_ROW.id];
        }
        if (!this.isDefault(KeyCraftingZone.WASD) && KeyZone.WASD_KEYS.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.WASD.id];
        }
        if (!this.isDefault(KeyCraftingZone.ARROWS) && KeyZone.ARROW_KEYS.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.ARROWS.id];
        }
        if (!this.isDefault(KeyCraftingZone.SCREEN_KEYS) && KeyZone.SCREEN_KEYS.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.SCREEN_KEYS.id];
        }
        if (!this.isDefault(KeyCraftingZone.SIDE_TOP) && KeyZone.TOP_SIDE_KEYS.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.SIDE_TOP.id];
        }
        if (!this.isDefault(KeyCraftingZone.SIDE_MID) && KeyZone.MID_SIDE_KEYS.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.SIDE_MID.id];
        }
        if (!this.isDefault(KeyCraftingZone.UTIL_KEYS) && KeyCaps.isZoneType(tintIndex, KeyZone.UTIL_ZONES)) {
            return this.craftingValues[KeyCraftingZone.UTIL_KEYS.id];
        }
        if (!this.isDefault(KeyCraftingZone.MAIN.zone())) {
            return this.craftingValues[KeyCraftingZone.MAIN.zone()];
        }
        return 0x1D1D21;
    }
}

