/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.EntityDetector;

import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.peripherals.EntityDetector.EntityDetectorPeripheral;
import com.samsthenerd.duckyperiphs.peripherals.IPeripheralTileDucky;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class EntityDetectorTile
extends BlockEntity
implements IPeripheralTileDucky {
    private EntityDetectorPeripheral edPeriph = new EntityDetectorPeripheral(this);
    Map<UUID, Entity> cachedEntities = null;

    public EntityDetectorTile(BlockEntityType<EntityDetectorTile> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public EntityDetectorTile(BlockPos pos, BlockState state) {
        this((BlockEntityType<EntityDetectorTile>)((BlockEntityType)DuckyPeriphs.ENTITY_DETECTOR_TILE.get()), pos, state);
    }

    @Override
    @Nullable
    public IPeripheral getPeripheral(@Nonnull Direction side) {
        if (this.edPeriph == null) {
            this.edPeriph = new EntityDetectorPeripheral(this);
        }
        return this.edPeriph;
    }

    public BlockPos m_58899_() {
        return this.f_58858_;
    }

    public Level m_58904_() {
        return this.f_58857_;
    }

    public List<Entity> nearbyEntities(AABB box) {
        return this.nearbyEntities(box, true);
    }

    public List<Entity> nearbyEntities(AABB box, Boolean livingOnly) {
        return this.f_58857_.m_6249_(null, box, entity -> livingOnly != false ? entity instanceof LivingEntity : true);
    }

    public AABB makeBox(int range, int yRange) {
        return new AABB(this.f_58858_).m_82377_((double)range, (double)yRange, (double)range);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, EntityDetectorTile ed_tile) {
        if (ed_tile == null) {
            return;
        }
        ed_tile.checkEntityChange();
    }

    private Map<UUID, Entity> entListToMap(List<Entity> entList) {
        HashMap<UUID, Entity> entMap = new HashMap<UUID, Entity>();
        for (Entity entity : entList) {
            entMap.put(entity.m_20148_(), entity);
        }
        return entMap;
    }

    public void checkEntityChange() {
        List<Entity> new_ents_list = this.nearbyEntities(this.makeBox(EntityDetectorPeripheral.DEFAULT_RANGE, EntityDetectorPeripheral.DEFAULT_Y_RANGE));
        Map<UUID, Entity> new_ents = this.entListToMap(new_ents_list);
        if (this.cachedEntities == null) {
            this.cachedEntities = new_ents;
            return;
        }
        for (UUID uuid : new_ents.keySet()) {
            if (this.cachedEntities.containsKey(uuid)) continue;
            this.edPeriph.newEntityEvent(new_ents.get(uuid));
        }
        for (UUID uuid : this.cachedEntities.keySet()) {
            if (new_ents.containsKey(uuid)) continue;
            this.edPeriph.removedEntityEvent(this.cachedEntities.get(uuid));
        }
        this.cachedEntities = new_ents;
    }
}

