/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.EntityDetector;

import com.samsthenerd.duckyperiphs.peripherals.EntityDetector.EntityDetectorTile;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;

public class EntityDetectorPeripheral
implements IPeripheral {
    public static int DEFAULT_RANGE = 8;
    public static int DEFAULT_Y_RANGE = 16;
    private final EntityDetectorTile edTile;
    public List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    EntityDetectorPeripheral(EntityDetectorTile edPTile) {
        this.edTile = edPTile;
    }

    @Nonnull
    public String getType() {
        return "entity_detector";
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @LuaFunction
    public final Map<String, Object>[] nearbyEntities() {
        AABB rangeBox = this.edTile.makeBox(DEFAULT_RANGE, DEFAULT_Y_RANGE);
        List<Entity> entities = this.edTile.nearbyEntities(rangeBox);
        Map[] entityMaps = new Map[entities.size()];
        BlockPos edPos = this.edTile.m_58899_();
        for (int e = 0; e < entities.size(); ++e) {
            Entity entity = entities.get(e);
            HashMap<String, Object> entityMap = new HashMap<String, Object>();
            entityMap.put("uuid", entity.m_20148_().toString());
            entityMap.put("name", entity.m_7755_().getString());
            boolean isPlayer = entity.m_142389_();
            entityMap.put("isPlayer", isPlayer);
            entityMap.put("type", entity.m_6095_().m_20676_().getString());
            entityMap.put("x", entity.m_20185_() - (double)edPos.m_123341_());
            entityMap.put("y", entity.m_20186_() - (double)edPos.m_123342_());
            entityMap.put("z", entity.m_20189_() - (double)edPos.m_123343_());
            entityMaps[e] = entityMap;
        }
        return entityMaps;
    }

    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public void newEntityEvent(Entity entity) {
        BlockPos edPos = this.edTile.m_58899_();
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        entityMap.put("uuid", entity.m_20148_().toString());
        entityMap.put("name", entity.m_7755_().getString());
        boolean isPlayer = entity.m_142389_();
        entityMap.put("isPlayer", isPlayer);
        entityMap.put("type", entity.m_6095_().m_20676_().getString());
        entityMap.put("x", entity.m_20185_() - (double)edPos.m_123341_());
        entityMap.put("y", entity.m_20186_() - (double)edPos.m_123342_());
        entityMap.put("z", entity.m_20189_() - (double)edPos.m_123343_());
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("new_entity", new Object[]{computer.getAttachmentName(), entityMap});
        }
    }

    public void removedEntityEvent(Entity entity) {
        BlockPos edPos = this.edTile.m_58899_();
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        entityMap.put("uuid", entity.m_20148_().toString());
        entityMap.put("name", entity.m_7755_().getString());
        boolean isPlayer = entity.m_142389_();
        entityMap.put("isPlayer", isPlayer);
        entityMap.put("type", entity.m_6095_().m_20676_().getString());
        entityMap.put("x", entity.m_20185_() - (double)edPos.m_123341_());
        entityMap.put("y", entity.m_20186_() - (double)edPos.m_123342_());
        entityMap.put("z", entity.m_20189_() - (double)edPos.m_123343_());
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("removed_entity", new Object[]{computer.getAttachmentName(), entityMap});
        }
    }
}

